/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtOpenRoutingTableRequest is the corresponding interface of ApduDataExtOpenRoutingTableRequest
type ApduDataExtOpenRoutingTableRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtOpenRoutingTableRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtOpenRoutingTableRequest()
	// CreateBuilder creates a ApduDataExtOpenRoutingTableRequestBuilder
	CreateApduDataExtOpenRoutingTableRequestBuilder() ApduDataExtOpenRoutingTableRequestBuilder
}

// _ApduDataExtOpenRoutingTableRequest is the data-structure of this message
type _ApduDataExtOpenRoutingTableRequest struct {
	ApduDataExtContract
}

var _ ApduDataExtOpenRoutingTableRequest = (*_ApduDataExtOpenRoutingTableRequest)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtOpenRoutingTableRequest)(nil)

// NewApduDataExtOpenRoutingTableRequest factory function for _ApduDataExtOpenRoutingTableRequest
func NewApduDataExtOpenRoutingTableRequest(length uint8) *_ApduDataExtOpenRoutingTableRequest {
	_result := &_ApduDataExtOpenRoutingTableRequest{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtOpenRoutingTableRequestBuilder is a builder for ApduDataExtOpenRoutingTableRequest
type ApduDataExtOpenRoutingTableRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtOpenRoutingTableRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtOpenRoutingTableRequest or returns an error if something is wrong
	Build() (ApduDataExtOpenRoutingTableRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtOpenRoutingTableRequest
}

// NewApduDataExtOpenRoutingTableRequestBuilder() creates a ApduDataExtOpenRoutingTableRequestBuilder
func NewApduDataExtOpenRoutingTableRequestBuilder() ApduDataExtOpenRoutingTableRequestBuilder {
	return &_ApduDataExtOpenRoutingTableRequestBuilder{_ApduDataExtOpenRoutingTableRequest: new(_ApduDataExtOpenRoutingTableRequest)}
}

type _ApduDataExtOpenRoutingTableRequestBuilder struct {
	*_ApduDataExtOpenRoutingTableRequest

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtOpenRoutingTableRequestBuilder) = (*_ApduDataExtOpenRoutingTableRequestBuilder)(nil)

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtOpenRoutingTableRequest
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) WithMandatoryFields() ApduDataExtOpenRoutingTableRequestBuilder {
	return b
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) Build() (ApduDataExtOpenRoutingTableRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtOpenRoutingTableRequest.deepCopy(), nil
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) MustBuild() ApduDataExtOpenRoutingTableRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtOpenRoutingTableRequestBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtOpenRoutingTableRequestBuilder().(*_ApduDataExtOpenRoutingTableRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtOpenRoutingTableRequestBuilder creates a ApduDataExtOpenRoutingTableRequestBuilder
func (b *_ApduDataExtOpenRoutingTableRequest) CreateApduDataExtOpenRoutingTableRequestBuilder() ApduDataExtOpenRoutingTableRequestBuilder {
	if b == nil {
		return NewApduDataExtOpenRoutingTableRequestBuilder()
	}
	return &_ApduDataExtOpenRoutingTableRequestBuilder{_ApduDataExtOpenRoutingTableRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtOpenRoutingTableRequest) GetExtApciType() uint8 {
	return 0x00
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtOpenRoutingTableRequest) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtOpenRoutingTableRequest(structType any) ApduDataExtOpenRoutingTableRequest {
	if casted, ok := structType.(ApduDataExtOpenRoutingTableRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtOpenRoutingTableRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtOpenRoutingTableRequest) GetTypeName() string {
	return "ApduDataExtOpenRoutingTableRequest"
}

func (m *_ApduDataExtOpenRoutingTableRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtOpenRoutingTableRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtOpenRoutingTableRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtOpenRoutingTableRequest ApduDataExtOpenRoutingTableRequest, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtOpenRoutingTableRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtOpenRoutingTableRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtOpenRoutingTableRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtOpenRoutingTableRequest")
	}

	return m, nil
}

func (m *_ApduDataExtOpenRoutingTableRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtOpenRoutingTableRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtOpenRoutingTableRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtOpenRoutingTableRequest")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtOpenRoutingTableRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtOpenRoutingTableRequest")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtOpenRoutingTableRequest) IsApduDataExtOpenRoutingTableRequest() {}

func (m *_ApduDataExtOpenRoutingTableRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtOpenRoutingTableRequest) deepCopy() *_ApduDataExtOpenRoutingTableRequest {
	if m == nil {
		return nil
	}
	_ApduDataExtOpenRoutingTableRequestCopy := &_ApduDataExtOpenRoutingTableRequest{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtOpenRoutingTableRequestCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtOpenRoutingTableRequestCopy
}

func (m *_ApduDataExtOpenRoutingTableRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
