/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtNetworkParameterResponse is the corresponding interface of ApduDataExtNetworkParameterResponse
type ApduDataExtNetworkParameterResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtNetworkParameterResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtNetworkParameterResponse()
	// CreateBuilder creates a ApduDataExtNetworkParameterResponseBuilder
	CreateApduDataExtNetworkParameterResponseBuilder() ApduDataExtNetworkParameterResponseBuilder
}

// _ApduDataExtNetworkParameterResponse is the data-structure of this message
type _ApduDataExtNetworkParameterResponse struct {
	ApduDataExtContract
}

var _ ApduDataExtNetworkParameterResponse = (*_ApduDataExtNetworkParameterResponse)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtNetworkParameterResponse)(nil)

// NewApduDataExtNetworkParameterResponse factory function for _ApduDataExtNetworkParameterResponse
func NewApduDataExtNetworkParameterResponse(length uint8) *_ApduDataExtNetworkParameterResponse {
	_result := &_ApduDataExtNetworkParameterResponse{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtNetworkParameterResponseBuilder is a builder for ApduDataExtNetworkParameterResponse
type ApduDataExtNetworkParameterResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtNetworkParameterResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtNetworkParameterResponse or returns an error if something is wrong
	Build() (ApduDataExtNetworkParameterResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtNetworkParameterResponse
}

// NewApduDataExtNetworkParameterResponseBuilder() creates a ApduDataExtNetworkParameterResponseBuilder
func NewApduDataExtNetworkParameterResponseBuilder() ApduDataExtNetworkParameterResponseBuilder {
	return &_ApduDataExtNetworkParameterResponseBuilder{_ApduDataExtNetworkParameterResponse: new(_ApduDataExtNetworkParameterResponse)}
}

type _ApduDataExtNetworkParameterResponseBuilder struct {
	*_ApduDataExtNetworkParameterResponse

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtNetworkParameterResponseBuilder) = (*_ApduDataExtNetworkParameterResponseBuilder)(nil)

func (b *_ApduDataExtNetworkParameterResponseBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtNetworkParameterResponse
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) WithMandatoryFields() ApduDataExtNetworkParameterResponseBuilder {
	return b
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) Build() (ApduDataExtNetworkParameterResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtNetworkParameterResponse.deepCopy(), nil
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) MustBuild() ApduDataExtNetworkParameterResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtNetworkParameterResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtNetworkParameterResponseBuilder().(*_ApduDataExtNetworkParameterResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtNetworkParameterResponseBuilder creates a ApduDataExtNetworkParameterResponseBuilder
func (b *_ApduDataExtNetworkParameterResponse) CreateApduDataExtNetworkParameterResponseBuilder() ApduDataExtNetworkParameterResponseBuilder {
	if b == nil {
		return NewApduDataExtNetworkParameterResponseBuilder()
	}
	return &_ApduDataExtNetworkParameterResponseBuilder{_ApduDataExtNetworkParameterResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtNetworkParameterResponse) GetExtApciType() uint8 {
	return 0x1B
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtNetworkParameterResponse) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtNetworkParameterResponse(structType any) ApduDataExtNetworkParameterResponse {
	if casted, ok := structType.(ApduDataExtNetworkParameterResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtNetworkParameterResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtNetworkParameterResponse) GetTypeName() string {
	return "ApduDataExtNetworkParameterResponse"
}

func (m *_ApduDataExtNetworkParameterResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtNetworkParameterResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtNetworkParameterResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtNetworkParameterResponse ApduDataExtNetworkParameterResponse, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtNetworkParameterResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtNetworkParameterResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtNetworkParameterResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtNetworkParameterResponse")
	}

	return m, nil
}

func (m *_ApduDataExtNetworkParameterResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtNetworkParameterResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtNetworkParameterResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtNetworkParameterResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtNetworkParameterResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtNetworkParameterResponse")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtNetworkParameterResponse) IsApduDataExtNetworkParameterResponse() {}

func (m *_ApduDataExtNetworkParameterResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtNetworkParameterResponse) deepCopy() *_ApduDataExtNetworkParameterResponse {
	if m == nil {
		return nil
	}
	_ApduDataExtNetworkParameterResponseCopy := &_ApduDataExtNetworkParameterResponse{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtNetworkParameterResponseCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtNetworkParameterResponseCopy
}

func (m *_ApduDataExtNetworkParameterResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
