/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtKeyWrite is the corresponding interface of ApduDataExtKeyWrite
type ApduDataExtKeyWrite interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtKeyWrite is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtKeyWrite()
	// CreateBuilder creates a ApduDataExtKeyWriteBuilder
	CreateApduDataExtKeyWriteBuilder() ApduDataExtKeyWriteBuilder
}

// _ApduDataExtKeyWrite is the data-structure of this message
type _ApduDataExtKeyWrite struct {
	ApduDataExtContract
}

var _ ApduDataExtKeyWrite = (*_ApduDataExtKeyWrite)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtKeyWrite)(nil)

// NewApduDataExtKeyWrite factory function for _ApduDataExtKeyWrite
func NewApduDataExtKeyWrite(length uint8) *_ApduDataExtKeyWrite {
	_result := &_ApduDataExtKeyWrite{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtKeyWriteBuilder is a builder for ApduDataExtKeyWrite
type ApduDataExtKeyWriteBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtKeyWriteBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtKeyWrite or returns an error if something is wrong
	Build() (ApduDataExtKeyWrite, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtKeyWrite
}

// NewApduDataExtKeyWriteBuilder() creates a ApduDataExtKeyWriteBuilder
func NewApduDataExtKeyWriteBuilder() ApduDataExtKeyWriteBuilder {
	return &_ApduDataExtKeyWriteBuilder{_ApduDataExtKeyWrite: new(_ApduDataExtKeyWrite)}
}

type _ApduDataExtKeyWriteBuilder struct {
	*_ApduDataExtKeyWrite

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtKeyWriteBuilder) = (*_ApduDataExtKeyWriteBuilder)(nil)

func (b *_ApduDataExtKeyWriteBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtKeyWrite
}

func (b *_ApduDataExtKeyWriteBuilder) WithMandatoryFields() ApduDataExtKeyWriteBuilder {
	return b
}

func (b *_ApduDataExtKeyWriteBuilder) Build() (ApduDataExtKeyWrite, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtKeyWrite.deepCopy(), nil
}

func (b *_ApduDataExtKeyWriteBuilder) MustBuild() ApduDataExtKeyWrite {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtKeyWriteBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtKeyWriteBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtKeyWriteBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtKeyWriteBuilder().(*_ApduDataExtKeyWriteBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtKeyWriteBuilder creates a ApduDataExtKeyWriteBuilder
func (b *_ApduDataExtKeyWrite) CreateApduDataExtKeyWriteBuilder() ApduDataExtKeyWriteBuilder {
	if b == nil {
		return NewApduDataExtKeyWriteBuilder()
	}
	return &_ApduDataExtKeyWriteBuilder{_ApduDataExtKeyWrite: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtKeyWrite) GetExtApciType() uint8 {
	return 0x13
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtKeyWrite) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtKeyWrite(structType any) ApduDataExtKeyWrite {
	if casted, ok := structType.(ApduDataExtKeyWrite); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtKeyWrite); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtKeyWrite) GetTypeName() string {
	return "ApduDataExtKeyWrite"
}

func (m *_ApduDataExtKeyWrite) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtKeyWrite) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtKeyWrite) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtKeyWrite ApduDataExtKeyWrite, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtKeyWrite"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtKeyWrite")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtKeyWrite"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtKeyWrite")
	}

	return m, nil
}

func (m *_ApduDataExtKeyWrite) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtKeyWrite) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtKeyWrite"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtKeyWrite")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtKeyWrite"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtKeyWrite")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtKeyWrite) IsApduDataExtKeyWrite() {}

func (m *_ApduDataExtKeyWrite) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtKeyWrite) deepCopy() *_ApduDataExtKeyWrite {
	if m == nil {
		return nil
	}
	_ApduDataExtKeyWriteCopy := &_ApduDataExtKeyWrite{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtKeyWriteCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtKeyWriteCopy
}

func (m *_ApduDataExtKeyWrite) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
