/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtGroupPropertyValueRead is the corresponding interface of ApduDataExtGroupPropertyValueRead
type ApduDataExtGroupPropertyValueRead interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtGroupPropertyValueRead is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtGroupPropertyValueRead()
	// CreateBuilder creates a ApduDataExtGroupPropertyValueReadBuilder
	CreateApduDataExtGroupPropertyValueReadBuilder() ApduDataExtGroupPropertyValueReadBuilder
}

// _ApduDataExtGroupPropertyValueRead is the data-structure of this message
type _ApduDataExtGroupPropertyValueRead struct {
	ApduDataExtContract
}

var _ ApduDataExtGroupPropertyValueRead = (*_ApduDataExtGroupPropertyValueRead)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtGroupPropertyValueRead)(nil)

// NewApduDataExtGroupPropertyValueRead factory function for _ApduDataExtGroupPropertyValueRead
func NewApduDataExtGroupPropertyValueRead(length uint8) *_ApduDataExtGroupPropertyValueRead {
	_result := &_ApduDataExtGroupPropertyValueRead{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtGroupPropertyValueReadBuilder is a builder for ApduDataExtGroupPropertyValueRead
type ApduDataExtGroupPropertyValueReadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtGroupPropertyValueReadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtGroupPropertyValueRead or returns an error if something is wrong
	Build() (ApduDataExtGroupPropertyValueRead, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtGroupPropertyValueRead
}

// NewApduDataExtGroupPropertyValueReadBuilder() creates a ApduDataExtGroupPropertyValueReadBuilder
func NewApduDataExtGroupPropertyValueReadBuilder() ApduDataExtGroupPropertyValueReadBuilder {
	return &_ApduDataExtGroupPropertyValueReadBuilder{_ApduDataExtGroupPropertyValueRead: new(_ApduDataExtGroupPropertyValueRead)}
}

type _ApduDataExtGroupPropertyValueReadBuilder struct {
	*_ApduDataExtGroupPropertyValueRead

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtGroupPropertyValueReadBuilder) = (*_ApduDataExtGroupPropertyValueReadBuilder)(nil)

func (b *_ApduDataExtGroupPropertyValueReadBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtGroupPropertyValueRead
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) WithMandatoryFields() ApduDataExtGroupPropertyValueReadBuilder {
	return b
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) Build() (ApduDataExtGroupPropertyValueRead, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtGroupPropertyValueRead.deepCopy(), nil
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) MustBuild() ApduDataExtGroupPropertyValueRead {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtGroupPropertyValueReadBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtGroupPropertyValueReadBuilder().(*_ApduDataExtGroupPropertyValueReadBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtGroupPropertyValueReadBuilder creates a ApduDataExtGroupPropertyValueReadBuilder
func (b *_ApduDataExtGroupPropertyValueRead) CreateApduDataExtGroupPropertyValueReadBuilder() ApduDataExtGroupPropertyValueReadBuilder {
	if b == nil {
		return NewApduDataExtGroupPropertyValueReadBuilder()
	}
	return &_ApduDataExtGroupPropertyValueReadBuilder{_ApduDataExtGroupPropertyValueRead: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtGroupPropertyValueRead) GetExtApciType() uint8 {
	return 0x28
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtGroupPropertyValueRead) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtGroupPropertyValueRead(structType any) ApduDataExtGroupPropertyValueRead {
	if casted, ok := structType.(ApduDataExtGroupPropertyValueRead); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtGroupPropertyValueRead); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtGroupPropertyValueRead) GetTypeName() string {
	return "ApduDataExtGroupPropertyValueRead"
}

func (m *_ApduDataExtGroupPropertyValueRead) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtGroupPropertyValueRead) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtGroupPropertyValueRead) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtGroupPropertyValueRead ApduDataExtGroupPropertyValueRead, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtGroupPropertyValueRead"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtGroupPropertyValueRead")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtGroupPropertyValueRead"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtGroupPropertyValueRead")
	}

	return m, nil
}

func (m *_ApduDataExtGroupPropertyValueRead) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtGroupPropertyValueRead) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtGroupPropertyValueRead"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtGroupPropertyValueRead")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtGroupPropertyValueRead"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtGroupPropertyValueRead")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtGroupPropertyValueRead) IsApduDataExtGroupPropertyValueRead() {}

func (m *_ApduDataExtGroupPropertyValueRead) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtGroupPropertyValueRead) deepCopy() *_ApduDataExtGroupPropertyValueRead {
	if m == nil {
		return nil
	}
	_ApduDataExtGroupPropertyValueReadCopy := &_ApduDataExtGroupPropertyValueRead{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtGroupPropertyValueReadCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtGroupPropertyValueReadCopy
}

func (m *_ApduDataExtGroupPropertyValueRead) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
