/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtDomainAddressResponse is the corresponding interface of ApduDataExtDomainAddressResponse
type ApduDataExtDomainAddressResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtDomainAddressResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtDomainAddressResponse()
	// CreateBuilder creates a ApduDataExtDomainAddressResponseBuilder
	CreateApduDataExtDomainAddressResponseBuilder() ApduDataExtDomainAddressResponseBuilder
}

// _ApduDataExtDomainAddressResponse is the data-structure of this message
type _ApduDataExtDomainAddressResponse struct {
	ApduDataExtContract
}

var _ ApduDataExtDomainAddressResponse = (*_ApduDataExtDomainAddressResponse)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtDomainAddressResponse)(nil)

// NewApduDataExtDomainAddressResponse factory function for _ApduDataExtDomainAddressResponse
func NewApduDataExtDomainAddressResponse(length uint8) *_ApduDataExtDomainAddressResponse {
	_result := &_ApduDataExtDomainAddressResponse{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtDomainAddressResponseBuilder is a builder for ApduDataExtDomainAddressResponse
type ApduDataExtDomainAddressResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtDomainAddressResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtDomainAddressResponse or returns an error if something is wrong
	Build() (ApduDataExtDomainAddressResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtDomainAddressResponse
}

// NewApduDataExtDomainAddressResponseBuilder() creates a ApduDataExtDomainAddressResponseBuilder
func NewApduDataExtDomainAddressResponseBuilder() ApduDataExtDomainAddressResponseBuilder {
	return &_ApduDataExtDomainAddressResponseBuilder{_ApduDataExtDomainAddressResponse: new(_ApduDataExtDomainAddressResponse)}
}

type _ApduDataExtDomainAddressResponseBuilder struct {
	*_ApduDataExtDomainAddressResponse

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtDomainAddressResponseBuilder) = (*_ApduDataExtDomainAddressResponseBuilder)(nil)

func (b *_ApduDataExtDomainAddressResponseBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtDomainAddressResponse
}

func (b *_ApduDataExtDomainAddressResponseBuilder) WithMandatoryFields() ApduDataExtDomainAddressResponseBuilder {
	return b
}

func (b *_ApduDataExtDomainAddressResponseBuilder) Build() (ApduDataExtDomainAddressResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtDomainAddressResponse.deepCopy(), nil
}

func (b *_ApduDataExtDomainAddressResponseBuilder) MustBuild() ApduDataExtDomainAddressResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtDomainAddressResponseBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtDomainAddressResponseBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtDomainAddressResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtDomainAddressResponseBuilder().(*_ApduDataExtDomainAddressResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtDomainAddressResponseBuilder creates a ApduDataExtDomainAddressResponseBuilder
func (b *_ApduDataExtDomainAddressResponse) CreateApduDataExtDomainAddressResponseBuilder() ApduDataExtDomainAddressResponseBuilder {
	if b == nil {
		return NewApduDataExtDomainAddressResponseBuilder()
	}
	return &_ApduDataExtDomainAddressResponseBuilder{_ApduDataExtDomainAddressResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtDomainAddressResponse) GetExtApciType() uint8 {
	return 0x22
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtDomainAddressResponse) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtDomainAddressResponse(structType any) ApduDataExtDomainAddressResponse {
	if casted, ok := structType.(ApduDataExtDomainAddressResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtDomainAddressResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtDomainAddressResponse) GetTypeName() string {
	return "ApduDataExtDomainAddressResponse"
}

func (m *_ApduDataExtDomainAddressResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtDomainAddressResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtDomainAddressResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtDomainAddressResponse ApduDataExtDomainAddressResponse, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtDomainAddressResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtDomainAddressResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtDomainAddressResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtDomainAddressResponse")
	}

	return m, nil
}

func (m *_ApduDataExtDomainAddressResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtDomainAddressResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtDomainAddressResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtDomainAddressResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtDomainAddressResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtDomainAddressResponse")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtDomainAddressResponse) IsApduDataExtDomainAddressResponse() {}

func (m *_ApduDataExtDomainAddressResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtDomainAddressResponse) deepCopy() *_ApduDataExtDomainAddressResponse {
	if m == nil {
		return nil
	}
	_ApduDataExtDomainAddressResponseCopy := &_ApduDataExtDomainAddressResponse{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtDomainAddressResponseCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtDomainAddressResponseCopy
}

func (m *_ApduDataExtDomainAddressResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
