/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SysexCommandAnalogMappingResponse is the corresponding interface of SysexCommandAnalogMappingResponse
type SysexCommandAnalogMappingResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SysexCommand
	// IsSysexCommandAnalogMappingResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSysexCommandAnalogMappingResponse()
	// CreateBuilder creates a SysexCommandAnalogMappingResponseBuilder
	CreateSysexCommandAnalogMappingResponseBuilder() SysexCommandAnalogMappingResponseBuilder
}

// _SysexCommandAnalogMappingResponse is the data-structure of this message
type _SysexCommandAnalogMappingResponse struct {
	SysexCommandContract
}

var _ SysexCommandAnalogMappingResponse = (*_SysexCommandAnalogMappingResponse)(nil)
var _ SysexCommandRequirements = (*_SysexCommandAnalogMappingResponse)(nil)

// NewSysexCommandAnalogMappingResponse factory function for _SysexCommandAnalogMappingResponse
func NewSysexCommandAnalogMappingResponse() *_SysexCommandAnalogMappingResponse {
	_result := &_SysexCommandAnalogMappingResponse{
		SysexCommandContract: NewSysexCommand(),
	}
	_result.SysexCommandContract.(*_SysexCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SysexCommandAnalogMappingResponseBuilder is a builder for SysexCommandAnalogMappingResponse
type SysexCommandAnalogMappingResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SysexCommandAnalogMappingResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SysexCommandBuilder
	// Build builds the SysexCommandAnalogMappingResponse or returns an error if something is wrong
	Build() (SysexCommandAnalogMappingResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SysexCommandAnalogMappingResponse
}

// NewSysexCommandAnalogMappingResponseBuilder() creates a SysexCommandAnalogMappingResponseBuilder
func NewSysexCommandAnalogMappingResponseBuilder() SysexCommandAnalogMappingResponseBuilder {
	return &_SysexCommandAnalogMappingResponseBuilder{_SysexCommandAnalogMappingResponse: new(_SysexCommandAnalogMappingResponse)}
}

type _SysexCommandAnalogMappingResponseBuilder struct {
	*_SysexCommandAnalogMappingResponse

	parentBuilder *_SysexCommandBuilder

	err *utils.MultiError
}

var _ (SysexCommandAnalogMappingResponseBuilder) = (*_SysexCommandAnalogMappingResponseBuilder)(nil)

func (b *_SysexCommandAnalogMappingResponseBuilder) setParent(contract SysexCommandContract) {
	b.SysexCommandContract = contract
	contract.(*_SysexCommand)._SubType = b._SysexCommandAnalogMappingResponse
}

func (b *_SysexCommandAnalogMappingResponseBuilder) WithMandatoryFields() SysexCommandAnalogMappingResponseBuilder {
	return b
}

func (b *_SysexCommandAnalogMappingResponseBuilder) Build() (SysexCommandAnalogMappingResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SysexCommandAnalogMappingResponse.deepCopy(), nil
}

func (b *_SysexCommandAnalogMappingResponseBuilder) MustBuild() SysexCommandAnalogMappingResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SysexCommandAnalogMappingResponseBuilder) Done() SysexCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSysexCommandBuilder().(*_SysexCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_SysexCommandAnalogMappingResponseBuilder) buildForSysexCommand() (SysexCommand, error) {
	return b.Build()
}

func (b *_SysexCommandAnalogMappingResponseBuilder) DeepCopy() any {
	_copy := b.CreateSysexCommandAnalogMappingResponseBuilder().(*_SysexCommandAnalogMappingResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSysexCommandAnalogMappingResponseBuilder creates a SysexCommandAnalogMappingResponseBuilder
func (b *_SysexCommandAnalogMappingResponse) CreateSysexCommandAnalogMappingResponseBuilder() SysexCommandAnalogMappingResponseBuilder {
	if b == nil {
		return NewSysexCommandAnalogMappingResponseBuilder()
	}
	return &_SysexCommandAnalogMappingResponseBuilder{_SysexCommandAnalogMappingResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SysexCommandAnalogMappingResponse) GetCommandType() uint8 {
	return 0x6A
}

func (m *_SysexCommandAnalogMappingResponse) GetResponse() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SysexCommandAnalogMappingResponse) GetParent() SysexCommandContract {
	return m.SysexCommandContract
}

// Deprecated: use the interface for direct cast
func CastSysexCommandAnalogMappingResponse(structType any) SysexCommandAnalogMappingResponse {
	if casted, ok := structType.(SysexCommandAnalogMappingResponse); ok {
		return casted
	}
	if casted, ok := structType.(*SysexCommandAnalogMappingResponse); ok {
		return *casted
	}
	return nil
}

func (m *_SysexCommandAnalogMappingResponse) GetTypeName() string {
	return "SysexCommandAnalogMappingResponse"
}

func (m *_SysexCommandAnalogMappingResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SysexCommandContract.(*_SysexCommand).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SysexCommandAnalogMappingResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SysexCommandAnalogMappingResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SysexCommand, response bool) (__sysexCommandAnalogMappingResponse SysexCommandAnalogMappingResponse, err error) {
	m.SysexCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SysexCommandAnalogMappingResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SysexCommandAnalogMappingResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SysexCommandAnalogMappingResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SysexCommandAnalogMappingResponse")
	}

	return m, nil
}

func (m *_SysexCommandAnalogMappingResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SysexCommandAnalogMappingResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SysexCommandAnalogMappingResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SysexCommandAnalogMappingResponse")
		}

		if popErr := writeBuffer.PopContext("SysexCommandAnalogMappingResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SysexCommandAnalogMappingResponse")
		}
		return nil
	}
	return m.SysexCommandContract.(*_SysexCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SysexCommandAnalogMappingResponse) IsSysexCommandAnalogMappingResponse() {}

func (m *_SysexCommandAnalogMappingResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SysexCommandAnalogMappingResponse) deepCopy() *_SysexCommandAnalogMappingResponse {
	if m == nil {
		return nil
	}
	_SysexCommandAnalogMappingResponseCopy := &_SysexCommandAnalogMappingResponse{
		m.SysexCommandContract.(*_SysexCommand).deepCopy(),
	}
	_SysexCommandAnalogMappingResponseCopy.SysexCommandContract.(*_SysexCommand)._SubType = m
	return _SysexCommandAnalogMappingResponseCopy
}

func (m *_SysexCommandAnalogMappingResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
