/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NullAddressItem is the corresponding interface of NullAddressItem
type NullAddressItem interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TypeId
	// IsNullAddressItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNullAddressItem()
	// CreateBuilder creates a NullAddressItemBuilder
	CreateNullAddressItemBuilder() NullAddressItemBuilder
}

// _NullAddressItem is the data-structure of this message
type _NullAddressItem struct {
	TypeIdContract
	// Reserved Fields
	reservedField0 *uint16
}

var _ NullAddressItem = (*_NullAddressItem)(nil)
var _ TypeIdRequirements = (*_NullAddressItem)(nil)

// NewNullAddressItem factory function for _NullAddressItem
func NewNullAddressItem() *_NullAddressItem {
	_result := &_NullAddressItem{
		TypeIdContract: NewTypeId(),
	}
	_result.TypeIdContract.(*_TypeId)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NullAddressItemBuilder is a builder for NullAddressItem
type NullAddressItemBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() NullAddressItemBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TypeIdBuilder
	// Build builds the NullAddressItem or returns an error if something is wrong
	Build() (NullAddressItem, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NullAddressItem
}

// NewNullAddressItemBuilder() creates a NullAddressItemBuilder
func NewNullAddressItemBuilder() NullAddressItemBuilder {
	return &_NullAddressItemBuilder{_NullAddressItem: new(_NullAddressItem)}
}

type _NullAddressItemBuilder struct {
	*_NullAddressItem

	parentBuilder *_TypeIdBuilder

	err *utils.MultiError
}

var _ (NullAddressItemBuilder) = (*_NullAddressItemBuilder)(nil)

func (b *_NullAddressItemBuilder) setParent(contract TypeIdContract) {
	b.TypeIdContract = contract
	contract.(*_TypeId)._SubType = b._NullAddressItem
}

func (b *_NullAddressItemBuilder) WithMandatoryFields() NullAddressItemBuilder {
	return b
}

func (b *_NullAddressItemBuilder) Build() (NullAddressItem, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NullAddressItem.deepCopy(), nil
}

func (b *_NullAddressItemBuilder) MustBuild() NullAddressItem {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NullAddressItemBuilder) Done() TypeIdBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTypeIdBuilder().(*_TypeIdBuilder)
	}
	return b.parentBuilder
}

func (b *_NullAddressItemBuilder) buildForTypeId() (TypeId, error) {
	return b.Build()
}

func (b *_NullAddressItemBuilder) DeepCopy() any {
	_copy := b.CreateNullAddressItemBuilder().(*_NullAddressItemBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNullAddressItemBuilder creates a NullAddressItemBuilder
func (b *_NullAddressItem) CreateNullAddressItemBuilder() NullAddressItemBuilder {
	if b == nil {
		return NewNullAddressItemBuilder()
	}
	return &_NullAddressItemBuilder{_NullAddressItem: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NullAddressItem) GetId() uint16 {
	return 0x0000
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NullAddressItem) GetParent() TypeIdContract {
	return m.TypeIdContract
}

// Deprecated: use the interface for direct cast
func CastNullAddressItem(structType any) NullAddressItem {
	if casted, ok := structType.(NullAddressItem); ok {
		return casted
	}
	if casted, ok := structType.(*NullAddressItem); ok {
		return *casted
	}
	return nil
}

func (m *_NullAddressItem) GetTypeName() string {
	return "NullAddressItem"
}

func (m *_NullAddressItem) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TypeIdContract.(*_TypeId).getLengthInBits(ctx))

	// Reserved Field (reserved)
	lengthInBits += 16

	return lengthInBits
}

func (m *_NullAddressItem) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NullAddressItem) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TypeId) (__nullAddressItem NullAddressItem, err error) {
	m.TypeIdContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NullAddressItem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NullAddressItem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedShort(readBuffer, uint8(16)), uint16(0x0000))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	if closeErr := readBuffer.CloseContext("NullAddressItem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NullAddressItem")
	}

	return m, nil
}

func (m *_NullAddressItem) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NullAddressItem) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NullAddressItem"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NullAddressItem")
		}

		if err := WriteReservedField[uint16](ctx, "reserved", uint16(0x0000), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if popErr := writeBuffer.PopContext("NullAddressItem"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NullAddressItem")
		}
		return nil
	}
	return m.TypeIdContract.(*_TypeId).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NullAddressItem) IsNullAddressItem() {}

func (m *_NullAddressItem) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NullAddressItem) deepCopy() *_NullAddressItem {
	if m == nil {
		return nil
	}
	_NullAddressItemCopy := &_NullAddressItem{
		m.TypeIdContract.(*_TypeId).deepCopy(),
		m.reservedField0,
	}
	_NullAddressItemCopy.TypeIdContract.(*_TypeId)._SubType = m
	return _NullAddressItemCopy
}

func (m *_NullAddressItem) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
