/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ListServicesResponse is the corresponding interface of ListServicesResponse
type ListServicesResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	EipPacket
	// GetTypeIds returns TypeIds (property field)
	GetTypeIds() []TypeId
	// IsListServicesResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsListServicesResponse()
	// CreateBuilder creates a ListServicesResponseBuilder
	CreateListServicesResponseBuilder() ListServicesResponseBuilder
}

// _ListServicesResponse is the data-structure of this message
type _ListServicesResponse struct {
	EipPacketContract
	TypeIds []TypeId
}

var _ ListServicesResponse = (*_ListServicesResponse)(nil)
var _ EipPacketRequirements = (*_ListServicesResponse)(nil)

// NewListServicesResponse factory function for _ListServicesResponse
func NewListServicesResponse(sessionHandle uint32, status uint32, senderContext []byte, options uint32, typeIds []TypeId) *_ListServicesResponse {
	_result := &_ListServicesResponse{
		EipPacketContract: NewEipPacket(sessionHandle, status, senderContext, options),
		TypeIds:           typeIds,
	}
	_result.EipPacketContract.(*_EipPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ListServicesResponseBuilder is a builder for ListServicesResponse
type ListServicesResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(typeIds []TypeId) ListServicesResponseBuilder
	// WithTypeIds adds TypeIds (property field)
	WithTypeIds(...TypeId) ListServicesResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() EipPacketBuilder
	// Build builds the ListServicesResponse or returns an error if something is wrong
	Build() (ListServicesResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ListServicesResponse
}

// NewListServicesResponseBuilder() creates a ListServicesResponseBuilder
func NewListServicesResponseBuilder() ListServicesResponseBuilder {
	return &_ListServicesResponseBuilder{_ListServicesResponse: new(_ListServicesResponse)}
}

type _ListServicesResponseBuilder struct {
	*_ListServicesResponse

	parentBuilder *_EipPacketBuilder

	err *utils.MultiError
}

var _ (ListServicesResponseBuilder) = (*_ListServicesResponseBuilder)(nil)

func (b *_ListServicesResponseBuilder) setParent(contract EipPacketContract) {
	b.EipPacketContract = contract
	contract.(*_EipPacket)._SubType = b._ListServicesResponse
}

func (b *_ListServicesResponseBuilder) WithMandatoryFields(typeIds []TypeId) ListServicesResponseBuilder {
	return b.WithTypeIds(typeIds...)
}

func (b *_ListServicesResponseBuilder) WithTypeIds(typeIds ...TypeId) ListServicesResponseBuilder {
	b.TypeIds = typeIds
	return b
}

func (b *_ListServicesResponseBuilder) Build() (ListServicesResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ListServicesResponse.deepCopy(), nil
}

func (b *_ListServicesResponseBuilder) MustBuild() ListServicesResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ListServicesResponseBuilder) Done() EipPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewEipPacketBuilder().(*_EipPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_ListServicesResponseBuilder) buildForEipPacket() (EipPacket, error) {
	return b.Build()
}

func (b *_ListServicesResponseBuilder) DeepCopy() any {
	_copy := b.CreateListServicesResponseBuilder().(*_ListServicesResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateListServicesResponseBuilder creates a ListServicesResponseBuilder
func (b *_ListServicesResponse) CreateListServicesResponseBuilder() ListServicesResponseBuilder {
	if b == nil {
		return NewListServicesResponseBuilder()
	}
	return &_ListServicesResponseBuilder{_ListServicesResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ListServicesResponse) GetCommand() uint16 {
	return 0x0004
}

func (m *_ListServicesResponse) GetResponse() bool {
	return bool(true)
}

func (m *_ListServicesResponse) GetPacketLength() uint16 {
	return 0
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ListServicesResponse) GetParent() EipPacketContract {
	return m.EipPacketContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ListServicesResponse) GetTypeIds() []TypeId {
	return m.TypeIds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastListServicesResponse(structType any) ListServicesResponse {
	if casted, ok := structType.(ListServicesResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ListServicesResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ListServicesResponse) GetTypeName() string {
	return "ListServicesResponse"
}

func (m *_ListServicesResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.EipPacketContract.(*_EipPacket).getLengthInBits(ctx))

	// Implicit Field (typeIdCount)
	lengthInBits += 16

	// Array field
	if len(m.TypeIds) > 0 {
		for _curItem, element := range m.TypeIds {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.TypeIds), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ListServicesResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ListServicesResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_EipPacket, response bool) (__listServicesResponse ListServicesResponse, err error) {
	m.EipPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ListServicesResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ListServicesResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	typeIdCount, err := ReadImplicitField[uint16](ctx, "typeIdCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'typeIdCount' field"))
	}
	_ = typeIdCount

	typeIds, err := ReadCountArrayField[TypeId](ctx, "typeIds", ReadComplex[TypeId](TypeIdParseWithBuffer, readBuffer), uint64(typeIdCount))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'typeIds' field"))
	}
	m.TypeIds = typeIds

	if closeErr := readBuffer.CloseContext("ListServicesResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ListServicesResponse")
	}

	return m, nil
}

func (m *_ListServicesResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ListServicesResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ListServicesResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ListServicesResponse")
		}
		typeIdCount := uint16(uint16(len(m.GetTypeIds())))
		if err := WriteImplicitField(ctx, "typeIdCount", typeIdCount, WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'typeIdCount' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "typeIds", m.GetTypeIds(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'typeIds' field")
		}

		if popErr := writeBuffer.PopContext("ListServicesResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ListServicesResponse")
		}
		return nil
	}
	return m.EipPacketContract.(*_EipPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ListServicesResponse) IsListServicesResponse() {}

func (m *_ListServicesResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ListServicesResponse) deepCopy() *_ListServicesResponse {
	if m == nil {
		return nil
	}
	_ListServicesResponseCopy := &_ListServicesResponse{
		m.EipPacketContract.(*_EipPacket).deepCopy(),
		utils.DeepCopySlice[TypeId, TypeId](m.TypeIds),
	}
	_ListServicesResponseCopy.EipPacketContract.(*_EipPacket)._SubType = m
	return _ListServicesResponseCopy
}

func (m *_ListServicesResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
