/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// GetAttributeSingleResponse is the corresponding interface of GetAttributeSingleResponse
type GetAttributeSingleResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CipService
	// IsGetAttributeSingleResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsGetAttributeSingleResponse()
	// CreateBuilder creates a GetAttributeSingleResponseBuilder
	CreateGetAttributeSingleResponseBuilder() GetAttributeSingleResponseBuilder
}

// _GetAttributeSingleResponse is the data-structure of this message
type _GetAttributeSingleResponse struct {
	CipServiceContract
}

var _ GetAttributeSingleResponse = (*_GetAttributeSingleResponse)(nil)
var _ CipServiceRequirements = (*_GetAttributeSingleResponse)(nil)

// NewGetAttributeSingleResponse factory function for _GetAttributeSingleResponse
func NewGetAttributeSingleResponse(serviceLen uint16) *_GetAttributeSingleResponse {
	_result := &_GetAttributeSingleResponse{
		CipServiceContract: NewCipService(serviceLen),
	}
	_result.CipServiceContract.(*_CipService)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// GetAttributeSingleResponseBuilder is a builder for GetAttributeSingleResponse
type GetAttributeSingleResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() GetAttributeSingleResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CipServiceBuilder
	// Build builds the GetAttributeSingleResponse or returns an error if something is wrong
	Build() (GetAttributeSingleResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() GetAttributeSingleResponse
}

// NewGetAttributeSingleResponseBuilder() creates a GetAttributeSingleResponseBuilder
func NewGetAttributeSingleResponseBuilder() GetAttributeSingleResponseBuilder {
	return &_GetAttributeSingleResponseBuilder{_GetAttributeSingleResponse: new(_GetAttributeSingleResponse)}
}

type _GetAttributeSingleResponseBuilder struct {
	*_GetAttributeSingleResponse

	parentBuilder *_CipServiceBuilder

	err *utils.MultiError
}

var _ (GetAttributeSingleResponseBuilder) = (*_GetAttributeSingleResponseBuilder)(nil)

func (b *_GetAttributeSingleResponseBuilder) setParent(contract CipServiceContract) {
	b.CipServiceContract = contract
	contract.(*_CipService)._SubType = b._GetAttributeSingleResponse
}

func (b *_GetAttributeSingleResponseBuilder) WithMandatoryFields() GetAttributeSingleResponseBuilder {
	return b
}

func (b *_GetAttributeSingleResponseBuilder) Build() (GetAttributeSingleResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._GetAttributeSingleResponse.deepCopy(), nil
}

func (b *_GetAttributeSingleResponseBuilder) MustBuild() GetAttributeSingleResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_GetAttributeSingleResponseBuilder) Done() CipServiceBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCipServiceBuilder().(*_CipServiceBuilder)
	}
	return b.parentBuilder
}

func (b *_GetAttributeSingleResponseBuilder) buildForCipService() (CipService, error) {
	return b.Build()
}

func (b *_GetAttributeSingleResponseBuilder) DeepCopy() any {
	_copy := b.CreateGetAttributeSingleResponseBuilder().(*_GetAttributeSingleResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateGetAttributeSingleResponseBuilder creates a GetAttributeSingleResponseBuilder
func (b *_GetAttributeSingleResponse) CreateGetAttributeSingleResponseBuilder() GetAttributeSingleResponseBuilder {
	if b == nil {
		return NewGetAttributeSingleResponseBuilder()
	}
	return &_GetAttributeSingleResponseBuilder{_GetAttributeSingleResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_GetAttributeSingleResponse) GetService() uint8 {
	return 0x0E
}

func (m *_GetAttributeSingleResponse) GetResponse() bool {
	return bool(true)
}

func (m *_GetAttributeSingleResponse) GetConnected() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_GetAttributeSingleResponse) GetParent() CipServiceContract {
	return m.CipServiceContract
}

// Deprecated: use the interface for direct cast
func CastGetAttributeSingleResponse(structType any) GetAttributeSingleResponse {
	if casted, ok := structType.(GetAttributeSingleResponse); ok {
		return casted
	}
	if casted, ok := structType.(*GetAttributeSingleResponse); ok {
		return *casted
	}
	return nil
}

func (m *_GetAttributeSingleResponse) GetTypeName() string {
	return "GetAttributeSingleResponse"
}

func (m *_GetAttributeSingleResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CipServiceContract.(*_CipService).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_GetAttributeSingleResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_GetAttributeSingleResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CipService, connected bool, serviceLen uint16) (__getAttributeSingleResponse GetAttributeSingleResponse, err error) {
	m.CipServiceContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("GetAttributeSingleResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for GetAttributeSingleResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("GetAttributeSingleResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for GetAttributeSingleResponse")
	}

	return m, nil
}

func (m *_GetAttributeSingleResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_GetAttributeSingleResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("GetAttributeSingleResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for GetAttributeSingleResponse")
		}

		if popErr := writeBuffer.PopContext("GetAttributeSingleResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for GetAttributeSingleResponse")
		}
		return nil
	}
	return m.CipServiceContract.(*_CipService).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_GetAttributeSingleResponse) IsGetAttributeSingleResponse() {}

func (m *_GetAttributeSingleResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_GetAttributeSingleResponse) deepCopy() *_GetAttributeSingleResponse {
	if m == nil {
		return nil
	}
	_GetAttributeSingleResponseCopy := &_GetAttributeSingleResponse{
		m.CipServiceContract.(*_CipService).deepCopy(),
	}
	_GetAttributeSingleResponseCopy.CipServiceContract.(*_CipService)._SubType = m
	return _GetAttributeSingleResponseCopy
}

func (m *_GetAttributeSingleResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
