/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyDataRinging is the corresponding interface of TelephonyDataRinging
type TelephonyDataRinging interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TelephonyData
	// GetNumber returns Number (property field)
	GetNumber() string
	// IsTelephonyDataRinging is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTelephonyDataRinging()
	// CreateBuilder creates a TelephonyDataRingingBuilder
	CreateTelephonyDataRingingBuilder() TelephonyDataRingingBuilder
}

// _TelephonyDataRinging is the data-structure of this message
type _TelephonyDataRinging struct {
	TelephonyDataContract
	Number string
	// Reserved Fields
	reservedField0 *byte
}

var _ TelephonyDataRinging = (*_TelephonyDataRinging)(nil)
var _ TelephonyDataRequirements = (*_TelephonyDataRinging)(nil)

// NewTelephonyDataRinging factory function for _TelephonyDataRinging
func NewTelephonyDataRinging(commandTypeContainer TelephonyCommandTypeContainer, argument byte, number string) *_TelephonyDataRinging {
	_result := &_TelephonyDataRinging{
		TelephonyDataContract: NewTelephonyData(commandTypeContainer, argument),
		Number:                number,
	}
	_result.TelephonyDataContract.(*_TelephonyData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TelephonyDataRingingBuilder is a builder for TelephonyDataRinging
type TelephonyDataRingingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(number string) TelephonyDataRingingBuilder
	// WithNumber adds Number (property field)
	WithNumber(string) TelephonyDataRingingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TelephonyDataBuilder
	// Build builds the TelephonyDataRinging or returns an error if something is wrong
	Build() (TelephonyDataRinging, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TelephonyDataRinging
}

// NewTelephonyDataRingingBuilder() creates a TelephonyDataRingingBuilder
func NewTelephonyDataRingingBuilder() TelephonyDataRingingBuilder {
	return &_TelephonyDataRingingBuilder{_TelephonyDataRinging: new(_TelephonyDataRinging)}
}

type _TelephonyDataRingingBuilder struct {
	*_TelephonyDataRinging

	parentBuilder *_TelephonyDataBuilder

	err *utils.MultiError
}

var _ (TelephonyDataRingingBuilder) = (*_TelephonyDataRingingBuilder)(nil)

func (b *_TelephonyDataRingingBuilder) setParent(contract TelephonyDataContract) {
	b.TelephonyDataContract = contract
	contract.(*_TelephonyData)._SubType = b._TelephonyDataRinging
}

func (b *_TelephonyDataRingingBuilder) WithMandatoryFields(number string) TelephonyDataRingingBuilder {
	return b.WithNumber(number)
}

func (b *_TelephonyDataRingingBuilder) WithNumber(number string) TelephonyDataRingingBuilder {
	b.Number = number
	return b
}

func (b *_TelephonyDataRingingBuilder) Build() (TelephonyDataRinging, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._TelephonyDataRinging.deepCopy(), nil
}

func (b *_TelephonyDataRingingBuilder) MustBuild() TelephonyDataRinging {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TelephonyDataRingingBuilder) Done() TelephonyDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTelephonyDataBuilder().(*_TelephonyDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TelephonyDataRingingBuilder) buildForTelephonyData() (TelephonyData, error) {
	return b.Build()
}

func (b *_TelephonyDataRingingBuilder) DeepCopy() any {
	_copy := b.CreateTelephonyDataRingingBuilder().(*_TelephonyDataRingingBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateTelephonyDataRingingBuilder creates a TelephonyDataRingingBuilder
func (b *_TelephonyDataRinging) CreateTelephonyDataRingingBuilder() TelephonyDataRingingBuilder {
	if b == nil {
		return NewTelephonyDataRingingBuilder()
	}
	return &_TelephonyDataRingingBuilder{_TelephonyDataRinging: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TelephonyDataRinging) GetParent() TelephonyDataContract {
	return m.TelephonyDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TelephonyDataRinging) GetNumber() string {
	return m.Number
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTelephonyDataRinging(structType any) TelephonyDataRinging {
	if casted, ok := structType.(TelephonyDataRinging); ok {
		return casted
	}
	if casted, ok := structType.(*TelephonyDataRinging); ok {
		return *casted
	}
	return nil
}

func (m *_TelephonyDataRinging) GetTypeName() string {
	return "TelephonyDataRinging"
}

func (m *_TelephonyDataRinging) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TelephonyDataContract.(*_TelephonyData).getLengthInBits(ctx))

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (number)
	lengthInBits += uint16(int32((int32(m.GetCommandTypeContainer().NumBytes()) - int32(int32(2)))) * int32(int32(8)))

	return lengthInBits
}

func (m *_TelephonyDataRinging) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TelephonyDataRinging) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TelephonyData, commandTypeContainer TelephonyCommandTypeContainer) (__telephonyDataRinging TelephonyDataRinging, err error) {
	m.TelephonyDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TelephonyDataRinging"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TelephonyDataRinging")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadByte(readBuffer, 8), byte(0x01))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	number, err := ReadSimpleField(ctx, "number", ReadString(readBuffer, uint32(int32((int32(commandTypeContainer.NumBytes())-int32(int32(2))))*int32(int32(8)))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'number' field"))
	}
	m.Number = number

	if closeErr := readBuffer.CloseContext("TelephonyDataRinging"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TelephonyDataRinging")
	}

	return m, nil
}

func (m *_TelephonyDataRinging) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TelephonyDataRinging) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TelephonyDataRinging"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TelephonyDataRinging")
		}

		if err := WriteReservedField[byte](ctx, "reserved", byte(0x01), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[string](ctx, "number", m.GetNumber(), WriteString(writeBuffer, int32(int32((int32(m.GetCommandTypeContainer().NumBytes())-int32(int32(2))))*int32(int32(8))))); err != nil {
			return errors.Wrap(err, "Error serializing 'number' field")
		}

		if popErr := writeBuffer.PopContext("TelephonyDataRinging"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TelephonyDataRinging")
		}
		return nil
	}
	return m.TelephonyDataContract.(*_TelephonyData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TelephonyDataRinging) IsTelephonyDataRinging() {}

func (m *_TelephonyDataRinging) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TelephonyDataRinging) deepCopy() *_TelephonyDataRinging {
	if m == nil {
		return nil
	}
	_TelephonyDataRingingCopy := &_TelephonyDataRinging{
		m.TelephonyDataContract.(*_TelephonyData).deepCopy(),
		m.Number,
		m.reservedField0,
	}
	_TelephonyDataRingingCopy.TelephonyDataContract.(*_TelephonyData)._SubType = m
	return _TelephonyDataRingingCopy
}

func (m *_TelephonyDataRinging) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
