/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataTamperOn is the corresponding interface of SecurityDataTamperOn
type SecurityDataTamperOn interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataTamperOn is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataTamperOn()
	// CreateBuilder creates a SecurityDataTamperOnBuilder
	CreateSecurityDataTamperOnBuilder() SecurityDataTamperOnBuilder
}

// _SecurityDataTamperOn is the data-structure of this message
type _SecurityDataTamperOn struct {
	SecurityDataContract
}

var _ SecurityDataTamperOn = (*_SecurityDataTamperOn)(nil)
var _ SecurityDataRequirements = (*_SecurityDataTamperOn)(nil)

// NewSecurityDataTamperOn factory function for _SecurityDataTamperOn
func NewSecurityDataTamperOn(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataTamperOn {
	_result := &_SecurityDataTamperOn{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataTamperOnBuilder is a builder for SecurityDataTamperOn
type SecurityDataTamperOnBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataTamperOnBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataTamperOn or returns an error if something is wrong
	Build() (SecurityDataTamperOn, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataTamperOn
}

// NewSecurityDataTamperOnBuilder() creates a SecurityDataTamperOnBuilder
func NewSecurityDataTamperOnBuilder() SecurityDataTamperOnBuilder {
	return &_SecurityDataTamperOnBuilder{_SecurityDataTamperOn: new(_SecurityDataTamperOn)}
}

type _SecurityDataTamperOnBuilder struct {
	*_SecurityDataTamperOn

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataTamperOnBuilder) = (*_SecurityDataTamperOnBuilder)(nil)

func (b *_SecurityDataTamperOnBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataTamperOn
}

func (b *_SecurityDataTamperOnBuilder) WithMandatoryFields() SecurityDataTamperOnBuilder {
	return b
}

func (b *_SecurityDataTamperOnBuilder) Build() (SecurityDataTamperOn, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataTamperOn.deepCopy(), nil
}

func (b *_SecurityDataTamperOnBuilder) MustBuild() SecurityDataTamperOn {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataTamperOnBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataTamperOnBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataTamperOnBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataTamperOnBuilder().(*_SecurityDataTamperOnBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataTamperOnBuilder creates a SecurityDataTamperOnBuilder
func (b *_SecurityDataTamperOn) CreateSecurityDataTamperOnBuilder() SecurityDataTamperOnBuilder {
	if b == nil {
		return NewSecurityDataTamperOnBuilder()
	}
	return &_SecurityDataTamperOnBuilder{_SecurityDataTamperOn: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataTamperOn) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataTamperOn(structType any) SecurityDataTamperOn {
	if casted, ok := structType.(SecurityDataTamperOn); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataTamperOn); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataTamperOn) GetTypeName() string {
	return "SecurityDataTamperOn"
}

func (m *_SecurityDataTamperOn) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataTamperOn) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataTamperOn) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataTamperOn SecurityDataTamperOn, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataTamperOn"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataTamperOn")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataTamperOn"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataTamperOn")
	}

	return m, nil
}

func (m *_SecurityDataTamperOn) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataTamperOn) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataTamperOn"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataTamperOn")
		}

		if popErr := writeBuffer.PopContext("SecurityDataTamperOn"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataTamperOn")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataTamperOn) IsSecurityDataTamperOn() {}

func (m *_SecurityDataTamperOn) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataTamperOn) deepCopy() *_SecurityDataTamperOn {
	if m == nil {
		return nil
	}
	_SecurityDataTamperOnCopy := &_SecurityDataTamperOn{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataTamperOnCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataTamperOnCopy
}

func (m *_SecurityDataTamperOn) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
