/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataLowBatteryCorrected is the corresponding interface of SecurityDataLowBatteryCorrected
type SecurityDataLowBatteryCorrected interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataLowBatteryCorrected is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataLowBatteryCorrected()
	// CreateBuilder creates a SecurityDataLowBatteryCorrectedBuilder
	CreateSecurityDataLowBatteryCorrectedBuilder() SecurityDataLowBatteryCorrectedBuilder
}

// _SecurityDataLowBatteryCorrected is the data-structure of this message
type _SecurityDataLowBatteryCorrected struct {
	SecurityDataContract
}

var _ SecurityDataLowBatteryCorrected = (*_SecurityDataLowBatteryCorrected)(nil)
var _ SecurityDataRequirements = (*_SecurityDataLowBatteryCorrected)(nil)

// NewSecurityDataLowBatteryCorrected factory function for _SecurityDataLowBatteryCorrected
func NewSecurityDataLowBatteryCorrected(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataLowBatteryCorrected {
	_result := &_SecurityDataLowBatteryCorrected{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataLowBatteryCorrectedBuilder is a builder for SecurityDataLowBatteryCorrected
type SecurityDataLowBatteryCorrectedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataLowBatteryCorrectedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataLowBatteryCorrected or returns an error if something is wrong
	Build() (SecurityDataLowBatteryCorrected, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataLowBatteryCorrected
}

// NewSecurityDataLowBatteryCorrectedBuilder() creates a SecurityDataLowBatteryCorrectedBuilder
func NewSecurityDataLowBatteryCorrectedBuilder() SecurityDataLowBatteryCorrectedBuilder {
	return &_SecurityDataLowBatteryCorrectedBuilder{_SecurityDataLowBatteryCorrected: new(_SecurityDataLowBatteryCorrected)}
}

type _SecurityDataLowBatteryCorrectedBuilder struct {
	*_SecurityDataLowBatteryCorrected

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataLowBatteryCorrectedBuilder) = (*_SecurityDataLowBatteryCorrectedBuilder)(nil)

func (b *_SecurityDataLowBatteryCorrectedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataLowBatteryCorrected
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) WithMandatoryFields() SecurityDataLowBatteryCorrectedBuilder {
	return b
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) Build() (SecurityDataLowBatteryCorrected, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataLowBatteryCorrected.deepCopy(), nil
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) MustBuild() SecurityDataLowBatteryCorrected {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataLowBatteryCorrectedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataLowBatteryCorrectedBuilder().(*_SecurityDataLowBatteryCorrectedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataLowBatteryCorrectedBuilder creates a SecurityDataLowBatteryCorrectedBuilder
func (b *_SecurityDataLowBatteryCorrected) CreateSecurityDataLowBatteryCorrectedBuilder() SecurityDataLowBatteryCorrectedBuilder {
	if b == nil {
		return NewSecurityDataLowBatteryCorrectedBuilder()
	}
	return &_SecurityDataLowBatteryCorrectedBuilder{_SecurityDataLowBatteryCorrected: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataLowBatteryCorrected) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataLowBatteryCorrected(structType any) SecurityDataLowBatteryCorrected {
	if casted, ok := structType.(SecurityDataLowBatteryCorrected); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataLowBatteryCorrected); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataLowBatteryCorrected) GetTypeName() string {
	return "SecurityDataLowBatteryCorrected"
}

func (m *_SecurityDataLowBatteryCorrected) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataLowBatteryCorrected) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataLowBatteryCorrected) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataLowBatteryCorrected SecurityDataLowBatteryCorrected, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataLowBatteryCorrected"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataLowBatteryCorrected")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataLowBatteryCorrected"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataLowBatteryCorrected")
	}

	return m, nil
}

func (m *_SecurityDataLowBatteryCorrected) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataLowBatteryCorrected) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataLowBatteryCorrected"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataLowBatteryCorrected")
		}

		if popErr := writeBuffer.PopContext("SecurityDataLowBatteryCorrected"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataLowBatteryCorrected")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataLowBatteryCorrected) IsSecurityDataLowBatteryCorrected() {}

func (m *_SecurityDataLowBatteryCorrected) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataLowBatteryCorrected) deepCopy() *_SecurityDataLowBatteryCorrected {
	if m == nil {
		return nil
	}
	_SecurityDataLowBatteryCorrectedCopy := &_SecurityDataLowBatteryCorrected{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataLowBatteryCorrectedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataLowBatteryCorrectedCopy
}

func (m *_SecurityDataLowBatteryCorrected) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
