/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataFireAlarmCleared is the corresponding interface of SecurityDataFireAlarmCleared
type SecurityDataFireAlarmCleared interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataFireAlarmCleared is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataFireAlarmCleared()
	// CreateBuilder creates a SecurityDataFireAlarmClearedBuilder
	CreateSecurityDataFireAlarmClearedBuilder() SecurityDataFireAlarmClearedBuilder
}

// _SecurityDataFireAlarmCleared is the data-structure of this message
type _SecurityDataFireAlarmCleared struct {
	SecurityDataContract
}

var _ SecurityDataFireAlarmCleared = (*_SecurityDataFireAlarmCleared)(nil)
var _ SecurityDataRequirements = (*_SecurityDataFireAlarmCleared)(nil)

// NewSecurityDataFireAlarmCleared factory function for _SecurityDataFireAlarmCleared
func NewSecurityDataFireAlarmCleared(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataFireAlarmCleared {
	_result := &_SecurityDataFireAlarmCleared{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataFireAlarmClearedBuilder is a builder for SecurityDataFireAlarmCleared
type SecurityDataFireAlarmClearedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataFireAlarmClearedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataFireAlarmCleared or returns an error if something is wrong
	Build() (SecurityDataFireAlarmCleared, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataFireAlarmCleared
}

// NewSecurityDataFireAlarmClearedBuilder() creates a SecurityDataFireAlarmClearedBuilder
func NewSecurityDataFireAlarmClearedBuilder() SecurityDataFireAlarmClearedBuilder {
	return &_SecurityDataFireAlarmClearedBuilder{_SecurityDataFireAlarmCleared: new(_SecurityDataFireAlarmCleared)}
}

type _SecurityDataFireAlarmClearedBuilder struct {
	*_SecurityDataFireAlarmCleared

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataFireAlarmClearedBuilder) = (*_SecurityDataFireAlarmClearedBuilder)(nil)

func (b *_SecurityDataFireAlarmClearedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataFireAlarmCleared
}

func (b *_SecurityDataFireAlarmClearedBuilder) WithMandatoryFields() SecurityDataFireAlarmClearedBuilder {
	return b
}

func (b *_SecurityDataFireAlarmClearedBuilder) Build() (SecurityDataFireAlarmCleared, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataFireAlarmCleared.deepCopy(), nil
}

func (b *_SecurityDataFireAlarmClearedBuilder) MustBuild() SecurityDataFireAlarmCleared {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataFireAlarmClearedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataFireAlarmClearedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataFireAlarmClearedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataFireAlarmClearedBuilder().(*_SecurityDataFireAlarmClearedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataFireAlarmClearedBuilder creates a SecurityDataFireAlarmClearedBuilder
func (b *_SecurityDataFireAlarmCleared) CreateSecurityDataFireAlarmClearedBuilder() SecurityDataFireAlarmClearedBuilder {
	if b == nil {
		return NewSecurityDataFireAlarmClearedBuilder()
	}
	return &_SecurityDataFireAlarmClearedBuilder{_SecurityDataFireAlarmCleared: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataFireAlarmCleared) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataFireAlarmCleared(structType any) SecurityDataFireAlarmCleared {
	if casted, ok := structType.(SecurityDataFireAlarmCleared); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataFireAlarmCleared); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataFireAlarmCleared) GetTypeName() string {
	return "SecurityDataFireAlarmCleared"
}

func (m *_SecurityDataFireAlarmCleared) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataFireAlarmCleared) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataFireAlarmCleared) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataFireAlarmCleared SecurityDataFireAlarmCleared, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataFireAlarmCleared"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataFireAlarmCleared")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataFireAlarmCleared"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataFireAlarmCleared")
	}

	return m, nil
}

func (m *_SecurityDataFireAlarmCleared) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataFireAlarmCleared) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataFireAlarmCleared"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataFireAlarmCleared")
		}

		if popErr := writeBuffer.PopContext("SecurityDataFireAlarmCleared"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataFireAlarmCleared")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataFireAlarmCleared) IsSecurityDataFireAlarmCleared() {}

func (m *_SecurityDataFireAlarmCleared) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataFireAlarmCleared) deepCopy() *_SecurityDataFireAlarmCleared {
	if m == nil {
		return nil
	}
	_SecurityDataFireAlarmClearedCopy := &_SecurityDataFireAlarmCleared{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataFireAlarmClearedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataFireAlarmClearedCopy
}

func (m *_SecurityDataFireAlarmCleared) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
