/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataAlarmOn is the corresponding interface of SecurityDataAlarmOn
type SecurityDataAlarmOn interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataAlarmOn is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataAlarmOn()
	// CreateBuilder creates a SecurityDataAlarmOnBuilder
	CreateSecurityDataAlarmOnBuilder() SecurityDataAlarmOnBuilder
}

// _SecurityDataAlarmOn is the data-structure of this message
type _SecurityDataAlarmOn struct {
	SecurityDataContract
}

var _ SecurityDataAlarmOn = (*_SecurityDataAlarmOn)(nil)
var _ SecurityDataRequirements = (*_SecurityDataAlarmOn)(nil)

// NewSecurityDataAlarmOn factory function for _SecurityDataAlarmOn
func NewSecurityDataAlarmOn(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataAlarmOn {
	_result := &_SecurityDataAlarmOn{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataAlarmOnBuilder is a builder for SecurityDataAlarmOn
type SecurityDataAlarmOnBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataAlarmOnBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataAlarmOn or returns an error if something is wrong
	Build() (SecurityDataAlarmOn, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataAlarmOn
}

// NewSecurityDataAlarmOnBuilder() creates a SecurityDataAlarmOnBuilder
func NewSecurityDataAlarmOnBuilder() SecurityDataAlarmOnBuilder {
	return &_SecurityDataAlarmOnBuilder{_SecurityDataAlarmOn: new(_SecurityDataAlarmOn)}
}

type _SecurityDataAlarmOnBuilder struct {
	*_SecurityDataAlarmOn

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataAlarmOnBuilder) = (*_SecurityDataAlarmOnBuilder)(nil)

func (b *_SecurityDataAlarmOnBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataAlarmOn
}

func (b *_SecurityDataAlarmOnBuilder) WithMandatoryFields() SecurityDataAlarmOnBuilder {
	return b
}

func (b *_SecurityDataAlarmOnBuilder) Build() (SecurityDataAlarmOn, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataAlarmOn.deepCopy(), nil
}

func (b *_SecurityDataAlarmOnBuilder) MustBuild() SecurityDataAlarmOn {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataAlarmOnBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataAlarmOnBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataAlarmOnBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataAlarmOnBuilder().(*_SecurityDataAlarmOnBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataAlarmOnBuilder creates a SecurityDataAlarmOnBuilder
func (b *_SecurityDataAlarmOn) CreateSecurityDataAlarmOnBuilder() SecurityDataAlarmOnBuilder {
	if b == nil {
		return NewSecurityDataAlarmOnBuilder()
	}
	return &_SecurityDataAlarmOnBuilder{_SecurityDataAlarmOn: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataAlarmOn) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataAlarmOn(structType any) SecurityDataAlarmOn {
	if casted, ok := structType.(SecurityDataAlarmOn); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataAlarmOn); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataAlarmOn) GetTypeName() string {
	return "SecurityDataAlarmOn"
}

func (m *_SecurityDataAlarmOn) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataAlarmOn) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataAlarmOn) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataAlarmOn SecurityDataAlarmOn, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataAlarmOn"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataAlarmOn")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataAlarmOn"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataAlarmOn")
	}

	return m, nil
}

func (m *_SecurityDataAlarmOn) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataAlarmOn) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataAlarmOn"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataAlarmOn")
		}

		if popErr := writeBuffer.PopContext("SecurityDataAlarmOn"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataAlarmOn")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataAlarmOn) IsSecurityDataAlarmOn() {}

func (m *_SecurityDataAlarmOn) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataAlarmOn) deepCopy() *_SecurityDataAlarmOn {
	if m == nil {
		return nil
	}
	_SecurityDataAlarmOnCopy := &_SecurityDataAlarmOn{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataAlarmOnCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataAlarmOnCopy
}

func (m *_SecurityDataAlarmOn) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
