/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataAudioAndVideo is the corresponding interface of SALDataAudioAndVideo
type SALDataAudioAndVideo interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetAudioVideoData returns AudioVideoData (property field)
	GetAudioVideoData() LightingData
	// IsSALDataAudioAndVideo is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataAudioAndVideo()
	// CreateBuilder creates a SALDataAudioAndVideoBuilder
	CreateSALDataAudioAndVideoBuilder() SALDataAudioAndVideoBuilder
}

// _SALDataAudioAndVideo is the data-structure of this message
type _SALDataAudioAndVideo struct {
	SALDataContract
	AudioVideoData LightingData
}

var _ SALDataAudioAndVideo = (*_SALDataAudioAndVideo)(nil)
var _ SALDataRequirements = (*_SALDataAudioAndVideo)(nil)

// NewSALDataAudioAndVideo factory function for _SALDataAudioAndVideo
func NewSALDataAudioAndVideo(salData SALData, audioVideoData LightingData) *_SALDataAudioAndVideo {
	if audioVideoData == nil {
		panic("audioVideoData of type LightingData for SALDataAudioAndVideo must not be nil")
	}
	_result := &_SALDataAudioAndVideo{
		SALDataContract: NewSALData(salData),
		AudioVideoData:  audioVideoData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataAudioAndVideoBuilder is a builder for SALDataAudioAndVideo
type SALDataAudioAndVideoBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(audioVideoData LightingData) SALDataAudioAndVideoBuilder
	// WithAudioVideoData adds AudioVideoData (property field)
	WithAudioVideoData(LightingData) SALDataAudioAndVideoBuilder
	// WithAudioVideoDataBuilder adds AudioVideoData (property field) which is build by the builder
	WithAudioVideoDataBuilder(func(LightingDataBuilder) LightingDataBuilder) SALDataAudioAndVideoBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataAudioAndVideo or returns an error if something is wrong
	Build() (SALDataAudioAndVideo, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataAudioAndVideo
}

// NewSALDataAudioAndVideoBuilder() creates a SALDataAudioAndVideoBuilder
func NewSALDataAudioAndVideoBuilder() SALDataAudioAndVideoBuilder {
	return &_SALDataAudioAndVideoBuilder{_SALDataAudioAndVideo: new(_SALDataAudioAndVideo)}
}

type _SALDataAudioAndVideoBuilder struct {
	*_SALDataAudioAndVideo

	parentBuilder *_SALDataBuilder

	err *utils.MultiError
}

var _ (SALDataAudioAndVideoBuilder) = (*_SALDataAudioAndVideoBuilder)(nil)

func (b *_SALDataAudioAndVideoBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataAudioAndVideo
}

func (b *_SALDataAudioAndVideoBuilder) WithMandatoryFields(audioVideoData LightingData) SALDataAudioAndVideoBuilder {
	return b.WithAudioVideoData(audioVideoData)
}

func (b *_SALDataAudioAndVideoBuilder) WithAudioVideoData(audioVideoData LightingData) SALDataAudioAndVideoBuilder {
	b.AudioVideoData = audioVideoData
	return b
}

func (b *_SALDataAudioAndVideoBuilder) WithAudioVideoDataBuilder(builderSupplier func(LightingDataBuilder) LightingDataBuilder) SALDataAudioAndVideoBuilder {
	builder := builderSupplier(b.AudioVideoData.CreateLightingDataBuilder())
	var err error
	b.AudioVideoData, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "LightingDataBuilder failed"))
	}
	return b
}

func (b *_SALDataAudioAndVideoBuilder) Build() (SALDataAudioAndVideo, error) {
	if b.AudioVideoData == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'audioVideoData' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SALDataAudioAndVideo.deepCopy(), nil
}

func (b *_SALDataAudioAndVideoBuilder) MustBuild() SALDataAudioAndVideo {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataAudioAndVideoBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataAudioAndVideoBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataAudioAndVideoBuilder) DeepCopy() any {
	_copy := b.CreateSALDataAudioAndVideoBuilder().(*_SALDataAudioAndVideoBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSALDataAudioAndVideoBuilder creates a SALDataAudioAndVideoBuilder
func (b *_SALDataAudioAndVideo) CreateSALDataAudioAndVideoBuilder() SALDataAudioAndVideoBuilder {
	if b == nil {
		return NewSALDataAudioAndVideoBuilder()
	}
	return &_SALDataAudioAndVideoBuilder{_SALDataAudioAndVideo: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataAudioAndVideo) GetApplicationId() ApplicationId {
	return ApplicationId_AUDIO_AND_VIDEO
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataAudioAndVideo) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataAudioAndVideo) GetAudioVideoData() LightingData {
	return m.AudioVideoData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataAudioAndVideo(structType any) SALDataAudioAndVideo {
	if casted, ok := structType.(SALDataAudioAndVideo); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataAudioAndVideo); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataAudioAndVideo) GetTypeName() string {
	return "SALDataAudioAndVideo"
}

func (m *_SALDataAudioAndVideo) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (audioVideoData)
	lengthInBits += m.AudioVideoData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataAudioAndVideo) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataAudioAndVideo) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataAudioAndVideo SALDataAudioAndVideo, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataAudioAndVideo"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataAudioAndVideo")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	audioVideoData, err := ReadSimpleField[LightingData](ctx, "audioVideoData", ReadComplex[LightingData](LightingDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'audioVideoData' field"))
	}
	m.AudioVideoData = audioVideoData

	if closeErr := readBuffer.CloseContext("SALDataAudioAndVideo"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataAudioAndVideo")
	}

	return m, nil
}

func (m *_SALDataAudioAndVideo) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataAudioAndVideo) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataAudioAndVideo"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataAudioAndVideo")
		}

		if err := WriteSimpleField[LightingData](ctx, "audioVideoData", m.GetAudioVideoData(), WriteComplex[LightingData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'audioVideoData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataAudioAndVideo"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataAudioAndVideo")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataAudioAndVideo) IsSALDataAudioAndVideo() {}

func (m *_SALDataAudioAndVideo) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataAudioAndVideo) deepCopy() *_SALDataAudioAndVideo {
	if m == nil {
		return nil
	}
	_SALDataAudioAndVideoCopy := &_SALDataAudioAndVideo{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[LightingData](m.AudioVideoData),
	}
	_SALDataAudioAndVideoCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataAudioAndVideoCopy
}

func (m *_SALDataAudioAndVideo) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
