/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReplyOrConfirmationConfirmation is the corresponding interface of ReplyOrConfirmationConfirmation
type ReplyOrConfirmationConfirmation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ReplyOrConfirmation
	// GetConfirmation returns Confirmation (property field)
	GetConfirmation() Confirmation
	// GetEmbeddedReply returns EmbeddedReply (property field)
	GetEmbeddedReply() ReplyOrConfirmation
	// IsReplyOrConfirmationConfirmation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReplyOrConfirmationConfirmation()
	// CreateBuilder creates a ReplyOrConfirmationConfirmationBuilder
	CreateReplyOrConfirmationConfirmationBuilder() ReplyOrConfirmationConfirmationBuilder
}

// _ReplyOrConfirmationConfirmation is the data-structure of this message
type _ReplyOrConfirmationConfirmation struct {
	ReplyOrConfirmationContract
	Confirmation  Confirmation
	EmbeddedReply ReplyOrConfirmation
}

var _ ReplyOrConfirmationConfirmation = (*_ReplyOrConfirmationConfirmation)(nil)
var _ ReplyOrConfirmationRequirements = (*_ReplyOrConfirmationConfirmation)(nil)

// NewReplyOrConfirmationConfirmation factory function for _ReplyOrConfirmationConfirmation
func NewReplyOrConfirmationConfirmation(peekedByte byte, confirmation Confirmation, embeddedReply ReplyOrConfirmation, cBusOptions CBusOptions, requestContext RequestContext) *_ReplyOrConfirmationConfirmation {
	if confirmation == nil {
		panic("confirmation of type Confirmation for ReplyOrConfirmationConfirmation must not be nil")
	}
	_result := &_ReplyOrConfirmationConfirmation{
		ReplyOrConfirmationContract: NewReplyOrConfirmation(peekedByte, cBusOptions, requestContext),
		Confirmation:                confirmation,
		EmbeddedReply:               embeddedReply,
	}
	_result.ReplyOrConfirmationContract.(*_ReplyOrConfirmation)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReplyOrConfirmationConfirmationBuilder is a builder for ReplyOrConfirmationConfirmation
type ReplyOrConfirmationConfirmationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(confirmation Confirmation) ReplyOrConfirmationConfirmationBuilder
	// WithConfirmation adds Confirmation (property field)
	WithConfirmation(Confirmation) ReplyOrConfirmationConfirmationBuilder
	// WithConfirmationBuilder adds Confirmation (property field) which is build by the builder
	WithConfirmationBuilder(func(ConfirmationBuilder) ConfirmationBuilder) ReplyOrConfirmationConfirmationBuilder
	// WithEmbeddedReply adds EmbeddedReply (property field)
	WithOptionalEmbeddedReply(ReplyOrConfirmation) ReplyOrConfirmationConfirmationBuilder
	// WithOptionalEmbeddedReplyBuilder adds EmbeddedReply (property field) which is build by the builder
	WithOptionalEmbeddedReplyBuilder(func(ReplyOrConfirmationBuilder) ReplyOrConfirmationBuilder) ReplyOrConfirmationConfirmationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ReplyOrConfirmationBuilder
	// Build builds the ReplyOrConfirmationConfirmation or returns an error if something is wrong
	Build() (ReplyOrConfirmationConfirmation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReplyOrConfirmationConfirmation
}

// NewReplyOrConfirmationConfirmationBuilder() creates a ReplyOrConfirmationConfirmationBuilder
func NewReplyOrConfirmationConfirmationBuilder() ReplyOrConfirmationConfirmationBuilder {
	return &_ReplyOrConfirmationConfirmationBuilder{_ReplyOrConfirmationConfirmation: new(_ReplyOrConfirmationConfirmation)}
}

type _ReplyOrConfirmationConfirmationBuilder struct {
	*_ReplyOrConfirmationConfirmation

	parentBuilder *_ReplyOrConfirmationBuilder

	err *utils.MultiError
}

var _ (ReplyOrConfirmationConfirmationBuilder) = (*_ReplyOrConfirmationConfirmationBuilder)(nil)

func (b *_ReplyOrConfirmationConfirmationBuilder) setParent(contract ReplyOrConfirmationContract) {
	b.ReplyOrConfirmationContract = contract
	contract.(*_ReplyOrConfirmation)._SubType = b._ReplyOrConfirmationConfirmation
}

func (b *_ReplyOrConfirmationConfirmationBuilder) WithMandatoryFields(confirmation Confirmation) ReplyOrConfirmationConfirmationBuilder {
	return b.WithConfirmation(confirmation)
}

func (b *_ReplyOrConfirmationConfirmationBuilder) WithConfirmation(confirmation Confirmation) ReplyOrConfirmationConfirmationBuilder {
	b.Confirmation = confirmation
	return b
}

func (b *_ReplyOrConfirmationConfirmationBuilder) WithConfirmationBuilder(builderSupplier func(ConfirmationBuilder) ConfirmationBuilder) ReplyOrConfirmationConfirmationBuilder {
	builder := builderSupplier(b.Confirmation.CreateConfirmationBuilder())
	var err error
	b.Confirmation, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ConfirmationBuilder failed"))
	}
	return b
}

func (b *_ReplyOrConfirmationConfirmationBuilder) WithOptionalEmbeddedReply(embeddedReply ReplyOrConfirmation) ReplyOrConfirmationConfirmationBuilder {
	b.EmbeddedReply = embeddedReply
	return b
}

func (b *_ReplyOrConfirmationConfirmationBuilder) WithOptionalEmbeddedReplyBuilder(builderSupplier func(ReplyOrConfirmationBuilder) ReplyOrConfirmationBuilder) ReplyOrConfirmationConfirmationBuilder {
	builder := builderSupplier(b.EmbeddedReply.CreateReplyOrConfirmationBuilder())
	var err error
	b.EmbeddedReply, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ReplyOrConfirmationBuilder failed"))
	}
	return b
}

func (b *_ReplyOrConfirmationConfirmationBuilder) Build() (ReplyOrConfirmationConfirmation, error) {
	if b.Confirmation == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'confirmation' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReplyOrConfirmationConfirmation.deepCopy(), nil
}

func (b *_ReplyOrConfirmationConfirmationBuilder) MustBuild() ReplyOrConfirmationConfirmation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReplyOrConfirmationConfirmationBuilder) Done() ReplyOrConfirmationBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewReplyOrConfirmationBuilder().(*_ReplyOrConfirmationBuilder)
	}
	return b.parentBuilder
}

func (b *_ReplyOrConfirmationConfirmationBuilder) buildForReplyOrConfirmation() (ReplyOrConfirmation, error) {
	return b.Build()
}

func (b *_ReplyOrConfirmationConfirmationBuilder) DeepCopy() any {
	_copy := b.CreateReplyOrConfirmationConfirmationBuilder().(*_ReplyOrConfirmationConfirmationBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReplyOrConfirmationConfirmationBuilder creates a ReplyOrConfirmationConfirmationBuilder
func (b *_ReplyOrConfirmationConfirmation) CreateReplyOrConfirmationConfirmationBuilder() ReplyOrConfirmationConfirmationBuilder {
	if b == nil {
		return NewReplyOrConfirmationConfirmationBuilder()
	}
	return &_ReplyOrConfirmationConfirmationBuilder{_ReplyOrConfirmationConfirmation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReplyOrConfirmationConfirmation) GetParent() ReplyOrConfirmationContract {
	return m.ReplyOrConfirmationContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReplyOrConfirmationConfirmation) GetConfirmation() Confirmation {
	return m.Confirmation
}

func (m *_ReplyOrConfirmationConfirmation) GetEmbeddedReply() ReplyOrConfirmation {
	return m.EmbeddedReply
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReplyOrConfirmationConfirmation(structType any) ReplyOrConfirmationConfirmation {
	if casted, ok := structType.(ReplyOrConfirmationConfirmation); ok {
		return casted
	}
	if casted, ok := structType.(*ReplyOrConfirmationConfirmation); ok {
		return *casted
	}
	return nil
}

func (m *_ReplyOrConfirmationConfirmation) GetTypeName() string {
	return "ReplyOrConfirmationConfirmation"
}

func (m *_ReplyOrConfirmationConfirmation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ReplyOrConfirmationContract.(*_ReplyOrConfirmation).getLengthInBits(ctx))

	// Simple field (confirmation)
	lengthInBits += m.Confirmation.GetLengthInBits(ctx)

	// Optional Field (embeddedReply)
	if m.EmbeddedReply != nil {
		lengthInBits += m.EmbeddedReply.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_ReplyOrConfirmationConfirmation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReplyOrConfirmationConfirmation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ReplyOrConfirmation, cBusOptions CBusOptions, requestContext RequestContext) (__replyOrConfirmationConfirmation ReplyOrConfirmationConfirmation, err error) {
	m.ReplyOrConfirmationContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReplyOrConfirmationConfirmation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReplyOrConfirmationConfirmation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	confirmation, err := ReadSimpleField[Confirmation](ctx, "confirmation", ReadComplex[Confirmation](ConfirmationParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'confirmation' field"))
	}
	m.Confirmation = confirmation

	var embeddedReply ReplyOrConfirmation
	_embeddedReply, err := ReadOptionalField[ReplyOrConfirmation](ctx, "embeddedReply", ReadComplex[ReplyOrConfirmation](ReplyOrConfirmationParseWithBufferProducer[ReplyOrConfirmation]((CBusOptions)(cBusOptions), (RequestContext)(requestContext)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'embeddedReply' field"))
	}
	if _embeddedReply != nil {
		embeddedReply = *_embeddedReply
		m.EmbeddedReply = embeddedReply
	}

	if closeErr := readBuffer.CloseContext("ReplyOrConfirmationConfirmation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReplyOrConfirmationConfirmation")
	}

	return m, nil
}

func (m *_ReplyOrConfirmationConfirmation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReplyOrConfirmationConfirmation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReplyOrConfirmationConfirmation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReplyOrConfirmationConfirmation")
		}

		if err := WriteSimpleField[Confirmation](ctx, "confirmation", m.GetConfirmation(), WriteComplex[Confirmation](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'confirmation' field")
		}

		if err := WriteOptionalField[ReplyOrConfirmation](ctx, "embeddedReply", GetRef(m.GetEmbeddedReply()), WriteComplex[ReplyOrConfirmation](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'embeddedReply' field")
		}

		if popErr := writeBuffer.PopContext("ReplyOrConfirmationConfirmation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReplyOrConfirmationConfirmation")
		}
		return nil
	}
	return m.ReplyOrConfirmationContract.(*_ReplyOrConfirmation).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReplyOrConfirmationConfirmation) IsReplyOrConfirmationConfirmation() {}

func (m *_ReplyOrConfirmationConfirmation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReplyOrConfirmationConfirmation) deepCopy() *_ReplyOrConfirmationConfirmation {
	if m == nil {
		return nil
	}
	_ReplyOrConfirmationConfirmationCopy := &_ReplyOrConfirmationConfirmation{
		m.ReplyOrConfirmationContract.(*_ReplyOrConfirmation).deepCopy(),
		utils.DeepCopy[Confirmation](m.Confirmation),
		utils.DeepCopy[ReplyOrConfirmation](m.EmbeddedReply),
	}
	_ReplyOrConfirmationConfirmationCopy.ReplyOrConfirmationContract.(*_ReplyOrConfirmation)._SubType = m
	return _ReplyOrConfirmationConfirmationCopy
}

func (m *_ReplyOrConfirmationConfirmation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
