/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReplyNetwork is the corresponding interface of ReplyNetwork
type ReplyNetwork interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetNetworkRoute returns NetworkRoute (property field)
	GetNetworkRoute() NetworkRoute
	// GetUnitAddress returns UnitAddress (property field)
	GetUnitAddress() UnitAddress
	// IsReplyNetwork is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReplyNetwork()
	// CreateBuilder creates a ReplyNetworkBuilder
	CreateReplyNetworkBuilder() ReplyNetworkBuilder
}

// _ReplyNetwork is the data-structure of this message
type _ReplyNetwork struct {
	NetworkRoute NetworkRoute
	UnitAddress  UnitAddress
}

var _ ReplyNetwork = (*_ReplyNetwork)(nil)

// NewReplyNetwork factory function for _ReplyNetwork
func NewReplyNetwork(networkRoute NetworkRoute, unitAddress UnitAddress) *_ReplyNetwork {
	if networkRoute == nil {
		panic("networkRoute of type NetworkRoute for ReplyNetwork must not be nil")
	}
	if unitAddress == nil {
		panic("unitAddress of type UnitAddress for ReplyNetwork must not be nil")
	}
	return &_ReplyNetwork{NetworkRoute: networkRoute, UnitAddress: unitAddress}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReplyNetworkBuilder is a builder for ReplyNetwork
type ReplyNetworkBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(networkRoute NetworkRoute, unitAddress UnitAddress) ReplyNetworkBuilder
	// WithNetworkRoute adds NetworkRoute (property field)
	WithNetworkRoute(NetworkRoute) ReplyNetworkBuilder
	// WithNetworkRouteBuilder adds NetworkRoute (property field) which is build by the builder
	WithNetworkRouteBuilder(func(NetworkRouteBuilder) NetworkRouteBuilder) ReplyNetworkBuilder
	// WithUnitAddress adds UnitAddress (property field)
	WithUnitAddress(UnitAddress) ReplyNetworkBuilder
	// WithUnitAddressBuilder adds UnitAddress (property field) which is build by the builder
	WithUnitAddressBuilder(func(UnitAddressBuilder) UnitAddressBuilder) ReplyNetworkBuilder
	// Build builds the ReplyNetwork or returns an error if something is wrong
	Build() (ReplyNetwork, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReplyNetwork
}

// NewReplyNetworkBuilder() creates a ReplyNetworkBuilder
func NewReplyNetworkBuilder() ReplyNetworkBuilder {
	return &_ReplyNetworkBuilder{_ReplyNetwork: new(_ReplyNetwork)}
}

type _ReplyNetworkBuilder struct {
	*_ReplyNetwork

	err *utils.MultiError
}

var _ (ReplyNetworkBuilder) = (*_ReplyNetworkBuilder)(nil)

func (b *_ReplyNetworkBuilder) WithMandatoryFields(networkRoute NetworkRoute, unitAddress UnitAddress) ReplyNetworkBuilder {
	return b.WithNetworkRoute(networkRoute).WithUnitAddress(unitAddress)
}

func (b *_ReplyNetworkBuilder) WithNetworkRoute(networkRoute NetworkRoute) ReplyNetworkBuilder {
	b.NetworkRoute = networkRoute
	return b
}

func (b *_ReplyNetworkBuilder) WithNetworkRouteBuilder(builderSupplier func(NetworkRouteBuilder) NetworkRouteBuilder) ReplyNetworkBuilder {
	builder := builderSupplier(b.NetworkRoute.CreateNetworkRouteBuilder())
	var err error
	b.NetworkRoute, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NetworkRouteBuilder failed"))
	}
	return b
}

func (b *_ReplyNetworkBuilder) WithUnitAddress(unitAddress UnitAddress) ReplyNetworkBuilder {
	b.UnitAddress = unitAddress
	return b
}

func (b *_ReplyNetworkBuilder) WithUnitAddressBuilder(builderSupplier func(UnitAddressBuilder) UnitAddressBuilder) ReplyNetworkBuilder {
	builder := builderSupplier(b.UnitAddress.CreateUnitAddressBuilder())
	var err error
	b.UnitAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "UnitAddressBuilder failed"))
	}
	return b
}

func (b *_ReplyNetworkBuilder) Build() (ReplyNetwork, error) {
	if b.NetworkRoute == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'networkRoute' not set"))
	}
	if b.UnitAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'unitAddress' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReplyNetwork.deepCopy(), nil
}

func (b *_ReplyNetworkBuilder) MustBuild() ReplyNetwork {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReplyNetworkBuilder) DeepCopy() any {
	_copy := b.CreateReplyNetworkBuilder().(*_ReplyNetworkBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReplyNetworkBuilder creates a ReplyNetworkBuilder
func (b *_ReplyNetwork) CreateReplyNetworkBuilder() ReplyNetworkBuilder {
	if b == nil {
		return NewReplyNetworkBuilder()
	}
	return &_ReplyNetworkBuilder{_ReplyNetwork: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReplyNetwork) GetNetworkRoute() NetworkRoute {
	return m.NetworkRoute
}

func (m *_ReplyNetwork) GetUnitAddress() UnitAddress {
	return m.UnitAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReplyNetwork(structType any) ReplyNetwork {
	if casted, ok := structType.(ReplyNetwork); ok {
		return casted
	}
	if casted, ok := structType.(*ReplyNetwork); ok {
		return *casted
	}
	return nil
}

func (m *_ReplyNetwork) GetTypeName() string {
	return "ReplyNetwork"
}

func (m *_ReplyNetwork) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (networkRoute)
	lengthInBits += m.NetworkRoute.GetLengthInBits(ctx)

	// Simple field (unitAddress)
	lengthInBits += m.UnitAddress.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReplyNetwork) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ReplyNetworkParse(ctx context.Context, theBytes []byte) (ReplyNetwork, error) {
	return ReplyNetworkParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ReplyNetworkParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ReplyNetwork, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ReplyNetwork, error) {
		return ReplyNetworkParseWithBuffer(ctx, readBuffer)
	}
}

func ReplyNetworkParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ReplyNetwork, error) {
	v, err := (&_ReplyNetwork{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ReplyNetwork) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__replyNetwork ReplyNetwork, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReplyNetwork"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReplyNetwork")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	networkRoute, err := ReadSimpleField[NetworkRoute](ctx, "networkRoute", ReadComplex[NetworkRoute](NetworkRouteParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkRoute' field"))
	}
	m.NetworkRoute = networkRoute

	unitAddress, err := ReadSimpleField[UnitAddress](ctx, "unitAddress", ReadComplex[UnitAddress](UnitAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unitAddress' field"))
	}
	m.UnitAddress = unitAddress

	if closeErr := readBuffer.CloseContext("ReplyNetwork"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReplyNetwork")
	}

	return m, nil
}

func (m *_ReplyNetwork) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReplyNetwork) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ReplyNetwork"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ReplyNetwork")
	}

	if err := WriteSimpleField[NetworkRoute](ctx, "networkRoute", m.GetNetworkRoute(), WriteComplex[NetworkRoute](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'networkRoute' field")
	}

	if err := WriteSimpleField[UnitAddress](ctx, "unitAddress", m.GetUnitAddress(), WriteComplex[UnitAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'unitAddress' field")
	}

	if popErr := writeBuffer.PopContext("ReplyNetwork"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ReplyNetwork")
	}
	return nil
}

func (m *_ReplyNetwork) IsReplyNetwork() {}

func (m *_ReplyNetwork) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReplyNetwork) deepCopy() *_ReplyNetwork {
	if m == nil {
		return nil
	}
	_ReplyNetworkCopy := &_ReplyNetwork{
		utils.DeepCopy[NetworkRoute](m.NetworkRoute),
		utils.DeepCopy[UnitAddress](m.UnitAddress),
	}
	return _ReplyNetworkCopy
}

func (m *_ReplyNetwork) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
