/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const PowerUp_POWERUPINDICATOR1 byte = 0x2B
const PowerUp_POWERUPINDICATOR2 byte = 0x2B

// PowerUp is the corresponding interface of PowerUp
type PowerUp interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsPowerUp is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPowerUp()
	// CreateBuilder creates a PowerUpBuilder
	CreatePowerUpBuilder() PowerUpBuilder
}

// _PowerUp is the data-structure of this message
type _PowerUp struct {
}

var _ PowerUp = (*_PowerUp)(nil)

// NewPowerUp factory function for _PowerUp
func NewPowerUp() *_PowerUp {
	return &_PowerUp{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PowerUpBuilder is a builder for PowerUp
type PowerUpBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() PowerUpBuilder
	// Build builds the PowerUp or returns an error if something is wrong
	Build() (PowerUp, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PowerUp
}

// NewPowerUpBuilder() creates a PowerUpBuilder
func NewPowerUpBuilder() PowerUpBuilder {
	return &_PowerUpBuilder{_PowerUp: new(_PowerUp)}
}

type _PowerUpBuilder struct {
	*_PowerUp

	err *utils.MultiError
}

var _ (PowerUpBuilder) = (*_PowerUpBuilder)(nil)

func (b *_PowerUpBuilder) WithMandatoryFields() PowerUpBuilder {
	return b
}

func (b *_PowerUpBuilder) Build() (PowerUp, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PowerUp.deepCopy(), nil
}

func (b *_PowerUpBuilder) MustBuild() PowerUp {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PowerUpBuilder) DeepCopy() any {
	_copy := b.CreatePowerUpBuilder().(*_PowerUpBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePowerUpBuilder creates a PowerUpBuilder
func (b *_PowerUp) CreatePowerUpBuilder() PowerUpBuilder {
	if b == nil {
		return NewPowerUpBuilder()
	}
	return &_PowerUpBuilder{_PowerUp: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_PowerUp) GetPowerUpIndicator1() byte {
	return PowerUp_POWERUPINDICATOR1
}

func (m *_PowerUp) GetPowerUpIndicator2() byte {
	return PowerUp_POWERUPINDICATOR2
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPowerUp(structType any) PowerUp {
	if casted, ok := structType.(PowerUp); ok {
		return casted
	}
	if casted, ok := structType.(*PowerUp); ok {
		return *casted
	}
	return nil
}

func (m *_PowerUp) GetTypeName() string {
	return "PowerUp"
}

func (m *_PowerUp) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (powerUpIndicator1)
	lengthInBits += 8

	// Const Field (powerUpIndicator2)
	lengthInBits += 8

	return lengthInBits
}

func (m *_PowerUp) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PowerUpParse(ctx context.Context, theBytes []byte) (PowerUp, error) {
	return PowerUpParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PowerUpParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (PowerUp, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (PowerUp, error) {
		return PowerUpParseWithBuffer(ctx, readBuffer)
	}
}

func PowerUpParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PowerUp, error) {
	v, err := (&_PowerUp{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_PowerUp) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__powerUp PowerUp, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PowerUp"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PowerUp")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	powerUpIndicator1, err := ReadConstField[byte](ctx, "powerUpIndicator1", ReadByte(readBuffer, 8), PowerUp_POWERUPINDICATOR1)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'powerUpIndicator1' field"))
	}
	_ = powerUpIndicator1

	powerUpIndicator2, err := ReadConstField[byte](ctx, "powerUpIndicator2", ReadByte(readBuffer, 8), PowerUp_POWERUPINDICATOR2)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'powerUpIndicator2' field"))
	}
	_ = powerUpIndicator2

	if closeErr := readBuffer.CloseContext("PowerUp"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PowerUp")
	}

	return m, nil
}

func (m *_PowerUp) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PowerUp) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("PowerUp"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for PowerUp")
	}

	if err := WriteConstField(ctx, "powerUpIndicator1", PowerUp_POWERUPINDICATOR1, WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'powerUpIndicator1' field")
	}

	if err := WriteConstField(ctx, "powerUpIndicator2", PowerUp_POWERUPINDICATOR2, WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'powerUpIndicator2' field")
	}

	if popErr := writeBuffer.PopContext("PowerUp"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for PowerUp")
	}
	return nil
}

func (m *_PowerUp) IsPowerUp() {}

func (m *_PowerUp) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PowerUp) deepCopy() *_PowerUp {
	if m == nil {
		return nil
	}
	_PowerUpCopy := &_PowerUp{}
	return _PowerUpCopy
}

func (m *_PowerUp) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
