/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MeasurementData is the corresponding interface of MeasurementData
type MeasurementData interface {
	MeasurementDataContract
	MeasurementDataRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsMeasurementData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeasurementData()
	// CreateBuilder creates a MeasurementDataBuilder
	CreateMeasurementDataBuilder() MeasurementDataBuilder
}

// MeasurementDataContract provides a set of functions which can be overwritten by a sub struct
type MeasurementDataContract interface {
	// GetCommandTypeContainer returns CommandTypeContainer (property field)
	GetCommandTypeContainer() MeasurementCommandTypeContainer
	// GetCommandType returns CommandType (virtual field)
	GetCommandType() MeasurementCommandType
	// IsMeasurementData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeasurementData()
	// CreateBuilder creates a MeasurementDataBuilder
	CreateMeasurementDataBuilder() MeasurementDataBuilder
}

// MeasurementDataRequirements provides a set of functions which need to be implemented by a sub struct
type MeasurementDataRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetCommandType returns CommandType (discriminator field)
	GetCommandType() MeasurementCommandType
}

// _MeasurementData is the data-structure of this message
type _MeasurementData struct {
	_SubType interface {
		MeasurementDataContract
		MeasurementDataRequirements
	}
	CommandTypeContainer MeasurementCommandTypeContainer
}

var _ MeasurementDataContract = (*_MeasurementData)(nil)

// NewMeasurementData factory function for _MeasurementData
func NewMeasurementData(commandTypeContainer MeasurementCommandTypeContainer) *_MeasurementData {
	return &_MeasurementData{CommandTypeContainer: commandTypeContainer}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MeasurementDataBuilder is a builder for MeasurementData
type MeasurementDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(commandTypeContainer MeasurementCommandTypeContainer) MeasurementDataBuilder
	// WithCommandTypeContainer adds CommandTypeContainer (property field)
	WithCommandTypeContainer(MeasurementCommandTypeContainer) MeasurementDataBuilder
	// AsMeasurementDataChannelMeasurementData converts this build to a subType of MeasurementData. It is always possible to return to current builder using Done()
	AsMeasurementDataChannelMeasurementData() MeasurementDataChannelMeasurementDataBuilder
	// Build builds the MeasurementData or returns an error if something is wrong
	PartialBuild() (MeasurementDataContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() MeasurementDataContract
	// Build builds the MeasurementData or returns an error if something is wrong
	Build() (MeasurementData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MeasurementData
}

// NewMeasurementDataBuilder() creates a MeasurementDataBuilder
func NewMeasurementDataBuilder() MeasurementDataBuilder {
	return &_MeasurementDataBuilder{_MeasurementData: new(_MeasurementData)}
}

type _MeasurementDataChildBuilder interface {
	utils.Copyable
	setParent(MeasurementDataContract)
	buildForMeasurementData() (MeasurementData, error)
}

type _MeasurementDataBuilder struct {
	*_MeasurementData

	childBuilder _MeasurementDataChildBuilder

	err *utils.MultiError
}

var _ (MeasurementDataBuilder) = (*_MeasurementDataBuilder)(nil)

func (b *_MeasurementDataBuilder) WithMandatoryFields(commandTypeContainer MeasurementCommandTypeContainer) MeasurementDataBuilder {
	return b.WithCommandTypeContainer(commandTypeContainer)
}

func (b *_MeasurementDataBuilder) WithCommandTypeContainer(commandTypeContainer MeasurementCommandTypeContainer) MeasurementDataBuilder {
	b.CommandTypeContainer = commandTypeContainer
	return b
}

func (b *_MeasurementDataBuilder) PartialBuild() (MeasurementDataContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._MeasurementData.deepCopy(), nil
}

func (b *_MeasurementDataBuilder) PartialMustBuild() MeasurementDataContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeasurementDataBuilder) AsMeasurementDataChannelMeasurementData() MeasurementDataChannelMeasurementDataBuilder {
	if cb, ok := b.childBuilder.(MeasurementDataChannelMeasurementDataBuilder); ok {
		return cb
	}
	cb := NewMeasurementDataChannelMeasurementDataBuilder().(*_MeasurementDataChannelMeasurementDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeasurementDataBuilder) Build() (MeasurementData, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForMeasurementData()
}

func (b *_MeasurementDataBuilder) MustBuild() MeasurementData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeasurementDataBuilder) DeepCopy() any {
	_copy := b.CreateMeasurementDataBuilder().(*_MeasurementDataBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_MeasurementDataChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateMeasurementDataBuilder creates a MeasurementDataBuilder
func (b *_MeasurementData) CreateMeasurementDataBuilder() MeasurementDataBuilder {
	if b == nil {
		return NewMeasurementDataBuilder()
	}
	return &_MeasurementDataBuilder{_MeasurementData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MeasurementData) GetCommandTypeContainer() MeasurementCommandTypeContainer {
	return m.CommandTypeContainer
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_MeasurementData) GetCommandType() MeasurementCommandType {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return CastMeasurementCommandType(m.GetCommandTypeContainer().CommandType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMeasurementData(structType any) MeasurementData {
	if casted, ok := structType.(MeasurementData); ok {
		return casted
	}
	if casted, ok := structType.(*MeasurementData); ok {
		return *casted
	}
	return nil
}

func (m *_MeasurementData) GetTypeName() string {
	return "MeasurementData"
}

func (m *_MeasurementData) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (commandTypeContainer)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_MeasurementData) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_MeasurementData) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func MeasurementDataParse[T MeasurementData](ctx context.Context, theBytes []byte) (T, error) {
	return MeasurementDataParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func MeasurementDataParseWithBufferProducer[T MeasurementData]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := MeasurementDataParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func MeasurementDataParseWithBuffer[T MeasurementData](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_MeasurementData{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_MeasurementData) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__measurementData MeasurementData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MeasurementData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MeasurementData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(KnowsMeasurementCommandTypeContainer(ctx, readBuffer)) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "no command type could be found"})
	}

	commandTypeContainer, err := ReadEnumField[MeasurementCommandTypeContainer](ctx, "commandTypeContainer", "MeasurementCommandTypeContainer", ReadEnum(MeasurementCommandTypeContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandTypeContainer' field"))
	}
	m.CommandTypeContainer = commandTypeContainer

	commandType, err := ReadVirtualField[MeasurementCommandType](ctx, "commandType", (*MeasurementCommandType)(nil), commandTypeContainer.CommandType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandType' field"))
	}
	_ = commandType

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child MeasurementData
	switch {
	case commandType == MeasurementCommandType_MEASUREMENT_EVENT: // MeasurementDataChannelMeasurementData
		if _child, err = new(_MeasurementDataChannelMeasurementData).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeasurementDataChannelMeasurementData for type-switch of MeasurementData")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [commandType=%v]", commandType)
	}

	if closeErr := readBuffer.CloseContext("MeasurementData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MeasurementData")
	}

	return _child, nil
}

func (pm *_MeasurementData) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child MeasurementData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("MeasurementData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for MeasurementData")
	}

	if err := WriteSimpleEnumField[MeasurementCommandTypeContainer](ctx, "commandTypeContainer", "MeasurementCommandTypeContainer", m.GetCommandTypeContainer(), WriteEnum[MeasurementCommandTypeContainer, uint8](MeasurementCommandTypeContainer.GetValue, MeasurementCommandTypeContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'commandTypeContainer' field")
	}
	// Virtual field
	commandType := m.GetCommandType()
	_ = commandType
	if _commandTypeErr := writeBuffer.WriteVirtual(ctx, "commandType", m.GetCommandType()); _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("MeasurementData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for MeasurementData")
	}
	return nil
}

func (m *_MeasurementData) IsMeasurementData() {}

func (m *_MeasurementData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MeasurementData) deepCopy() *_MeasurementData {
	if m == nil {
		return nil
	}
	_MeasurementDataCopy := &_MeasurementData{
		nil, // will be set by child
		m.CommandTypeContainer,
	}
	return _MeasurementDataCopy
}
