/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// InterfaceOptions2 is the corresponding interface of InterfaceOptions2
type InterfaceOptions2 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetBurden returns Burden (property field)
	GetBurden() bool
	// GetClockGen returns ClockGen (property field)
	GetClockGen() bool
	// IsInterfaceOptions2 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsInterfaceOptions2()
	// CreateBuilder creates a InterfaceOptions2Builder
	CreateInterfaceOptions2Builder() InterfaceOptions2Builder
}

// _InterfaceOptions2 is the data-structure of this message
type _InterfaceOptions2 struct {
	Burden   bool
	ClockGen bool
	// Reserved Fields
	reservedField0 *bool
	reservedField1 *bool
	reservedField2 *bool
	reservedField3 *bool
	reservedField4 *bool
	reservedField5 *bool
}

var _ InterfaceOptions2 = (*_InterfaceOptions2)(nil)

// NewInterfaceOptions2 factory function for _InterfaceOptions2
func NewInterfaceOptions2(burden bool, clockGen bool) *_InterfaceOptions2 {
	return &_InterfaceOptions2{Burden: burden, ClockGen: clockGen}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// InterfaceOptions2Builder is a builder for InterfaceOptions2
type InterfaceOptions2Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(burden bool, clockGen bool) InterfaceOptions2Builder
	// WithBurden adds Burden (property field)
	WithBurden(bool) InterfaceOptions2Builder
	// WithClockGen adds ClockGen (property field)
	WithClockGen(bool) InterfaceOptions2Builder
	// Build builds the InterfaceOptions2 or returns an error if something is wrong
	Build() (InterfaceOptions2, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() InterfaceOptions2
}

// NewInterfaceOptions2Builder() creates a InterfaceOptions2Builder
func NewInterfaceOptions2Builder() InterfaceOptions2Builder {
	return &_InterfaceOptions2Builder{_InterfaceOptions2: new(_InterfaceOptions2)}
}

type _InterfaceOptions2Builder struct {
	*_InterfaceOptions2

	err *utils.MultiError
}

var _ (InterfaceOptions2Builder) = (*_InterfaceOptions2Builder)(nil)

func (b *_InterfaceOptions2Builder) WithMandatoryFields(burden bool, clockGen bool) InterfaceOptions2Builder {
	return b.WithBurden(burden).WithClockGen(clockGen)
}

func (b *_InterfaceOptions2Builder) WithBurden(burden bool) InterfaceOptions2Builder {
	b.Burden = burden
	return b
}

func (b *_InterfaceOptions2Builder) WithClockGen(clockGen bool) InterfaceOptions2Builder {
	b.ClockGen = clockGen
	return b
}

func (b *_InterfaceOptions2Builder) Build() (InterfaceOptions2, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._InterfaceOptions2.deepCopy(), nil
}

func (b *_InterfaceOptions2Builder) MustBuild() InterfaceOptions2 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_InterfaceOptions2Builder) DeepCopy() any {
	_copy := b.CreateInterfaceOptions2Builder().(*_InterfaceOptions2Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateInterfaceOptions2Builder creates a InterfaceOptions2Builder
func (b *_InterfaceOptions2) CreateInterfaceOptions2Builder() InterfaceOptions2Builder {
	if b == nil {
		return NewInterfaceOptions2Builder()
	}
	return &_InterfaceOptions2Builder{_InterfaceOptions2: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_InterfaceOptions2) GetBurden() bool {
	return m.Burden
}

func (m *_InterfaceOptions2) GetClockGen() bool {
	return m.ClockGen
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastInterfaceOptions2(structType any) InterfaceOptions2 {
	if casted, ok := structType.(InterfaceOptions2); ok {
		return casted
	}
	if casted, ok := structType.(*InterfaceOptions2); ok {
		return *casted
	}
	return nil
}

func (m *_InterfaceOptions2) GetTypeName() string {
	return "InterfaceOptions2"
}

func (m *_InterfaceOptions2) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (burden)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (clockGen)
	lengthInBits += 1

	return lengthInBits
}

func (m *_InterfaceOptions2) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func InterfaceOptions2Parse(ctx context.Context, theBytes []byte) (InterfaceOptions2, error) {
	return InterfaceOptions2ParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func InterfaceOptions2ParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions2, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions2, error) {
		return InterfaceOptions2ParseWithBuffer(ctx, readBuffer)
	}
}

func InterfaceOptions2ParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions2, error) {
	v, err := (&_InterfaceOptions2{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_InterfaceOptions2) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__interfaceOptions2 InterfaceOptions2, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("InterfaceOptions2"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for InterfaceOptions2")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	burden, err := ReadSimpleField(ctx, "burden", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'burden' field"))
	}
	m.Burden = burden

	reservedField1, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField1 = reservedField1

	reservedField2, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField2 = reservedField2

	reservedField3, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField3 = reservedField3

	reservedField4, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField4 = reservedField4

	reservedField5, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField5 = reservedField5

	clockGen, err := ReadSimpleField(ctx, "clockGen", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clockGen' field"))
	}
	m.ClockGen = clockGen

	if closeErr := readBuffer.CloseContext("InterfaceOptions2"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for InterfaceOptions2")
	}

	return m, nil
}

func (m *_InterfaceOptions2) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_InterfaceOptions2) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("InterfaceOptions2"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for InterfaceOptions2")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "burden", m.GetBurden(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'burden' field")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 2")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 3")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 4")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 5")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 6")
	}

	if err := WriteSimpleField[bool](ctx, "clockGen", m.GetClockGen(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'clockGen' field")
	}

	if popErr := writeBuffer.PopContext("InterfaceOptions2"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for InterfaceOptions2")
	}
	return nil
}

func (m *_InterfaceOptions2) IsInterfaceOptions2() {}

func (m *_InterfaceOptions2) DeepCopy() any {
	return m.deepCopy()
}

func (m *_InterfaceOptions2) deepCopy() *_InterfaceOptions2 {
	if m == nil {
		return nil
	}
	_InterfaceOptions2Copy := &_InterfaceOptions2{
		m.Burden,
		m.ClockGen,
		m.reservedField0,
		m.reservedField1,
		m.reservedField2,
		m.reservedField3,
		m.reservedField4,
		m.reservedField5,
	}
	return _InterfaceOptions2Copy
}

func (m *_InterfaceOptions2) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
