/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandGAVValuesCurrent is the corresponding interface of IdentifyReplyCommandGAVValuesCurrent
type IdentifyReplyCommandGAVValuesCurrent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetValues returns Values (property field)
	GetValues() []byte
	// IsIdentifyReplyCommandGAVValuesCurrent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandGAVValuesCurrent()
	// CreateBuilder creates a IdentifyReplyCommandGAVValuesCurrentBuilder
	CreateIdentifyReplyCommandGAVValuesCurrentBuilder() IdentifyReplyCommandGAVValuesCurrentBuilder
}

// _IdentifyReplyCommandGAVValuesCurrent is the data-structure of this message
type _IdentifyReplyCommandGAVValuesCurrent struct {
	IdentifyReplyCommandContract
	Values []byte
}

var _ IdentifyReplyCommandGAVValuesCurrent = (*_IdentifyReplyCommandGAVValuesCurrent)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandGAVValuesCurrent)(nil)

// NewIdentifyReplyCommandGAVValuesCurrent factory function for _IdentifyReplyCommandGAVValuesCurrent
func NewIdentifyReplyCommandGAVValuesCurrent(values []byte, numBytes uint8) *_IdentifyReplyCommandGAVValuesCurrent {
	_result := &_IdentifyReplyCommandGAVValuesCurrent{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		Values:                       values,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandGAVValuesCurrentBuilder is a builder for IdentifyReplyCommandGAVValuesCurrent
type IdentifyReplyCommandGAVValuesCurrentBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(values []byte) IdentifyReplyCommandGAVValuesCurrentBuilder
	// WithValues adds Values (property field)
	WithValues(...byte) IdentifyReplyCommandGAVValuesCurrentBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandGAVValuesCurrent or returns an error if something is wrong
	Build() (IdentifyReplyCommandGAVValuesCurrent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandGAVValuesCurrent
}

// NewIdentifyReplyCommandGAVValuesCurrentBuilder() creates a IdentifyReplyCommandGAVValuesCurrentBuilder
func NewIdentifyReplyCommandGAVValuesCurrentBuilder() IdentifyReplyCommandGAVValuesCurrentBuilder {
	return &_IdentifyReplyCommandGAVValuesCurrentBuilder{_IdentifyReplyCommandGAVValuesCurrent: new(_IdentifyReplyCommandGAVValuesCurrent)}
}

type _IdentifyReplyCommandGAVValuesCurrentBuilder struct {
	*_IdentifyReplyCommandGAVValuesCurrent

	parentBuilder *_IdentifyReplyCommandBuilder

	err *utils.MultiError
}

var _ (IdentifyReplyCommandGAVValuesCurrentBuilder) = (*_IdentifyReplyCommandGAVValuesCurrentBuilder)(nil)

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandGAVValuesCurrent
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) WithMandatoryFields(values []byte) IdentifyReplyCommandGAVValuesCurrentBuilder {
	return b.WithValues(values...)
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) WithValues(values ...byte) IdentifyReplyCommandGAVValuesCurrentBuilder {
	b.Values = values
	return b
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) Build() (IdentifyReplyCommandGAVValuesCurrent, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._IdentifyReplyCommandGAVValuesCurrent.deepCopy(), nil
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) MustBuild() IdentifyReplyCommandGAVValuesCurrent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandGAVValuesCurrentBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandGAVValuesCurrentBuilder().(*_IdentifyReplyCommandGAVValuesCurrentBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateIdentifyReplyCommandGAVValuesCurrentBuilder creates a IdentifyReplyCommandGAVValuesCurrentBuilder
func (b *_IdentifyReplyCommandGAVValuesCurrent) CreateIdentifyReplyCommandGAVValuesCurrentBuilder() IdentifyReplyCommandGAVValuesCurrentBuilder {
	if b == nil {
		return NewIdentifyReplyCommandGAVValuesCurrentBuilder()
	}
	return &_IdentifyReplyCommandGAVValuesCurrentBuilder{_IdentifyReplyCommandGAVValuesCurrent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetAttribute() Attribute {
	return Attribute_GAVValuesCurrent
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetValues() []byte {
	return m.Values
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandGAVValuesCurrent(structType any) IdentifyReplyCommandGAVValuesCurrent {
	if casted, ok := structType.(IdentifyReplyCommandGAVValuesCurrent); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandGAVValuesCurrent); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetTypeName() string {
	return "IdentifyReplyCommandGAVValuesCurrent"
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Array field
	if len(m.Values) > 0 {
		lengthInBits += 8 * uint16(len(m.Values))
	}

	return lengthInBits
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandGAVValuesCurrent IdentifyReplyCommandGAVValuesCurrent, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandGAVValuesCurrent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandGAVValuesCurrent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	values, err := readBuffer.ReadByteArray("values", int(numBytes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'values' field"))
	}
	m.Values = values

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandGAVValuesCurrent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandGAVValuesCurrent")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandGAVValuesCurrent"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandGAVValuesCurrent")
		}

		if err := WriteByteArrayField(ctx, "values", m.GetValues(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'values' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandGAVValuesCurrent"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandGAVValuesCurrent")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) IsIdentifyReplyCommandGAVValuesCurrent() {}

func (m *_IdentifyReplyCommandGAVValuesCurrent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) deepCopy() *_IdentifyReplyCommandGAVValuesCurrent {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandGAVValuesCurrentCopy := &_IdentifyReplyCommandGAVValuesCurrent{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.Values),
	}
	_IdentifyReplyCommandGAVValuesCurrentCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandGAVValuesCurrentCopy
}

func (m *_IdentifyReplyCommandGAVValuesCurrent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
