/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandGAVPhysicalAddresses is the corresponding interface of IdentifyReplyCommandGAVPhysicalAddresses
type IdentifyReplyCommandGAVPhysicalAddresses interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetValues returns Values (property field)
	GetValues() []byte
	// IsIdentifyReplyCommandGAVPhysicalAddresses is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandGAVPhysicalAddresses()
	// CreateBuilder creates a IdentifyReplyCommandGAVPhysicalAddressesBuilder
	CreateIdentifyReplyCommandGAVPhysicalAddressesBuilder() IdentifyReplyCommandGAVPhysicalAddressesBuilder
}

// _IdentifyReplyCommandGAVPhysicalAddresses is the data-structure of this message
type _IdentifyReplyCommandGAVPhysicalAddresses struct {
	IdentifyReplyCommandContract
	Values []byte
}

var _ IdentifyReplyCommandGAVPhysicalAddresses = (*_IdentifyReplyCommandGAVPhysicalAddresses)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandGAVPhysicalAddresses)(nil)

// NewIdentifyReplyCommandGAVPhysicalAddresses factory function for _IdentifyReplyCommandGAVPhysicalAddresses
func NewIdentifyReplyCommandGAVPhysicalAddresses(values []byte, numBytes uint8) *_IdentifyReplyCommandGAVPhysicalAddresses {
	_result := &_IdentifyReplyCommandGAVPhysicalAddresses{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		Values:                       values,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandGAVPhysicalAddressesBuilder is a builder for IdentifyReplyCommandGAVPhysicalAddresses
type IdentifyReplyCommandGAVPhysicalAddressesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(values []byte) IdentifyReplyCommandGAVPhysicalAddressesBuilder
	// WithValues adds Values (property field)
	WithValues(...byte) IdentifyReplyCommandGAVPhysicalAddressesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandGAVPhysicalAddresses or returns an error if something is wrong
	Build() (IdentifyReplyCommandGAVPhysicalAddresses, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandGAVPhysicalAddresses
}

// NewIdentifyReplyCommandGAVPhysicalAddressesBuilder() creates a IdentifyReplyCommandGAVPhysicalAddressesBuilder
func NewIdentifyReplyCommandGAVPhysicalAddressesBuilder() IdentifyReplyCommandGAVPhysicalAddressesBuilder {
	return &_IdentifyReplyCommandGAVPhysicalAddressesBuilder{_IdentifyReplyCommandGAVPhysicalAddresses: new(_IdentifyReplyCommandGAVPhysicalAddresses)}
}

type _IdentifyReplyCommandGAVPhysicalAddressesBuilder struct {
	*_IdentifyReplyCommandGAVPhysicalAddresses

	parentBuilder *_IdentifyReplyCommandBuilder

	err *utils.MultiError
}

var _ (IdentifyReplyCommandGAVPhysicalAddressesBuilder) = (*_IdentifyReplyCommandGAVPhysicalAddressesBuilder)(nil)

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandGAVPhysicalAddresses
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) WithMandatoryFields(values []byte) IdentifyReplyCommandGAVPhysicalAddressesBuilder {
	return b.WithValues(values...)
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) WithValues(values ...byte) IdentifyReplyCommandGAVPhysicalAddressesBuilder {
	b.Values = values
	return b
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) Build() (IdentifyReplyCommandGAVPhysicalAddresses, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._IdentifyReplyCommandGAVPhysicalAddresses.deepCopy(), nil
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) MustBuild() IdentifyReplyCommandGAVPhysicalAddresses {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandGAVPhysicalAddressesBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandGAVPhysicalAddressesBuilder().(*_IdentifyReplyCommandGAVPhysicalAddressesBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateIdentifyReplyCommandGAVPhysicalAddressesBuilder creates a IdentifyReplyCommandGAVPhysicalAddressesBuilder
func (b *_IdentifyReplyCommandGAVPhysicalAddresses) CreateIdentifyReplyCommandGAVPhysicalAddressesBuilder() IdentifyReplyCommandGAVPhysicalAddressesBuilder {
	if b == nil {
		return NewIdentifyReplyCommandGAVPhysicalAddressesBuilder()
	}
	return &_IdentifyReplyCommandGAVPhysicalAddressesBuilder{_IdentifyReplyCommandGAVPhysicalAddresses: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetAttribute() Attribute {
	return Attribute_GAVPhysicalAddresses
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetValues() []byte {
	return m.Values
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandGAVPhysicalAddresses(structType any) IdentifyReplyCommandGAVPhysicalAddresses {
	if casted, ok := structType.(IdentifyReplyCommandGAVPhysicalAddresses); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandGAVPhysicalAddresses); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetTypeName() string {
	return "IdentifyReplyCommandGAVPhysicalAddresses"
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Array field
	if len(m.Values) > 0 {
		lengthInBits += 8 * uint16(len(m.Values))
	}

	return lengthInBits
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandGAVPhysicalAddresses IdentifyReplyCommandGAVPhysicalAddresses, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandGAVPhysicalAddresses"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandGAVPhysicalAddresses")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	values, err := readBuffer.ReadByteArray("values", int(numBytes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'values' field"))
	}
	m.Values = values

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandGAVPhysicalAddresses"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandGAVPhysicalAddresses")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandGAVPhysicalAddresses"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandGAVPhysicalAddresses")
		}

		if err := WriteByteArrayField(ctx, "values", m.GetValues(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'values' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandGAVPhysicalAddresses"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandGAVPhysicalAddresses")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) IsIdentifyReplyCommandGAVPhysicalAddresses() {}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) deepCopy() *_IdentifyReplyCommandGAVPhysicalAddresses {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandGAVPhysicalAddressesCopy := &_IdentifyReplyCommandGAVPhysicalAddresses{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.Values),
	}
	_IdentifyReplyCommandGAVPhysicalAddressesCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandGAVPhysicalAddressesCopy
}

func (m *_IdentifyReplyCommandGAVPhysicalAddresses) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
