/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommand is the corresponding interface of IdentifyReplyCommand
type IdentifyReplyCommand interface {
	IdentifyReplyCommandContract
	IdentifyReplyCommandRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsIdentifyReplyCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommand()
	// CreateBuilder creates a IdentifyReplyCommandBuilder
	CreateIdentifyReplyCommandBuilder() IdentifyReplyCommandBuilder
}

// IdentifyReplyCommandContract provides a set of functions which can be overwritten by a sub struct
type IdentifyReplyCommandContract interface {
	// GetNumBytes() returns a parser argument
	GetNumBytes() uint8
	// IsIdentifyReplyCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommand()
	// CreateBuilder creates a IdentifyReplyCommandBuilder
	CreateIdentifyReplyCommandBuilder() IdentifyReplyCommandBuilder
}

// IdentifyReplyCommandRequirements provides a set of functions which need to be implemented by a sub struct
type IdentifyReplyCommandRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetAttribute returns Attribute (discriminator field)
	GetAttribute() Attribute
}

// _IdentifyReplyCommand is the data-structure of this message
type _IdentifyReplyCommand struct {
	_SubType interface {
		IdentifyReplyCommandContract
		IdentifyReplyCommandRequirements
	}

	// Arguments.
	NumBytes uint8
}

var _ IdentifyReplyCommandContract = (*_IdentifyReplyCommand)(nil)

// NewIdentifyReplyCommand factory function for _IdentifyReplyCommand
func NewIdentifyReplyCommand(numBytes uint8) *_IdentifyReplyCommand {
	return &_IdentifyReplyCommand{NumBytes: numBytes}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandBuilder is a builder for IdentifyReplyCommand
type IdentifyReplyCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() IdentifyReplyCommandBuilder
	// WithArgNumBytes sets a parser argument
	WithArgNumBytes(uint8) IdentifyReplyCommandBuilder
	// AsIdentifyReplyCommandManufacturer converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandManufacturer() IdentifyReplyCommandManufacturerBuilder
	// AsIdentifyReplyCommandType converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandType() IdentifyReplyCommandTypeBuilder
	// AsIdentifyReplyCommandFirmwareVersion converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandFirmwareVersion() IdentifyReplyCommandFirmwareVersionBuilder
	// AsIdentifyReplyCommandSummary converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandSummary() IdentifyReplyCommandSummaryBuilder
	// AsIdentifyReplyCommandExtendedDiagnosticSummary converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandExtendedDiagnosticSummary() IdentifyReplyCommandExtendedDiagnosticSummaryBuilder
	// AsIdentifyReplyCommandNetworkTerminalLevels converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandNetworkTerminalLevels() IdentifyReplyCommandNetworkTerminalLevelsBuilder
	// AsIdentifyReplyCommandTerminalLevels converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandTerminalLevels() IdentifyReplyCommandTerminalLevelsBuilder
	// AsIdentifyReplyCommandNetworkVoltage converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandNetworkVoltage() IdentifyReplyCommandNetworkVoltageBuilder
	// AsIdentifyReplyCommandGAVValuesCurrent converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandGAVValuesCurrent() IdentifyReplyCommandGAVValuesCurrentBuilder
	// AsIdentifyReplyCommandGAVValuesStored converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandGAVValuesStored() IdentifyReplyCommandGAVValuesStoredBuilder
	// AsIdentifyReplyCommandGAVPhysicalAddresses converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandGAVPhysicalAddresses() IdentifyReplyCommandGAVPhysicalAddressesBuilder
	// AsIdentifyReplyCommandLogicalAssignment converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandLogicalAssignment() IdentifyReplyCommandLogicalAssignmentBuilder
	// AsIdentifyReplyCommandDelays converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandDelays() IdentifyReplyCommandDelaysBuilder
	// AsIdentifyReplyCommandMinimumLevels converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandMinimumLevels() IdentifyReplyCommandMinimumLevelsBuilder
	// AsIdentifyReplyCommandMaximumLevels converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandMaximumLevels() IdentifyReplyCommandMaximumLevelsBuilder
	// AsIdentifyReplyCommandCurrentSenseLevels converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandCurrentSenseLevels() IdentifyReplyCommandCurrentSenseLevelsBuilder
	// AsIdentifyReplyCommandOutputUnitSummary converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandOutputUnitSummary() IdentifyReplyCommandOutputUnitSummaryBuilder
	// AsIdentifyReplyCommandDSIStatus converts this build to a subType of IdentifyReplyCommand. It is always possible to return to current builder using Done()
	AsIdentifyReplyCommandDSIStatus() IdentifyReplyCommandDSIStatusBuilder
	// Build builds the IdentifyReplyCommand or returns an error if something is wrong
	PartialBuild() (IdentifyReplyCommandContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() IdentifyReplyCommandContract
	// Build builds the IdentifyReplyCommand or returns an error if something is wrong
	Build() (IdentifyReplyCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommand
}

// NewIdentifyReplyCommandBuilder() creates a IdentifyReplyCommandBuilder
func NewIdentifyReplyCommandBuilder() IdentifyReplyCommandBuilder {
	return &_IdentifyReplyCommandBuilder{_IdentifyReplyCommand: new(_IdentifyReplyCommand)}
}

type _IdentifyReplyCommandChildBuilder interface {
	utils.Copyable
	setParent(IdentifyReplyCommandContract)
	buildForIdentifyReplyCommand() (IdentifyReplyCommand, error)
}

type _IdentifyReplyCommandBuilder struct {
	*_IdentifyReplyCommand

	childBuilder _IdentifyReplyCommandChildBuilder

	err *utils.MultiError
}

var _ (IdentifyReplyCommandBuilder) = (*_IdentifyReplyCommandBuilder)(nil)

func (b *_IdentifyReplyCommandBuilder) WithMandatoryFields() IdentifyReplyCommandBuilder {
	return b
}

func (b *_IdentifyReplyCommandBuilder) WithArgNumBytes(numBytes uint8) IdentifyReplyCommandBuilder {
	b.NumBytes = numBytes
	return b
}

func (b *_IdentifyReplyCommandBuilder) PartialBuild() (IdentifyReplyCommandContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._IdentifyReplyCommand.deepCopy(), nil
}

func (b *_IdentifyReplyCommandBuilder) PartialMustBuild() IdentifyReplyCommandContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandManufacturer() IdentifyReplyCommandManufacturerBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandManufacturerBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandManufacturerBuilder().(*_IdentifyReplyCommandManufacturerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandType() IdentifyReplyCommandTypeBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandTypeBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandTypeBuilder().(*_IdentifyReplyCommandTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandFirmwareVersion() IdentifyReplyCommandFirmwareVersionBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandFirmwareVersionBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandFirmwareVersionBuilder().(*_IdentifyReplyCommandFirmwareVersionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandSummary() IdentifyReplyCommandSummaryBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandSummaryBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandSummaryBuilder().(*_IdentifyReplyCommandSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandExtendedDiagnosticSummary() IdentifyReplyCommandExtendedDiagnosticSummaryBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandExtendedDiagnosticSummaryBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandExtendedDiagnosticSummaryBuilder().(*_IdentifyReplyCommandExtendedDiagnosticSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandNetworkTerminalLevels() IdentifyReplyCommandNetworkTerminalLevelsBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandNetworkTerminalLevelsBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandNetworkTerminalLevelsBuilder().(*_IdentifyReplyCommandNetworkTerminalLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandTerminalLevels() IdentifyReplyCommandTerminalLevelsBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandTerminalLevelsBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandTerminalLevelsBuilder().(*_IdentifyReplyCommandTerminalLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandNetworkVoltage() IdentifyReplyCommandNetworkVoltageBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandNetworkVoltageBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandNetworkVoltageBuilder().(*_IdentifyReplyCommandNetworkVoltageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandGAVValuesCurrent() IdentifyReplyCommandGAVValuesCurrentBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandGAVValuesCurrentBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandGAVValuesCurrentBuilder().(*_IdentifyReplyCommandGAVValuesCurrentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandGAVValuesStored() IdentifyReplyCommandGAVValuesStoredBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandGAVValuesStoredBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandGAVValuesStoredBuilder().(*_IdentifyReplyCommandGAVValuesStoredBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandGAVPhysicalAddresses() IdentifyReplyCommandGAVPhysicalAddressesBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandGAVPhysicalAddressesBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandGAVPhysicalAddressesBuilder().(*_IdentifyReplyCommandGAVPhysicalAddressesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandLogicalAssignment() IdentifyReplyCommandLogicalAssignmentBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandLogicalAssignmentBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandLogicalAssignmentBuilder().(*_IdentifyReplyCommandLogicalAssignmentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandDelays() IdentifyReplyCommandDelaysBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandDelaysBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandDelaysBuilder().(*_IdentifyReplyCommandDelaysBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandMinimumLevels() IdentifyReplyCommandMinimumLevelsBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandMinimumLevelsBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandMinimumLevelsBuilder().(*_IdentifyReplyCommandMinimumLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandMaximumLevels() IdentifyReplyCommandMaximumLevelsBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandMaximumLevelsBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandMaximumLevelsBuilder().(*_IdentifyReplyCommandMaximumLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandCurrentSenseLevels() IdentifyReplyCommandCurrentSenseLevelsBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandCurrentSenseLevelsBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandCurrentSenseLevelsBuilder().(*_IdentifyReplyCommandCurrentSenseLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandOutputUnitSummary() IdentifyReplyCommandOutputUnitSummaryBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandOutputUnitSummaryBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandOutputUnitSummaryBuilder().(*_IdentifyReplyCommandOutputUnitSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) AsIdentifyReplyCommandDSIStatus() IdentifyReplyCommandDSIStatusBuilder {
	if cb, ok := b.childBuilder.(IdentifyReplyCommandDSIStatusBuilder); ok {
		return cb
	}
	cb := NewIdentifyReplyCommandDSIStatusBuilder().(*_IdentifyReplyCommandDSIStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_IdentifyReplyCommandBuilder) Build() (IdentifyReplyCommand, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForIdentifyReplyCommand()
}

func (b *_IdentifyReplyCommandBuilder) MustBuild() IdentifyReplyCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_IdentifyReplyCommandChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateIdentifyReplyCommandBuilder creates a IdentifyReplyCommandBuilder
func (b *_IdentifyReplyCommand) CreateIdentifyReplyCommandBuilder() IdentifyReplyCommandBuilder {
	if b == nil {
		return NewIdentifyReplyCommandBuilder()
	}
	return &_IdentifyReplyCommandBuilder{_IdentifyReplyCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommand(structType any) IdentifyReplyCommand {
	if casted, ok := structType.(IdentifyReplyCommand); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommand); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommand) GetTypeName() string {
	return "IdentifyReplyCommand"
}

func (m *_IdentifyReplyCommand) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_IdentifyReplyCommand) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_IdentifyReplyCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func IdentifyReplyCommandParse[T IdentifyReplyCommand](ctx context.Context, theBytes []byte, attribute Attribute, numBytes uint8) (T, error) {
	return IdentifyReplyCommandParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), attribute, numBytes)
}

func IdentifyReplyCommandParseWithBufferProducer[T IdentifyReplyCommand](attribute Attribute, numBytes uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := IdentifyReplyCommandParseWithBuffer[T](ctx, readBuffer, attribute, numBytes)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func IdentifyReplyCommandParseWithBuffer[T IdentifyReplyCommand](ctx context.Context, readBuffer utils.ReadBuffer, attribute Attribute, numBytes uint8) (T, error) {
	v, err := (&_IdentifyReplyCommand{NumBytes: numBytes}).parse(ctx, readBuffer, attribute, numBytes)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_IdentifyReplyCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer, attribute Attribute, numBytes uint8) (__identifyReplyCommand IdentifyReplyCommand, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child IdentifyReplyCommand
	switch {
	case attribute == Attribute_Manufacturer: // IdentifyReplyCommandManufacturer
		if _child, err = new(_IdentifyReplyCommandManufacturer).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandManufacturer for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_Type: // IdentifyReplyCommandType
		if _child, err = new(_IdentifyReplyCommandType).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandType for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_FirmwareVersion: // IdentifyReplyCommandFirmwareVersion
		if _child, err = new(_IdentifyReplyCommandFirmwareVersion).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandFirmwareVersion for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_Summary: // IdentifyReplyCommandSummary
		if _child, err = new(_IdentifyReplyCommandSummary).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandSummary for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_ExtendedDiagnosticSummary: // IdentifyReplyCommandExtendedDiagnosticSummary
		if _child, err = new(_IdentifyReplyCommandExtendedDiagnosticSummary).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandExtendedDiagnosticSummary for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_NetworkTerminalLevels: // IdentifyReplyCommandNetworkTerminalLevels
		if _child, err = new(_IdentifyReplyCommandNetworkTerminalLevels).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandNetworkTerminalLevels for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_TerminalLevel: // IdentifyReplyCommandTerminalLevels
		if _child, err = new(_IdentifyReplyCommandTerminalLevels).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandTerminalLevels for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_NetworkVoltage: // IdentifyReplyCommandNetworkVoltage
		if _child, err = new(_IdentifyReplyCommandNetworkVoltage).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandNetworkVoltage for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_GAVValuesCurrent: // IdentifyReplyCommandGAVValuesCurrent
		if _child, err = new(_IdentifyReplyCommandGAVValuesCurrent).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandGAVValuesCurrent for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_GAVValuesStored: // IdentifyReplyCommandGAVValuesStored
		if _child, err = new(_IdentifyReplyCommandGAVValuesStored).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandGAVValuesStored for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_GAVPhysicalAddresses: // IdentifyReplyCommandGAVPhysicalAddresses
		if _child, err = new(_IdentifyReplyCommandGAVPhysicalAddresses).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandGAVPhysicalAddresses for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_LogicalAssignment: // IdentifyReplyCommandLogicalAssignment
		if _child, err = new(_IdentifyReplyCommandLogicalAssignment).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandLogicalAssignment for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_Delays: // IdentifyReplyCommandDelays
		if _child, err = new(_IdentifyReplyCommandDelays).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandDelays for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_MinimumLevels: // IdentifyReplyCommandMinimumLevels
		if _child, err = new(_IdentifyReplyCommandMinimumLevels).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandMinimumLevels for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_MaximumLevels: // IdentifyReplyCommandMaximumLevels
		if _child, err = new(_IdentifyReplyCommandMaximumLevels).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandMaximumLevels for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_CurrentSenseLevels: // IdentifyReplyCommandCurrentSenseLevels
		if _child, err = new(_IdentifyReplyCommandCurrentSenseLevels).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandCurrentSenseLevels for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_OutputUnitSummary: // IdentifyReplyCommandOutputUnitSummary
		if _child, err = new(_IdentifyReplyCommandOutputUnitSummary).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandOutputUnitSummary for type-switch of IdentifyReplyCommand")
		}
	case attribute == Attribute_DSIStatus: // IdentifyReplyCommandDSIStatus
		if _child, err = new(_IdentifyReplyCommandDSIStatus).parse(ctx, readBuffer, m, attribute, numBytes); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentifyReplyCommandDSIStatus for type-switch of IdentifyReplyCommand")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [attribute=%v]", attribute)
	}

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommand")
	}

	return _child, nil
}

func (pm *_IdentifyReplyCommand) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child IdentifyReplyCommand, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("IdentifyReplyCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommand")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("IdentifyReplyCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for IdentifyReplyCommand")
	}
	return nil
}

////
// Arguments Getter

func (m *_IdentifyReplyCommand) GetNumBytes() uint8 {
	return m.NumBytes
}

//
////

func (m *_IdentifyReplyCommand) IsIdentifyReplyCommand() {}

func (m *_IdentifyReplyCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommand) deepCopy() *_IdentifyReplyCommand {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandCopy := &_IdentifyReplyCommand{
		nil, // will be set by child
		m.NumBytes,
	}
	return _IdentifyReplyCommandCopy
}
