/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const CBusConstants_CBUSTCPDEFAULTPORT uint16 = uint16(10001)

// CBusConstants is the corresponding interface of CBusConstants
type CBusConstants interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsCBusConstants is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusConstants()
	// CreateBuilder creates a CBusConstantsBuilder
	CreateCBusConstantsBuilder() CBusConstantsBuilder
}

// _CBusConstants is the data-structure of this message
type _CBusConstants struct {
}

var _ CBusConstants = (*_CBusConstants)(nil)

// NewCBusConstants factory function for _CBusConstants
func NewCBusConstants() *_CBusConstants {
	return &_CBusConstants{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CBusConstantsBuilder is a builder for CBusConstants
type CBusConstantsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() CBusConstantsBuilder
	// Build builds the CBusConstants or returns an error if something is wrong
	Build() (CBusConstants, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CBusConstants
}

// NewCBusConstantsBuilder() creates a CBusConstantsBuilder
func NewCBusConstantsBuilder() CBusConstantsBuilder {
	return &_CBusConstantsBuilder{_CBusConstants: new(_CBusConstants)}
}

type _CBusConstantsBuilder struct {
	*_CBusConstants

	err *utils.MultiError
}

var _ (CBusConstantsBuilder) = (*_CBusConstantsBuilder)(nil)

func (b *_CBusConstantsBuilder) WithMandatoryFields() CBusConstantsBuilder {
	return b
}

func (b *_CBusConstantsBuilder) Build() (CBusConstants, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._CBusConstants.deepCopy(), nil
}

func (b *_CBusConstantsBuilder) MustBuild() CBusConstants {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusConstantsBuilder) DeepCopy() any {
	_copy := b.CreateCBusConstantsBuilder().(*_CBusConstantsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateCBusConstantsBuilder creates a CBusConstantsBuilder
func (b *_CBusConstants) CreateCBusConstantsBuilder() CBusConstantsBuilder {
	if b == nil {
		return NewCBusConstantsBuilder()
	}
	return &_CBusConstantsBuilder{_CBusConstants: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_CBusConstants) GetCbusTcpDefaultPort() uint16 {
	return CBusConstants_CBUSTCPDEFAULTPORT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCBusConstants(structType any) CBusConstants {
	if casted, ok := structType.(CBusConstants); ok {
		return casted
	}
	if casted, ok := structType.(*CBusConstants); ok {
		return *casted
	}
	return nil
}

func (m *_CBusConstants) GetTypeName() string {
	return "CBusConstants"
}

func (m *_CBusConstants) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (cbusTcpDefaultPort)
	lengthInBits += 16

	return lengthInBits
}

func (m *_CBusConstants) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CBusConstantsParse(ctx context.Context, theBytes []byte) (CBusConstants, error) {
	return CBusConstantsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func CBusConstantsParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (CBusConstants, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (CBusConstants, error) {
		return CBusConstantsParseWithBuffer(ctx, readBuffer)
	}
}

func CBusConstantsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (CBusConstants, error) {
	v, err := (&_CBusConstants{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_CBusConstants) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__cBusConstants CBusConstants, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusConstants"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusConstants")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	cbusTcpDefaultPort, err := ReadConstField[uint16](ctx, "cbusTcpDefaultPort", ReadUnsignedShort(readBuffer, uint8(16)), CBusConstants_CBUSTCPDEFAULTPORT)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'cbusTcpDefaultPort' field"))
	}
	_ = cbusTcpDefaultPort

	if closeErr := readBuffer.CloseContext("CBusConstants"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusConstants")
	}

	return m, nil
}

func (m *_CBusConstants) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CBusConstants) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("CBusConstants"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CBusConstants")
	}

	if err := WriteConstField(ctx, "cbusTcpDefaultPort", CBusConstants_CBUSTCPDEFAULTPORT, WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'cbusTcpDefaultPort' field")
	}

	if popErr := writeBuffer.PopContext("CBusConstants"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CBusConstants")
	}
	return nil
}

func (m *_CBusConstants) IsCBusConstants() {}

func (m *_CBusConstants) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CBusConstants) deepCopy() *_CBusConstants {
	if m == nil {
		return nil
	}
	_CBusConstantsCopy := &_CBusConstants{}
	return _CBusConstantsCopy
}

func (m *_CBusConstants) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
