/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CALDataIdentify is the corresponding interface of CALDataIdentify
type CALDataIdentify interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CALData
	// GetAttribute returns Attribute (property field)
	GetAttribute() Attribute
	// IsCALDataIdentify is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCALDataIdentify()
	// CreateBuilder creates a CALDataIdentifyBuilder
	CreateCALDataIdentifyBuilder() CALDataIdentifyBuilder
}

// _CALDataIdentify is the data-structure of this message
type _CALDataIdentify struct {
	CALDataContract
	Attribute Attribute
}

var _ CALDataIdentify = (*_CALDataIdentify)(nil)
var _ CALDataRequirements = (*_CALDataIdentify)(nil)

// NewCALDataIdentify factory function for _CALDataIdentify
func NewCALDataIdentify(commandTypeContainer CALCommandTypeContainer, additionalData CALData, attribute Attribute, requestContext RequestContext) *_CALDataIdentify {
	_result := &_CALDataIdentify{
		CALDataContract: NewCALData(commandTypeContainer, additionalData, requestContext),
		Attribute:       attribute,
	}
	_result.CALDataContract.(*_CALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CALDataIdentifyBuilder is a builder for CALDataIdentify
type CALDataIdentifyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(attribute Attribute) CALDataIdentifyBuilder
	// WithAttribute adds Attribute (property field)
	WithAttribute(Attribute) CALDataIdentifyBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CALDataBuilder
	// Build builds the CALDataIdentify or returns an error if something is wrong
	Build() (CALDataIdentify, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CALDataIdentify
}

// NewCALDataIdentifyBuilder() creates a CALDataIdentifyBuilder
func NewCALDataIdentifyBuilder() CALDataIdentifyBuilder {
	return &_CALDataIdentifyBuilder{_CALDataIdentify: new(_CALDataIdentify)}
}

type _CALDataIdentifyBuilder struct {
	*_CALDataIdentify

	parentBuilder *_CALDataBuilder

	err *utils.MultiError
}

var _ (CALDataIdentifyBuilder) = (*_CALDataIdentifyBuilder)(nil)

func (b *_CALDataIdentifyBuilder) setParent(contract CALDataContract) {
	b.CALDataContract = contract
	contract.(*_CALData)._SubType = b._CALDataIdentify
}

func (b *_CALDataIdentifyBuilder) WithMandatoryFields(attribute Attribute) CALDataIdentifyBuilder {
	return b.WithAttribute(attribute)
}

func (b *_CALDataIdentifyBuilder) WithAttribute(attribute Attribute) CALDataIdentifyBuilder {
	b.Attribute = attribute
	return b
}

func (b *_CALDataIdentifyBuilder) Build() (CALDataIdentify, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._CALDataIdentify.deepCopy(), nil
}

func (b *_CALDataIdentifyBuilder) MustBuild() CALDataIdentify {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CALDataIdentifyBuilder) Done() CALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCALDataBuilder().(*_CALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_CALDataIdentifyBuilder) buildForCALData() (CALData, error) {
	return b.Build()
}

func (b *_CALDataIdentifyBuilder) DeepCopy() any {
	_copy := b.CreateCALDataIdentifyBuilder().(*_CALDataIdentifyBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateCALDataIdentifyBuilder creates a CALDataIdentifyBuilder
func (b *_CALDataIdentify) CreateCALDataIdentifyBuilder() CALDataIdentifyBuilder {
	if b == nil {
		return NewCALDataIdentifyBuilder()
	}
	return &_CALDataIdentifyBuilder{_CALDataIdentify: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CALDataIdentify) GetParent() CALDataContract {
	return m.CALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CALDataIdentify) GetAttribute() Attribute {
	return m.Attribute
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCALDataIdentify(structType any) CALDataIdentify {
	if casted, ok := structType.(CALDataIdentify); ok {
		return casted
	}
	if casted, ok := structType.(*CALDataIdentify); ok {
		return *casted
	}
	return nil
}

func (m *_CALDataIdentify) GetTypeName() string {
	return "CALDataIdentify"
}

func (m *_CALDataIdentify) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CALDataContract.(*_CALData).getLengthInBits(ctx))

	// Simple field (attribute)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CALDataIdentify) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CALDataIdentify) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CALData, requestContext RequestContext) (__cALDataIdentify CALDataIdentify, err error) {
	m.CALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CALDataIdentify"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CALDataIdentify")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	attribute, err := ReadEnumField[Attribute](ctx, "attribute", "Attribute", ReadEnum(AttributeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attribute' field"))
	}
	m.Attribute = attribute

	if closeErr := readBuffer.CloseContext("CALDataIdentify"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CALDataIdentify")
	}

	return m, nil
}

func (m *_CALDataIdentify) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CALDataIdentify) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CALDataIdentify"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CALDataIdentify")
		}

		if err := WriteSimpleEnumField[Attribute](ctx, "attribute", "Attribute", m.GetAttribute(), WriteEnum[Attribute, uint8](Attribute.GetValue, Attribute.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'attribute' field")
		}

		if popErr := writeBuffer.PopContext("CALDataIdentify"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CALDataIdentify")
		}
		return nil
	}
	return m.CALDataContract.(*_CALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CALDataIdentify) IsCALDataIdentify() {}

func (m *_CALDataIdentify) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CALDataIdentify) deepCopy() *_CALDataIdentify {
	if m == nil {
		return nil
	}
	_CALDataIdentifyCopy := &_CALDataIdentify{
		m.CALDataContract.(*_CALData).deepCopy(),
		m.Attribute,
	}
	_CALDataIdentifyCopy.CALDataContract.(*_CALData)._SubType = m
	return _CALDataIdentifyCopy
}

func (m *_CALDataIdentify) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
