/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AirConditioningDataHvacScheduleEntry is the corresponding interface of AirConditioningDataHvacScheduleEntry
type AirConditioningDataHvacScheduleEntry interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AirConditioningData
	// GetZoneGroup returns ZoneGroup (property field)
	GetZoneGroup() byte
	// GetZoneList returns ZoneList (property field)
	GetZoneList() HVACZoneList
	// GetEntry returns Entry (property field)
	GetEntry() uint8
	// GetFormat returns Format (property field)
	GetFormat() byte
	// GetHvacModeAndFlags returns HvacModeAndFlags (property field)
	GetHvacModeAndFlags() HVACModeAndFlags
	// GetStartTime returns StartTime (property field)
	GetStartTime() HVACStartTime
	// GetLevel returns Level (property field)
	GetLevel() HVACTemperature
	// GetRawLevel returns RawLevel (property field)
	GetRawLevel() HVACRawLevels
	// IsAirConditioningDataHvacScheduleEntry is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAirConditioningDataHvacScheduleEntry()
	// CreateBuilder creates a AirConditioningDataHvacScheduleEntryBuilder
	CreateAirConditioningDataHvacScheduleEntryBuilder() AirConditioningDataHvacScheduleEntryBuilder
}

// _AirConditioningDataHvacScheduleEntry is the data-structure of this message
type _AirConditioningDataHvacScheduleEntry struct {
	AirConditioningDataContract
	ZoneGroup        byte
	ZoneList         HVACZoneList
	Entry            uint8
	Format           byte
	HvacModeAndFlags HVACModeAndFlags
	StartTime        HVACStartTime
	Level            HVACTemperature
	RawLevel         HVACRawLevels
}

var _ AirConditioningDataHvacScheduleEntry = (*_AirConditioningDataHvacScheduleEntry)(nil)
var _ AirConditioningDataRequirements = (*_AirConditioningDataHvacScheduleEntry)(nil)

// NewAirConditioningDataHvacScheduleEntry factory function for _AirConditioningDataHvacScheduleEntry
func NewAirConditioningDataHvacScheduleEntry(commandTypeContainer AirConditioningCommandTypeContainer, zoneGroup byte, zoneList HVACZoneList, entry uint8, format byte, hvacModeAndFlags HVACModeAndFlags, startTime HVACStartTime, level HVACTemperature, rawLevel HVACRawLevels) *_AirConditioningDataHvacScheduleEntry {
	if zoneList == nil {
		panic("zoneList of type HVACZoneList for AirConditioningDataHvacScheduleEntry must not be nil")
	}
	if hvacModeAndFlags == nil {
		panic("hvacModeAndFlags of type HVACModeAndFlags for AirConditioningDataHvacScheduleEntry must not be nil")
	}
	if startTime == nil {
		panic("startTime of type HVACStartTime for AirConditioningDataHvacScheduleEntry must not be nil")
	}
	_result := &_AirConditioningDataHvacScheduleEntry{
		AirConditioningDataContract: NewAirConditioningData(commandTypeContainer),
		ZoneGroup:                   zoneGroup,
		ZoneList:                    zoneList,
		Entry:                       entry,
		Format:                      format,
		HvacModeAndFlags:            hvacModeAndFlags,
		StartTime:                   startTime,
		Level:                       level,
		RawLevel:                    rawLevel,
	}
	_result.AirConditioningDataContract.(*_AirConditioningData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AirConditioningDataHvacScheduleEntryBuilder is a builder for AirConditioningDataHvacScheduleEntry
type AirConditioningDataHvacScheduleEntryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneGroup byte, zoneList HVACZoneList, entry uint8, format byte, hvacModeAndFlags HVACModeAndFlags, startTime HVACStartTime) AirConditioningDataHvacScheduleEntryBuilder
	// WithZoneGroup adds ZoneGroup (property field)
	WithZoneGroup(byte) AirConditioningDataHvacScheduleEntryBuilder
	// WithZoneList adds ZoneList (property field)
	WithZoneList(HVACZoneList) AirConditioningDataHvacScheduleEntryBuilder
	// WithZoneListBuilder adds ZoneList (property field) which is build by the builder
	WithZoneListBuilder(func(HVACZoneListBuilder) HVACZoneListBuilder) AirConditioningDataHvacScheduleEntryBuilder
	// WithEntry adds Entry (property field)
	WithEntry(uint8) AirConditioningDataHvacScheduleEntryBuilder
	// WithFormat adds Format (property field)
	WithFormat(byte) AirConditioningDataHvacScheduleEntryBuilder
	// WithHvacModeAndFlags adds HvacModeAndFlags (property field)
	WithHvacModeAndFlags(HVACModeAndFlags) AirConditioningDataHvacScheduleEntryBuilder
	// WithHvacModeAndFlagsBuilder adds HvacModeAndFlags (property field) which is build by the builder
	WithHvacModeAndFlagsBuilder(func(HVACModeAndFlagsBuilder) HVACModeAndFlagsBuilder) AirConditioningDataHvacScheduleEntryBuilder
	// WithStartTime adds StartTime (property field)
	WithStartTime(HVACStartTime) AirConditioningDataHvacScheduleEntryBuilder
	// WithStartTimeBuilder adds StartTime (property field) which is build by the builder
	WithStartTimeBuilder(func(HVACStartTimeBuilder) HVACStartTimeBuilder) AirConditioningDataHvacScheduleEntryBuilder
	// WithLevel adds Level (property field)
	WithOptionalLevel(HVACTemperature) AirConditioningDataHvacScheduleEntryBuilder
	// WithOptionalLevelBuilder adds Level (property field) which is build by the builder
	WithOptionalLevelBuilder(func(HVACTemperatureBuilder) HVACTemperatureBuilder) AirConditioningDataHvacScheduleEntryBuilder
	// WithRawLevel adds RawLevel (property field)
	WithOptionalRawLevel(HVACRawLevels) AirConditioningDataHvacScheduleEntryBuilder
	// WithOptionalRawLevelBuilder adds RawLevel (property field) which is build by the builder
	WithOptionalRawLevelBuilder(func(HVACRawLevelsBuilder) HVACRawLevelsBuilder) AirConditioningDataHvacScheduleEntryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AirConditioningDataBuilder
	// Build builds the AirConditioningDataHvacScheduleEntry or returns an error if something is wrong
	Build() (AirConditioningDataHvacScheduleEntry, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AirConditioningDataHvacScheduleEntry
}

// NewAirConditioningDataHvacScheduleEntryBuilder() creates a AirConditioningDataHvacScheduleEntryBuilder
func NewAirConditioningDataHvacScheduleEntryBuilder() AirConditioningDataHvacScheduleEntryBuilder {
	return &_AirConditioningDataHvacScheduleEntryBuilder{_AirConditioningDataHvacScheduleEntry: new(_AirConditioningDataHvacScheduleEntry)}
}

type _AirConditioningDataHvacScheduleEntryBuilder struct {
	*_AirConditioningDataHvacScheduleEntry

	parentBuilder *_AirConditioningDataBuilder

	err *utils.MultiError
}

var _ (AirConditioningDataHvacScheduleEntryBuilder) = (*_AirConditioningDataHvacScheduleEntryBuilder)(nil)

func (b *_AirConditioningDataHvacScheduleEntryBuilder) setParent(contract AirConditioningDataContract) {
	b.AirConditioningDataContract = contract
	contract.(*_AirConditioningData)._SubType = b._AirConditioningDataHvacScheduleEntry
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithMandatoryFields(zoneGroup byte, zoneList HVACZoneList, entry uint8, format byte, hvacModeAndFlags HVACModeAndFlags, startTime HVACStartTime) AirConditioningDataHvacScheduleEntryBuilder {
	return b.WithZoneGroup(zoneGroup).WithZoneList(zoneList).WithEntry(entry).WithFormat(format).WithHvacModeAndFlags(hvacModeAndFlags).WithStartTime(startTime)
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithZoneGroup(zoneGroup byte) AirConditioningDataHvacScheduleEntryBuilder {
	b.ZoneGroup = zoneGroup
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithZoneList(zoneList HVACZoneList) AirConditioningDataHvacScheduleEntryBuilder {
	b.ZoneList = zoneList
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithZoneListBuilder(builderSupplier func(HVACZoneListBuilder) HVACZoneListBuilder) AirConditioningDataHvacScheduleEntryBuilder {
	builder := builderSupplier(b.ZoneList.CreateHVACZoneListBuilder())
	var err error
	b.ZoneList, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACZoneListBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithEntry(entry uint8) AirConditioningDataHvacScheduleEntryBuilder {
	b.Entry = entry
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithFormat(format byte) AirConditioningDataHvacScheduleEntryBuilder {
	b.Format = format
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithHvacModeAndFlags(hvacModeAndFlags HVACModeAndFlags) AirConditioningDataHvacScheduleEntryBuilder {
	b.HvacModeAndFlags = hvacModeAndFlags
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithHvacModeAndFlagsBuilder(builderSupplier func(HVACModeAndFlagsBuilder) HVACModeAndFlagsBuilder) AirConditioningDataHvacScheduleEntryBuilder {
	builder := builderSupplier(b.HvacModeAndFlags.CreateHVACModeAndFlagsBuilder())
	var err error
	b.HvacModeAndFlags, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACModeAndFlagsBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithStartTime(startTime HVACStartTime) AirConditioningDataHvacScheduleEntryBuilder {
	b.StartTime = startTime
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithStartTimeBuilder(builderSupplier func(HVACStartTimeBuilder) HVACStartTimeBuilder) AirConditioningDataHvacScheduleEntryBuilder {
	builder := builderSupplier(b.StartTime.CreateHVACStartTimeBuilder())
	var err error
	b.StartTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACStartTimeBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithOptionalLevel(level HVACTemperature) AirConditioningDataHvacScheduleEntryBuilder {
	b.Level = level
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithOptionalLevelBuilder(builderSupplier func(HVACTemperatureBuilder) HVACTemperatureBuilder) AirConditioningDataHvacScheduleEntryBuilder {
	builder := builderSupplier(b.Level.CreateHVACTemperatureBuilder())
	var err error
	b.Level, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACTemperatureBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithOptionalRawLevel(rawLevel HVACRawLevels) AirConditioningDataHvacScheduleEntryBuilder {
	b.RawLevel = rawLevel
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) WithOptionalRawLevelBuilder(builderSupplier func(HVACRawLevelsBuilder) HVACRawLevelsBuilder) AirConditioningDataHvacScheduleEntryBuilder {
	builder := builderSupplier(b.RawLevel.CreateHVACRawLevelsBuilder())
	var err error
	b.RawLevel, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACRawLevelsBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) Build() (AirConditioningDataHvacScheduleEntry, error) {
	if b.ZoneList == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'zoneList' not set"))
	}
	if b.HvacModeAndFlags == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'hvacModeAndFlags' not set"))
	}
	if b.StartTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'startTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AirConditioningDataHvacScheduleEntry.deepCopy(), nil
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) MustBuild() AirConditioningDataHvacScheduleEntry {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) Done() AirConditioningDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAirConditioningDataBuilder().(*_AirConditioningDataBuilder)
	}
	return b.parentBuilder
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) buildForAirConditioningData() (AirConditioningData, error) {
	return b.Build()
}

func (b *_AirConditioningDataHvacScheduleEntryBuilder) DeepCopy() any {
	_copy := b.CreateAirConditioningDataHvacScheduleEntryBuilder().(*_AirConditioningDataHvacScheduleEntryBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAirConditioningDataHvacScheduleEntryBuilder creates a AirConditioningDataHvacScheduleEntryBuilder
func (b *_AirConditioningDataHvacScheduleEntry) CreateAirConditioningDataHvacScheduleEntryBuilder() AirConditioningDataHvacScheduleEntryBuilder {
	if b == nil {
		return NewAirConditioningDataHvacScheduleEntryBuilder()
	}
	return &_AirConditioningDataHvacScheduleEntryBuilder{_AirConditioningDataHvacScheduleEntry: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AirConditioningDataHvacScheduleEntry) GetParent() AirConditioningDataContract {
	return m.AirConditioningDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AirConditioningDataHvacScheduleEntry) GetZoneGroup() byte {
	return m.ZoneGroup
}

func (m *_AirConditioningDataHvacScheduleEntry) GetZoneList() HVACZoneList {
	return m.ZoneList
}

func (m *_AirConditioningDataHvacScheduleEntry) GetEntry() uint8 {
	return m.Entry
}

func (m *_AirConditioningDataHvacScheduleEntry) GetFormat() byte {
	return m.Format
}

func (m *_AirConditioningDataHvacScheduleEntry) GetHvacModeAndFlags() HVACModeAndFlags {
	return m.HvacModeAndFlags
}

func (m *_AirConditioningDataHvacScheduleEntry) GetStartTime() HVACStartTime {
	return m.StartTime
}

func (m *_AirConditioningDataHvacScheduleEntry) GetLevel() HVACTemperature {
	return m.Level
}

func (m *_AirConditioningDataHvacScheduleEntry) GetRawLevel() HVACRawLevels {
	return m.RawLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAirConditioningDataHvacScheduleEntry(structType any) AirConditioningDataHvacScheduleEntry {
	if casted, ok := structType.(AirConditioningDataHvacScheduleEntry); ok {
		return casted
	}
	if casted, ok := structType.(*AirConditioningDataHvacScheduleEntry); ok {
		return *casted
	}
	return nil
}

func (m *_AirConditioningDataHvacScheduleEntry) GetTypeName() string {
	return "AirConditioningDataHvacScheduleEntry"
}

func (m *_AirConditioningDataHvacScheduleEntry) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AirConditioningDataContract.(*_AirConditioningData).getLengthInBits(ctx))

	// Simple field (zoneGroup)
	lengthInBits += 8

	// Simple field (zoneList)
	lengthInBits += m.ZoneList.GetLengthInBits(ctx)

	// Simple field (entry)
	lengthInBits += 8

	// Simple field (format)
	lengthInBits += 8

	// Simple field (hvacModeAndFlags)
	lengthInBits += m.HvacModeAndFlags.GetLengthInBits(ctx)

	// Simple field (startTime)
	lengthInBits += m.StartTime.GetLengthInBits(ctx)

	// Optional Field (level)
	if m.Level != nil {
		lengthInBits += m.Level.GetLengthInBits(ctx)
	}

	// Optional Field (rawLevel)
	if m.RawLevel != nil {
		lengthInBits += m.RawLevel.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_AirConditioningDataHvacScheduleEntry) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AirConditioningDataHvacScheduleEntry) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AirConditioningData) (__airConditioningDataHvacScheduleEntry AirConditioningDataHvacScheduleEntry, err error) {
	m.AirConditioningDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AirConditioningDataHvacScheduleEntry"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AirConditioningDataHvacScheduleEntry")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneGroup, err := ReadSimpleField(ctx, "zoneGroup", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneGroup' field"))
	}
	m.ZoneGroup = zoneGroup

	zoneList, err := ReadSimpleField[HVACZoneList](ctx, "zoneList", ReadComplex[HVACZoneList](HVACZoneListParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneList' field"))
	}
	m.ZoneList = zoneList

	entry, err := ReadSimpleField(ctx, "entry", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'entry' field"))
	}
	m.Entry = entry

	format, err := ReadSimpleField(ctx, "format", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'format' field"))
	}
	m.Format = format

	hvacModeAndFlags, err := ReadSimpleField[HVACModeAndFlags](ctx, "hvacModeAndFlags", ReadComplex[HVACModeAndFlags](HVACModeAndFlagsParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'hvacModeAndFlags' field"))
	}
	m.HvacModeAndFlags = hvacModeAndFlags

	startTime, err := ReadSimpleField[HVACStartTime](ctx, "startTime", ReadComplex[HVACStartTime](HVACStartTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'startTime' field"))
	}
	m.StartTime = startTime

	var level HVACTemperature
	_level, err := ReadOptionalField[HVACTemperature](ctx, "level", ReadComplex[HVACTemperature](HVACTemperatureParseWithBuffer, readBuffer), hvacModeAndFlags.GetIsLevelTemperature())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'level' field"))
	}
	if _level != nil {
		level = *_level
		m.Level = level
	}

	var rawLevel HVACRawLevels
	_rawLevel, err := ReadOptionalField[HVACRawLevels](ctx, "rawLevel", ReadComplex[HVACRawLevels](HVACRawLevelsParseWithBuffer, readBuffer), hvacModeAndFlags.GetIsLevelRaw())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'rawLevel' field"))
	}
	if _rawLevel != nil {
		rawLevel = *_rawLevel
		m.RawLevel = rawLevel
	}

	if closeErr := readBuffer.CloseContext("AirConditioningDataHvacScheduleEntry"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AirConditioningDataHvacScheduleEntry")
	}

	return m, nil
}

func (m *_AirConditioningDataHvacScheduleEntry) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AirConditioningDataHvacScheduleEntry) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AirConditioningDataHvacScheduleEntry"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AirConditioningDataHvacScheduleEntry")
		}

		if err := WriteSimpleField[byte](ctx, "zoneGroup", m.GetZoneGroup(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneGroup' field")
		}

		if err := WriteSimpleField[HVACZoneList](ctx, "zoneList", m.GetZoneList(), WriteComplex[HVACZoneList](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneList' field")
		}

		if err := WriteSimpleField[uint8](ctx, "entry", m.GetEntry(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'entry' field")
		}

		if err := WriteSimpleField[byte](ctx, "format", m.GetFormat(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'format' field")
		}

		if err := WriteSimpleField[HVACModeAndFlags](ctx, "hvacModeAndFlags", m.GetHvacModeAndFlags(), WriteComplex[HVACModeAndFlags](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'hvacModeAndFlags' field")
		}

		if err := WriteSimpleField[HVACStartTime](ctx, "startTime", m.GetStartTime(), WriteComplex[HVACStartTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'startTime' field")
		}

		if err := WriteOptionalField[HVACTemperature](ctx, "level", GetRef(m.GetLevel()), WriteComplex[HVACTemperature](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'level' field")
		}

		if err := WriteOptionalField[HVACRawLevels](ctx, "rawLevel", GetRef(m.GetRawLevel()), WriteComplex[HVACRawLevels](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'rawLevel' field")
		}

		if popErr := writeBuffer.PopContext("AirConditioningDataHvacScheduleEntry"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AirConditioningDataHvacScheduleEntry")
		}
		return nil
	}
	return m.AirConditioningDataContract.(*_AirConditioningData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AirConditioningDataHvacScheduleEntry) IsAirConditioningDataHvacScheduleEntry() {}

func (m *_AirConditioningDataHvacScheduleEntry) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AirConditioningDataHvacScheduleEntry) deepCopy() *_AirConditioningDataHvacScheduleEntry {
	if m == nil {
		return nil
	}
	_AirConditioningDataHvacScheduleEntryCopy := &_AirConditioningDataHvacScheduleEntry{
		m.AirConditioningDataContract.(*_AirConditioningData).deepCopy(),
		m.ZoneGroup,
		utils.DeepCopy[HVACZoneList](m.ZoneList),
		m.Entry,
		m.Format,
		utils.DeepCopy[HVACModeAndFlags](m.HvacModeAndFlags),
		utils.DeepCopy[HVACStartTime](m.StartTime),
		utils.DeepCopy[HVACTemperature](m.Level),
		utils.DeepCopy[HVACRawLevels](m.RawLevel),
	}
	_AirConditioningDataHvacScheduleEntryCopy.AirConditioningDataContract.(*_AirConditioningData)._SubType = m
	return _AirConditioningDataHvacScheduleEntryCopy
}

func (m *_AirConditioningDataHvacScheduleEntry) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
