/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMNetworkNumberIs is the corresponding interface of NLMNetworkNumberIs
type NLMNetworkNumberIs interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetNetworkNumber returns NetworkNumber (property field)
	GetNetworkNumber() uint16
	// GetNetworkNumberConfigured returns NetworkNumberConfigured (property field)
	GetNetworkNumberConfigured() bool
	// IsNLMNetworkNumberIs is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMNetworkNumberIs()
	// CreateBuilder creates a NLMNetworkNumberIsBuilder
	CreateNLMNetworkNumberIsBuilder() NLMNetworkNumberIsBuilder
}

// _NLMNetworkNumberIs is the data-structure of this message
type _NLMNetworkNumberIs struct {
	NLMContract
	NetworkNumber           uint16
	NetworkNumberConfigured bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ NLMNetworkNumberIs = (*_NLMNetworkNumberIs)(nil)
var _ NLMRequirements = (*_NLMNetworkNumberIs)(nil)

// NewNLMNetworkNumberIs factory function for _NLMNetworkNumberIs
func NewNLMNetworkNumberIs(networkNumber uint16, networkNumberConfigured bool, apduLength uint16) *_NLMNetworkNumberIs {
	_result := &_NLMNetworkNumberIs{
		NLMContract:             NewNLM(apduLength),
		NetworkNumber:           networkNumber,
		NetworkNumberConfigured: networkNumberConfigured,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMNetworkNumberIsBuilder is a builder for NLMNetworkNumberIs
type NLMNetworkNumberIsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(networkNumber uint16, networkNumberConfigured bool) NLMNetworkNumberIsBuilder
	// WithNetworkNumber adds NetworkNumber (property field)
	WithNetworkNumber(uint16) NLMNetworkNumberIsBuilder
	// WithNetworkNumberConfigured adds NetworkNumberConfigured (property field)
	WithNetworkNumberConfigured(bool) NLMNetworkNumberIsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMNetworkNumberIs or returns an error if something is wrong
	Build() (NLMNetworkNumberIs, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMNetworkNumberIs
}

// NewNLMNetworkNumberIsBuilder() creates a NLMNetworkNumberIsBuilder
func NewNLMNetworkNumberIsBuilder() NLMNetworkNumberIsBuilder {
	return &_NLMNetworkNumberIsBuilder{_NLMNetworkNumberIs: new(_NLMNetworkNumberIs)}
}

type _NLMNetworkNumberIsBuilder struct {
	*_NLMNetworkNumberIs

	parentBuilder *_NLMBuilder

	err *utils.MultiError
}

var _ (NLMNetworkNumberIsBuilder) = (*_NLMNetworkNumberIsBuilder)(nil)

func (b *_NLMNetworkNumberIsBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMNetworkNumberIs
}

func (b *_NLMNetworkNumberIsBuilder) WithMandatoryFields(networkNumber uint16, networkNumberConfigured bool) NLMNetworkNumberIsBuilder {
	return b.WithNetworkNumber(networkNumber).WithNetworkNumberConfigured(networkNumberConfigured)
}

func (b *_NLMNetworkNumberIsBuilder) WithNetworkNumber(networkNumber uint16) NLMNetworkNumberIsBuilder {
	b.NetworkNumber = networkNumber
	return b
}

func (b *_NLMNetworkNumberIsBuilder) WithNetworkNumberConfigured(networkNumberConfigured bool) NLMNetworkNumberIsBuilder {
	b.NetworkNumberConfigured = networkNumberConfigured
	return b
}

func (b *_NLMNetworkNumberIsBuilder) Build() (NLMNetworkNumberIs, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NLMNetworkNumberIs.deepCopy(), nil
}

func (b *_NLMNetworkNumberIsBuilder) MustBuild() NLMNetworkNumberIs {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMNetworkNumberIsBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMNetworkNumberIsBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMNetworkNumberIsBuilder) DeepCopy() any {
	_copy := b.CreateNLMNetworkNumberIsBuilder().(*_NLMNetworkNumberIsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNLMNetworkNumberIsBuilder creates a NLMNetworkNumberIsBuilder
func (b *_NLMNetworkNumberIs) CreateNLMNetworkNumberIsBuilder() NLMNetworkNumberIsBuilder {
	if b == nil {
		return NewNLMNetworkNumberIsBuilder()
	}
	return &_NLMNetworkNumberIsBuilder{_NLMNetworkNumberIs: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMNetworkNumberIs) GetMessageType() uint8 {
	return 0x13
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMNetworkNumberIs) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMNetworkNumberIs) GetNetworkNumber() uint16 {
	return m.NetworkNumber
}

func (m *_NLMNetworkNumberIs) GetNetworkNumberConfigured() bool {
	return m.NetworkNumberConfigured
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMNetworkNumberIs(structType any) NLMNetworkNumberIs {
	if casted, ok := structType.(NLMNetworkNumberIs); ok {
		return casted
	}
	if casted, ok := structType.(*NLMNetworkNumberIs); ok {
		return *casted
	}
	return nil
}

func (m *_NLMNetworkNumberIs) GetTypeName() string {
	return "NLMNetworkNumberIs"
}

func (m *_NLMNetworkNumberIs) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (networkNumber)
	lengthInBits += 16

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (networkNumberConfigured)
	lengthInBits += 1

	return lengthInBits
}

func (m *_NLMNetworkNumberIs) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMNetworkNumberIs) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMNetworkNumberIs NLMNetworkNumberIs, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMNetworkNumberIs"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMNetworkNumberIs")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	networkNumber, err := ReadSimpleField(ctx, "networkNumber", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkNumber' field"))
	}
	m.NetworkNumber = networkNumber

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	networkNumberConfigured, err := ReadSimpleField(ctx, "networkNumberConfigured", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkNumberConfigured' field"))
	}
	m.NetworkNumberConfigured = networkNumberConfigured

	if closeErr := readBuffer.CloseContext("NLMNetworkNumberIs"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMNetworkNumberIs")
	}

	return m, nil
}

func (m *_NLMNetworkNumberIs) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMNetworkNumberIs) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMNetworkNumberIs"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMNetworkNumberIs")
		}

		if err := WriteSimpleField[uint16](ctx, "networkNumber", m.GetNetworkNumber(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'networkNumber' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "networkNumberConfigured", m.GetNetworkNumberConfigured(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'networkNumberConfigured' field")
		}

		if popErr := writeBuffer.PopContext("NLMNetworkNumberIs"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMNetworkNumberIs")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMNetworkNumberIs) IsNLMNetworkNumberIs() {}

func (m *_NLMNetworkNumberIs) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMNetworkNumberIs) deepCopy() *_NLMNetworkNumberIs {
	if m == nil {
		return nil
	}
	_NLMNetworkNumberIsCopy := &_NLMNetworkNumberIs{
		m.NLMContract.(*_NLM).deepCopy(),
		m.NetworkNumber,
		m.NetworkNumberConfigured,
		m.reservedField0,
	}
	_NLMNetworkNumberIsCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMNetworkNumberIsCopy
}

func (m *_NLMNetworkNumberIs) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
