/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Error is the corresponding interface of Error
type Error interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetErrorClass returns ErrorClass (property field)
	GetErrorClass() ErrorClassTagged
	// GetErrorCode returns ErrorCode (property field)
	GetErrorCode() ErrorCodeTagged
	// IsError is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsError()
	// CreateBuilder creates a ErrorBuilder
	CreateErrorBuilder() ErrorBuilder
}

// _Error is the data-structure of this message
type _Error struct {
	ErrorClass ErrorClassTagged
	ErrorCode  ErrorCodeTagged
}

var _ Error = (*_Error)(nil)

// NewError factory function for _Error
func NewError(errorClass ErrorClassTagged, errorCode ErrorCodeTagged) *_Error {
	if errorClass == nil {
		panic("errorClass of type ErrorClassTagged for Error must not be nil")
	}
	if errorCode == nil {
		panic("errorCode of type ErrorCodeTagged for Error must not be nil")
	}
	return &_Error{ErrorClass: errorClass, ErrorCode: errorCode}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ErrorBuilder is a builder for Error
type ErrorBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(errorClass ErrorClassTagged, errorCode ErrorCodeTagged) ErrorBuilder
	// WithErrorClass adds ErrorClass (property field)
	WithErrorClass(ErrorClassTagged) ErrorBuilder
	// WithErrorClassBuilder adds ErrorClass (property field) which is build by the builder
	WithErrorClassBuilder(func(ErrorClassTaggedBuilder) ErrorClassTaggedBuilder) ErrorBuilder
	// WithErrorCode adds ErrorCode (property field)
	WithErrorCode(ErrorCodeTagged) ErrorBuilder
	// WithErrorCodeBuilder adds ErrorCode (property field) which is build by the builder
	WithErrorCodeBuilder(func(ErrorCodeTaggedBuilder) ErrorCodeTaggedBuilder) ErrorBuilder
	// Build builds the Error or returns an error if something is wrong
	Build() (Error, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Error
}

// NewErrorBuilder() creates a ErrorBuilder
func NewErrorBuilder() ErrorBuilder {
	return &_ErrorBuilder{_Error: new(_Error)}
}

type _ErrorBuilder struct {
	*_Error

	err *utils.MultiError
}

var _ (ErrorBuilder) = (*_ErrorBuilder)(nil)

func (b *_ErrorBuilder) WithMandatoryFields(errorClass ErrorClassTagged, errorCode ErrorCodeTagged) ErrorBuilder {
	return b.WithErrorClass(errorClass).WithErrorCode(errorCode)
}

func (b *_ErrorBuilder) WithErrorClass(errorClass ErrorClassTagged) ErrorBuilder {
	b.ErrorClass = errorClass
	return b
}

func (b *_ErrorBuilder) WithErrorClassBuilder(builderSupplier func(ErrorClassTaggedBuilder) ErrorClassTaggedBuilder) ErrorBuilder {
	builder := builderSupplier(b.ErrorClass.CreateErrorClassTaggedBuilder())
	var err error
	b.ErrorClass, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ErrorClassTaggedBuilder failed"))
	}
	return b
}

func (b *_ErrorBuilder) WithErrorCode(errorCode ErrorCodeTagged) ErrorBuilder {
	b.ErrorCode = errorCode
	return b
}

func (b *_ErrorBuilder) WithErrorCodeBuilder(builderSupplier func(ErrorCodeTaggedBuilder) ErrorCodeTaggedBuilder) ErrorBuilder {
	builder := builderSupplier(b.ErrorCode.CreateErrorCodeTaggedBuilder())
	var err error
	b.ErrorCode, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ErrorCodeTaggedBuilder failed"))
	}
	return b
}

func (b *_ErrorBuilder) Build() (Error, error) {
	if b.ErrorClass == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'errorClass' not set"))
	}
	if b.ErrorCode == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'errorCode' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._Error.deepCopy(), nil
}

func (b *_ErrorBuilder) MustBuild() Error {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ErrorBuilder) DeepCopy() any {
	_copy := b.CreateErrorBuilder().(*_ErrorBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateErrorBuilder creates a ErrorBuilder
func (b *_Error) CreateErrorBuilder() ErrorBuilder {
	if b == nil {
		return NewErrorBuilder()
	}
	return &_ErrorBuilder{_Error: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Error) GetErrorClass() ErrorClassTagged {
	return m.ErrorClass
}

func (m *_Error) GetErrorCode() ErrorCodeTagged {
	return m.ErrorCode
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastError(structType any) Error {
	if casted, ok := structType.(Error); ok {
		return casted
	}
	if casted, ok := structType.(*Error); ok {
		return *casted
	}
	return nil
}

func (m *_Error) GetTypeName() string {
	return "Error"
}

func (m *_Error) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (errorClass)
	lengthInBits += m.ErrorClass.GetLengthInBits(ctx)

	// Simple field (errorCode)
	lengthInBits += m.ErrorCode.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_Error) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ErrorParse(ctx context.Context, theBytes []byte) (Error, error) {
	return ErrorParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ErrorParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Error, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Error, error) {
		return ErrorParseWithBuffer(ctx, readBuffer)
	}
}

func ErrorParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Error, error) {
	v, err := (&_Error{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Error) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__error Error, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Error"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Error")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	errorClass, err := ReadSimpleField[ErrorClassTagged](ctx, "errorClass", ReadComplex[ErrorClassTagged](ErrorClassTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorClass' field"))
	}
	m.ErrorClass = errorClass

	errorCode, err := ReadSimpleField[ErrorCodeTagged](ctx, "errorCode", ReadComplex[ErrorCodeTagged](ErrorCodeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorCode' field"))
	}
	m.ErrorCode = errorCode

	if closeErr := readBuffer.CloseContext("Error"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Error")
	}

	return m, nil
}

func (m *_Error) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Error) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Error"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Error")
	}

	if err := WriteSimpleField[ErrorClassTagged](ctx, "errorClass", m.GetErrorClass(), WriteComplex[ErrorClassTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'errorClass' field")
	}

	if err := WriteSimpleField[ErrorCodeTagged](ctx, "errorCode", m.GetErrorCode(), WriteComplex[ErrorCodeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'errorCode' field")
	}

	if popErr := writeBuffer.PopContext("Error"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Error")
	}
	return nil
}

func (m *_Error) IsError() {}

func (m *_Error) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Error) deepCopy() *_Error {
	if m == nil {
		return nil
	}
	_ErrorCopy := &_Error{
		utils.DeepCopy[ErrorClassTagged](m.ErrorClass),
		utils.DeepCopy[ErrorCodeTagged](m.ErrorCode),
	}
	return _ErrorCopy
}

func (m *_Error) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
