/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConfirmedEventNotificationRequest is the corresponding interface of ConfirmedEventNotificationRequest
type ConfirmedEventNotificationRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetProcessIdentifier returns ProcessIdentifier (property field)
	GetProcessIdentifier() BACnetContextTagUnsignedInteger
	// GetInitiatingDeviceIdentifier returns InitiatingDeviceIdentifier (property field)
	GetInitiatingDeviceIdentifier() BACnetContextTagObjectIdentifier
	// GetEventObjectIdentifier returns EventObjectIdentifier (property field)
	GetEventObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() BACnetTimeStampEnclosed
	// GetNotificationClass returns NotificationClass (property field)
	GetNotificationClass() BACnetContextTagUnsignedInteger
	// GetPriority returns Priority (property field)
	GetPriority() BACnetContextTagUnsignedInteger
	// GetEventType returns EventType (property field)
	GetEventType() BACnetEventTypeTagged
	// GetMessageText returns MessageText (property field)
	GetMessageText() BACnetContextTagCharacterString
	// GetNotifyType returns NotifyType (property field)
	GetNotifyType() BACnetNotifyTypeTagged
	// GetAckRequired returns AckRequired (property field)
	GetAckRequired() BACnetContextTagBoolean
	// GetFromState returns FromState (property field)
	GetFromState() BACnetEventStateTagged
	// GetToState returns ToState (property field)
	GetToState() BACnetEventStateTagged
	// GetEventValues returns EventValues (property field)
	GetEventValues() BACnetNotificationParameters
	// IsConfirmedEventNotificationRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsConfirmedEventNotificationRequest()
	// CreateBuilder creates a ConfirmedEventNotificationRequestBuilder
	CreateConfirmedEventNotificationRequestBuilder() ConfirmedEventNotificationRequestBuilder
}

// _ConfirmedEventNotificationRequest is the data-structure of this message
type _ConfirmedEventNotificationRequest struct {
	ProcessIdentifier          BACnetContextTagUnsignedInteger
	InitiatingDeviceIdentifier BACnetContextTagObjectIdentifier
	EventObjectIdentifier      BACnetContextTagObjectIdentifier
	Timestamp                  BACnetTimeStampEnclosed
	NotificationClass          BACnetContextTagUnsignedInteger
	Priority                   BACnetContextTagUnsignedInteger
	EventType                  BACnetEventTypeTagged
	MessageText                BACnetContextTagCharacterString
	NotifyType                 BACnetNotifyTypeTagged
	AckRequired                BACnetContextTagBoolean
	FromState                  BACnetEventStateTagged
	ToState                    BACnetEventStateTagged
	EventValues                BACnetNotificationParameters
}

var _ ConfirmedEventNotificationRequest = (*_ConfirmedEventNotificationRequest)(nil)

// NewConfirmedEventNotificationRequest factory function for _ConfirmedEventNotificationRequest
func NewConfirmedEventNotificationRequest(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, messageText BACnetContextTagCharacterString, notifyType BACnetNotifyTypeTagged, ackRequired BACnetContextTagBoolean, fromState BACnetEventStateTagged, toState BACnetEventStateTagged, eventValues BACnetNotificationParameters) *_ConfirmedEventNotificationRequest {
	if processIdentifier == nil {
		panic("processIdentifier of type BACnetContextTagUnsignedInteger for ConfirmedEventNotificationRequest must not be nil")
	}
	if initiatingDeviceIdentifier == nil {
		panic("initiatingDeviceIdentifier of type BACnetContextTagObjectIdentifier for ConfirmedEventNotificationRequest must not be nil")
	}
	if eventObjectIdentifier == nil {
		panic("eventObjectIdentifier of type BACnetContextTagObjectIdentifier for ConfirmedEventNotificationRequest must not be nil")
	}
	if timestamp == nil {
		panic("timestamp of type BACnetTimeStampEnclosed for ConfirmedEventNotificationRequest must not be nil")
	}
	if notificationClass == nil {
		panic("notificationClass of type BACnetContextTagUnsignedInteger for ConfirmedEventNotificationRequest must not be nil")
	}
	if priority == nil {
		panic("priority of type BACnetContextTagUnsignedInteger for ConfirmedEventNotificationRequest must not be nil")
	}
	if eventType == nil {
		panic("eventType of type BACnetEventTypeTagged for ConfirmedEventNotificationRequest must not be nil")
	}
	if notifyType == nil {
		panic("notifyType of type BACnetNotifyTypeTagged for ConfirmedEventNotificationRequest must not be nil")
	}
	if toState == nil {
		panic("toState of type BACnetEventStateTagged for ConfirmedEventNotificationRequest must not be nil")
	}
	return &_ConfirmedEventNotificationRequest{ProcessIdentifier: processIdentifier, InitiatingDeviceIdentifier: initiatingDeviceIdentifier, EventObjectIdentifier: eventObjectIdentifier, Timestamp: timestamp, NotificationClass: notificationClass, Priority: priority, EventType: eventType, MessageText: messageText, NotifyType: notifyType, AckRequired: ackRequired, FromState: fromState, ToState: toState, EventValues: eventValues}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ConfirmedEventNotificationRequestBuilder is a builder for ConfirmedEventNotificationRequest
type ConfirmedEventNotificationRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, notifyType BACnetNotifyTypeTagged, toState BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder
	// WithProcessIdentifier adds ProcessIdentifier (property field)
	WithProcessIdentifier(BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder
	// WithProcessIdentifierBuilder adds ProcessIdentifier (property field) which is build by the builder
	WithProcessIdentifierBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder
	// WithInitiatingDeviceIdentifier adds InitiatingDeviceIdentifier (property field)
	WithInitiatingDeviceIdentifier(BACnetContextTagObjectIdentifier) ConfirmedEventNotificationRequestBuilder
	// WithInitiatingDeviceIdentifierBuilder adds InitiatingDeviceIdentifier (property field) which is build by the builder
	WithInitiatingDeviceIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) ConfirmedEventNotificationRequestBuilder
	// WithEventObjectIdentifier adds EventObjectIdentifier (property field)
	WithEventObjectIdentifier(BACnetContextTagObjectIdentifier) ConfirmedEventNotificationRequestBuilder
	// WithEventObjectIdentifierBuilder adds EventObjectIdentifier (property field) which is build by the builder
	WithEventObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) ConfirmedEventNotificationRequestBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(BACnetTimeStampEnclosed) ConfirmedEventNotificationRequestBuilder
	// WithTimestampBuilder adds Timestamp (property field) which is build by the builder
	WithTimestampBuilder(func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) ConfirmedEventNotificationRequestBuilder
	// WithNotificationClass adds NotificationClass (property field)
	WithNotificationClass(BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder
	// WithNotificationClassBuilder adds NotificationClass (property field) which is build by the builder
	WithNotificationClassBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder
	// WithPriority adds Priority (property field)
	WithPriority(BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder
	// WithPriorityBuilder adds Priority (property field) which is build by the builder
	WithPriorityBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder
	// WithEventType adds EventType (property field)
	WithEventType(BACnetEventTypeTagged) ConfirmedEventNotificationRequestBuilder
	// WithEventTypeBuilder adds EventType (property field) which is build by the builder
	WithEventTypeBuilder(func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) ConfirmedEventNotificationRequestBuilder
	// WithMessageText adds MessageText (property field)
	WithOptionalMessageText(BACnetContextTagCharacterString) ConfirmedEventNotificationRequestBuilder
	// WithOptionalMessageTextBuilder adds MessageText (property field) which is build by the builder
	WithOptionalMessageTextBuilder(func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) ConfirmedEventNotificationRequestBuilder
	// WithNotifyType adds NotifyType (property field)
	WithNotifyType(BACnetNotifyTypeTagged) ConfirmedEventNotificationRequestBuilder
	// WithNotifyTypeBuilder adds NotifyType (property field) which is build by the builder
	WithNotifyTypeBuilder(func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) ConfirmedEventNotificationRequestBuilder
	// WithAckRequired adds AckRequired (property field)
	WithOptionalAckRequired(BACnetContextTagBoolean) ConfirmedEventNotificationRequestBuilder
	// WithOptionalAckRequiredBuilder adds AckRequired (property field) which is build by the builder
	WithOptionalAckRequiredBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) ConfirmedEventNotificationRequestBuilder
	// WithFromState adds FromState (property field)
	WithOptionalFromState(BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder
	// WithOptionalFromStateBuilder adds FromState (property field) which is build by the builder
	WithOptionalFromStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) ConfirmedEventNotificationRequestBuilder
	// WithToState adds ToState (property field)
	WithToState(BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder
	// WithToStateBuilder adds ToState (property field) which is build by the builder
	WithToStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) ConfirmedEventNotificationRequestBuilder
	// WithEventValues adds EventValues (property field)
	WithOptionalEventValues(BACnetNotificationParameters) ConfirmedEventNotificationRequestBuilder
	// WithOptionalEventValuesBuilder adds EventValues (property field) which is build by the builder
	WithOptionalEventValuesBuilder(func(BACnetNotificationParametersBuilder) BACnetNotificationParametersBuilder) ConfirmedEventNotificationRequestBuilder
	// Build builds the ConfirmedEventNotificationRequest or returns an error if something is wrong
	Build() (ConfirmedEventNotificationRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ConfirmedEventNotificationRequest
}

// NewConfirmedEventNotificationRequestBuilder() creates a ConfirmedEventNotificationRequestBuilder
func NewConfirmedEventNotificationRequestBuilder() ConfirmedEventNotificationRequestBuilder {
	return &_ConfirmedEventNotificationRequestBuilder{_ConfirmedEventNotificationRequest: new(_ConfirmedEventNotificationRequest)}
}

type _ConfirmedEventNotificationRequestBuilder struct {
	*_ConfirmedEventNotificationRequest

	err *utils.MultiError
}

var _ (ConfirmedEventNotificationRequestBuilder) = (*_ConfirmedEventNotificationRequestBuilder)(nil)

func (b *_ConfirmedEventNotificationRequestBuilder) WithMandatoryFields(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, notifyType BACnetNotifyTypeTagged, toState BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder {
	return b.WithProcessIdentifier(processIdentifier).WithInitiatingDeviceIdentifier(initiatingDeviceIdentifier).WithEventObjectIdentifier(eventObjectIdentifier).WithTimestamp(timestamp).WithNotificationClass(notificationClass).WithPriority(priority).WithEventType(eventType).WithNotifyType(notifyType).WithToState(toState)
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithProcessIdentifier(processIdentifier BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder {
	b.ProcessIdentifier = processIdentifier
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithProcessIdentifierBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.ProcessIdentifier.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.ProcessIdentifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithInitiatingDeviceIdentifier(initiatingDeviceIdentifier BACnetContextTagObjectIdentifier) ConfirmedEventNotificationRequestBuilder {
	b.InitiatingDeviceIdentifier = initiatingDeviceIdentifier
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithInitiatingDeviceIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.InitiatingDeviceIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.InitiatingDeviceIdentifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithEventObjectIdentifier(eventObjectIdentifier BACnetContextTagObjectIdentifier) ConfirmedEventNotificationRequestBuilder {
	b.EventObjectIdentifier = eventObjectIdentifier
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithEventObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.EventObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.EventObjectIdentifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithTimestamp(timestamp BACnetTimeStampEnclosed) ConfirmedEventNotificationRequestBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithTimestampBuilder(builderSupplier func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.Timestamp.CreateBACnetTimeStampEnclosedBuilder())
	var err error
	b.Timestamp, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTimeStampEnclosedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithNotificationClass(notificationClass BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder {
	b.NotificationClass = notificationClass
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithNotificationClassBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.NotificationClass.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.NotificationClass, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithPriority(priority BACnetContextTagUnsignedInteger) ConfirmedEventNotificationRequestBuilder {
	b.Priority = priority
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithPriorityBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.Priority.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.Priority, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithEventType(eventType BACnetEventTypeTagged) ConfirmedEventNotificationRequestBuilder {
	b.EventType = eventType
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithEventTypeBuilder(builderSupplier func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.EventType.CreateBACnetEventTypeTaggedBuilder())
	var err error
	b.EventType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalMessageText(messageText BACnetContextTagCharacterString) ConfirmedEventNotificationRequestBuilder {
	b.MessageText = messageText
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalMessageTextBuilder(builderSupplier func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.MessageText.CreateBACnetContextTagCharacterStringBuilder())
	var err error
	b.MessageText, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithNotifyType(notifyType BACnetNotifyTypeTagged) ConfirmedEventNotificationRequestBuilder {
	b.NotifyType = notifyType
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithNotifyTypeBuilder(builderSupplier func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.NotifyType.CreateBACnetNotifyTypeTaggedBuilder())
	var err error
	b.NotifyType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetNotifyTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalAckRequired(ackRequired BACnetContextTagBoolean) ConfirmedEventNotificationRequestBuilder {
	b.AckRequired = ackRequired
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalAckRequiredBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.AckRequired.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.AckRequired, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalFromState(fromState BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder {
	b.FromState = fromState
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalFromStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.FromState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.FromState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithToState(toState BACnetEventStateTagged) ConfirmedEventNotificationRequestBuilder {
	b.ToState = toState
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithToStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.ToState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.ToState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalEventValues(eventValues BACnetNotificationParameters) ConfirmedEventNotificationRequestBuilder {
	b.EventValues = eventValues
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) WithOptionalEventValuesBuilder(builderSupplier func(BACnetNotificationParametersBuilder) BACnetNotificationParametersBuilder) ConfirmedEventNotificationRequestBuilder {
	builder := builderSupplier(b.EventValues.CreateBACnetNotificationParametersBuilder())
	var err error
	b.EventValues, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetNotificationParametersBuilder failed"))
	}
	return b
}

func (b *_ConfirmedEventNotificationRequestBuilder) Build() (ConfirmedEventNotificationRequest, error) {
	if b.ProcessIdentifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'processIdentifier' not set"))
	}
	if b.InitiatingDeviceIdentifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'initiatingDeviceIdentifier' not set"))
	}
	if b.EventObjectIdentifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'eventObjectIdentifier' not set"))
	}
	if b.Timestamp == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'timestamp' not set"))
	}
	if b.NotificationClass == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'notificationClass' not set"))
	}
	if b.Priority == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'priority' not set"))
	}
	if b.EventType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'eventType' not set"))
	}
	if b.NotifyType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'notifyType' not set"))
	}
	if b.ToState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'toState' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ConfirmedEventNotificationRequest.deepCopy(), nil
}

func (b *_ConfirmedEventNotificationRequestBuilder) MustBuild() ConfirmedEventNotificationRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ConfirmedEventNotificationRequestBuilder) DeepCopy() any {
	_copy := b.CreateConfirmedEventNotificationRequestBuilder().(*_ConfirmedEventNotificationRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateConfirmedEventNotificationRequestBuilder creates a ConfirmedEventNotificationRequestBuilder
func (b *_ConfirmedEventNotificationRequest) CreateConfirmedEventNotificationRequestBuilder() ConfirmedEventNotificationRequestBuilder {
	if b == nil {
		return NewConfirmedEventNotificationRequestBuilder()
	}
	return &_ConfirmedEventNotificationRequestBuilder{_ConfirmedEventNotificationRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ConfirmedEventNotificationRequest) GetProcessIdentifier() BACnetContextTagUnsignedInteger {
	return m.ProcessIdentifier
}

func (m *_ConfirmedEventNotificationRequest) GetInitiatingDeviceIdentifier() BACnetContextTagObjectIdentifier {
	return m.InitiatingDeviceIdentifier
}

func (m *_ConfirmedEventNotificationRequest) GetEventObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.EventObjectIdentifier
}

func (m *_ConfirmedEventNotificationRequest) GetTimestamp() BACnetTimeStampEnclosed {
	return m.Timestamp
}

func (m *_ConfirmedEventNotificationRequest) GetNotificationClass() BACnetContextTagUnsignedInteger {
	return m.NotificationClass
}

func (m *_ConfirmedEventNotificationRequest) GetPriority() BACnetContextTagUnsignedInteger {
	return m.Priority
}

func (m *_ConfirmedEventNotificationRequest) GetEventType() BACnetEventTypeTagged {
	return m.EventType
}

func (m *_ConfirmedEventNotificationRequest) GetMessageText() BACnetContextTagCharacterString {
	return m.MessageText
}

func (m *_ConfirmedEventNotificationRequest) GetNotifyType() BACnetNotifyTypeTagged {
	return m.NotifyType
}

func (m *_ConfirmedEventNotificationRequest) GetAckRequired() BACnetContextTagBoolean {
	return m.AckRequired
}

func (m *_ConfirmedEventNotificationRequest) GetFromState() BACnetEventStateTagged {
	return m.FromState
}

func (m *_ConfirmedEventNotificationRequest) GetToState() BACnetEventStateTagged {
	return m.ToState
}

func (m *_ConfirmedEventNotificationRequest) GetEventValues() BACnetNotificationParameters {
	return m.EventValues
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastConfirmedEventNotificationRequest(structType any) ConfirmedEventNotificationRequest {
	if casted, ok := structType.(ConfirmedEventNotificationRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ConfirmedEventNotificationRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ConfirmedEventNotificationRequest) GetTypeName() string {
	return "ConfirmedEventNotificationRequest"
}

func (m *_ConfirmedEventNotificationRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (processIdentifier)
	lengthInBits += m.ProcessIdentifier.GetLengthInBits(ctx)

	// Simple field (initiatingDeviceIdentifier)
	lengthInBits += m.InitiatingDeviceIdentifier.GetLengthInBits(ctx)

	// Simple field (eventObjectIdentifier)
	lengthInBits += m.EventObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += m.Timestamp.GetLengthInBits(ctx)

	// Simple field (notificationClass)
	lengthInBits += m.NotificationClass.GetLengthInBits(ctx)

	// Simple field (priority)
	lengthInBits += m.Priority.GetLengthInBits(ctx)

	// Simple field (eventType)
	lengthInBits += m.EventType.GetLengthInBits(ctx)

	// Optional Field (messageText)
	if m.MessageText != nil {
		lengthInBits += m.MessageText.GetLengthInBits(ctx)
	}

	// Simple field (notifyType)
	lengthInBits += m.NotifyType.GetLengthInBits(ctx)

	// Optional Field (ackRequired)
	if m.AckRequired != nil {
		lengthInBits += m.AckRequired.GetLengthInBits(ctx)
	}

	// Optional Field (fromState)
	if m.FromState != nil {
		lengthInBits += m.FromState.GetLengthInBits(ctx)
	}

	// Simple field (toState)
	lengthInBits += m.ToState.GetLengthInBits(ctx)

	// Optional Field (eventValues)
	if m.EventValues != nil {
		lengthInBits += m.EventValues.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_ConfirmedEventNotificationRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ConfirmedEventNotificationRequestParse(ctx context.Context, theBytes []byte) (ConfirmedEventNotificationRequest, error) {
	return ConfirmedEventNotificationRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ConfirmedEventNotificationRequestParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ConfirmedEventNotificationRequest, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ConfirmedEventNotificationRequest, error) {
		return ConfirmedEventNotificationRequestParseWithBuffer(ctx, readBuffer)
	}
}

func ConfirmedEventNotificationRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ConfirmedEventNotificationRequest, error) {
	v, err := (&_ConfirmedEventNotificationRequest{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ConfirmedEventNotificationRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__confirmedEventNotificationRequest ConfirmedEventNotificationRequest, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ConfirmedEventNotificationRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConfirmedEventNotificationRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	processIdentifier, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "processIdentifier", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'processIdentifier' field"))
	}
	m.ProcessIdentifier = processIdentifier

	initiatingDeviceIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "initiatingDeviceIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'initiatingDeviceIdentifier' field"))
	}
	m.InitiatingDeviceIdentifier = initiatingDeviceIdentifier

	eventObjectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "eventObjectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventObjectIdentifier' field"))
	}
	m.EventObjectIdentifier = eventObjectIdentifier

	timestamp, err := ReadSimpleField[BACnetTimeStampEnclosed](ctx, "timestamp", ReadComplex[BACnetTimeStampEnclosed](BACnetTimeStampEnclosedParseWithBufferProducer((uint8)(uint8(3))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	notificationClass, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "notificationClass", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(4)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notificationClass' field"))
	}
	m.NotificationClass = notificationClass

	priority, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "priority", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(5)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	m.Priority = priority

	eventType, err := ReadSimpleField[BACnetEventTypeTagged](ctx, "eventType", ReadComplex[BACnetEventTypeTagged](BACnetEventTypeTaggedParseWithBufferProducer((uint8)(uint8(6)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventType' field"))
	}
	m.EventType = eventType

	var messageText BACnetContextTagCharacterString
	_messageText, err := ReadOptionalField[BACnetContextTagCharacterString](ctx, "messageText", ReadComplex[BACnetContextTagCharacterString](BACnetContextTagParseWithBufferProducer[BACnetContextTagCharacterString]((uint8)(uint8(7)), (BACnetDataType)(BACnetDataType_CHARACTER_STRING)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageText' field"))
	}
	if _messageText != nil {
		messageText = *_messageText
		m.MessageText = messageText
	}

	notifyType, err := ReadSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", ReadComplex[BACnetNotifyTypeTagged](BACnetNotifyTypeTaggedParseWithBufferProducer((uint8)(uint8(8)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notifyType' field"))
	}
	m.NotifyType = notifyType

	var ackRequired BACnetContextTagBoolean
	_ackRequired, err := ReadOptionalField[BACnetContextTagBoolean](ctx, "ackRequired", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(9)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackRequired' field"))
	}
	if _ackRequired != nil {
		ackRequired = *_ackRequired
		m.AckRequired = ackRequired
	}

	var fromState BACnetEventStateTagged
	_fromState, err := ReadOptionalField[BACnetEventStateTagged](ctx, "fromState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(10)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fromState' field"))
	}
	if _fromState != nil {
		fromState = *_fromState
		m.FromState = fromState
	}

	toState, err := ReadSimpleField[BACnetEventStateTagged](ctx, "toState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(11)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'toState' field"))
	}
	m.ToState = toState

	var eventValues BACnetNotificationParameters
	_eventValues, err := ReadOptionalField[BACnetNotificationParameters](ctx, "eventValues", ReadComplex[BACnetNotificationParameters](BACnetNotificationParametersParseWithBufferProducer[BACnetNotificationParameters]((uint8)(uint8(12)), (BACnetObjectType)(eventObjectIdentifier.GetObjectType())), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventValues' field"))
	}
	if _eventValues != nil {
		eventValues = *_eventValues
		m.EventValues = eventValues
	}

	if closeErr := readBuffer.CloseContext("ConfirmedEventNotificationRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConfirmedEventNotificationRequest")
	}

	return m, nil
}

func (m *_ConfirmedEventNotificationRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConfirmedEventNotificationRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ConfirmedEventNotificationRequest"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ConfirmedEventNotificationRequest")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "processIdentifier", m.GetProcessIdentifier(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'processIdentifier' field")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "initiatingDeviceIdentifier", m.GetInitiatingDeviceIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'initiatingDeviceIdentifier' field")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "eventObjectIdentifier", m.GetEventObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventObjectIdentifier' field")
	}

	if err := WriteSimpleField[BACnetTimeStampEnclosed](ctx, "timestamp", m.GetTimestamp(), WriteComplex[BACnetTimeStampEnclosed](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'timestamp' field")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "notificationClass", m.GetNotificationClass(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'notificationClass' field")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "priority", m.GetPriority(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'priority' field")
	}

	if err := WriteSimpleField[BACnetEventTypeTagged](ctx, "eventType", m.GetEventType(), WriteComplex[BACnetEventTypeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventType' field")
	}

	if err := WriteOptionalField[BACnetContextTagCharacterString](ctx, "messageText", GetRef(m.GetMessageText()), WriteComplex[BACnetContextTagCharacterString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'messageText' field")
	}

	if err := WriteSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", m.GetNotifyType(), WriteComplex[BACnetNotifyTypeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'notifyType' field")
	}

	if err := WriteOptionalField[BACnetContextTagBoolean](ctx, "ackRequired", GetRef(m.GetAckRequired()), WriteComplex[BACnetContextTagBoolean](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'ackRequired' field")
	}

	if err := WriteOptionalField[BACnetEventStateTagged](ctx, "fromState", GetRef(m.GetFromState()), WriteComplex[BACnetEventStateTagged](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'fromState' field")
	}

	if err := WriteSimpleField[BACnetEventStateTagged](ctx, "toState", m.GetToState(), WriteComplex[BACnetEventStateTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'toState' field")
	}

	if err := WriteOptionalField[BACnetNotificationParameters](ctx, "eventValues", GetRef(m.GetEventValues()), WriteComplex[BACnetNotificationParameters](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'eventValues' field")
	}

	if popErr := writeBuffer.PopContext("ConfirmedEventNotificationRequest"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ConfirmedEventNotificationRequest")
	}
	return nil
}

func (m *_ConfirmedEventNotificationRequest) IsConfirmedEventNotificationRequest() {}

func (m *_ConfirmedEventNotificationRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ConfirmedEventNotificationRequest) deepCopy() *_ConfirmedEventNotificationRequest {
	if m == nil {
		return nil
	}
	_ConfirmedEventNotificationRequestCopy := &_ConfirmedEventNotificationRequest{
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.ProcessIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.InitiatingDeviceIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.EventObjectIdentifier),
		utils.DeepCopy[BACnetTimeStampEnclosed](m.Timestamp),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.NotificationClass),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.Priority),
		utils.DeepCopy[BACnetEventTypeTagged](m.EventType),
		utils.DeepCopy[BACnetContextTagCharacterString](m.MessageText),
		utils.DeepCopy[BACnetNotifyTypeTagged](m.NotifyType),
		utils.DeepCopy[BACnetContextTagBoolean](m.AckRequired),
		utils.DeepCopy[BACnetEventStateTagged](m.FromState),
		utils.DeepCopy[BACnetEventStateTagged](m.ToState),
		utils.DeepCopy[BACnetNotificationParameters](m.EventValues),
	}
	return _ConfirmedEventNotificationRequestCopy
}

func (m *_ConfirmedEventNotificationRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
