/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BVLCResultCodeTagged is the corresponding interface of BVLCResultCodeTagged
type BVLCResultCodeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BVLCResultCode
	// IsBVLCResultCodeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLCResultCodeTagged()
	// CreateBuilder creates a BVLCResultCodeTaggedBuilder
	CreateBVLCResultCodeTaggedBuilder() BVLCResultCodeTaggedBuilder
}

// _BVLCResultCodeTagged is the data-structure of this message
type _BVLCResultCodeTagged struct {
	Header BACnetTagHeader
	Value  BVLCResultCode

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BVLCResultCodeTagged = (*_BVLCResultCodeTagged)(nil)

// NewBVLCResultCodeTagged factory function for _BVLCResultCodeTagged
func NewBVLCResultCodeTagged(header BACnetTagHeader, value BVLCResultCode, tagNumber uint8, tagClass TagClass) *_BVLCResultCodeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BVLCResultCodeTagged must not be nil")
	}
	return &_BVLCResultCodeTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BVLCResultCodeTaggedBuilder is a builder for BVLCResultCodeTagged
type BVLCResultCodeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BVLCResultCode) BVLCResultCodeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BVLCResultCodeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BVLCResultCodeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BVLCResultCode) BVLCResultCodeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BVLCResultCodeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BVLCResultCodeTaggedBuilder
	// Build builds the BVLCResultCodeTagged or returns an error if something is wrong
	Build() (BVLCResultCodeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BVLCResultCodeTagged
}

// NewBVLCResultCodeTaggedBuilder() creates a BVLCResultCodeTaggedBuilder
func NewBVLCResultCodeTaggedBuilder() BVLCResultCodeTaggedBuilder {
	return &_BVLCResultCodeTaggedBuilder{_BVLCResultCodeTagged: new(_BVLCResultCodeTagged)}
}

type _BVLCResultCodeTaggedBuilder struct {
	*_BVLCResultCodeTagged

	err *utils.MultiError
}

var _ (BVLCResultCodeTaggedBuilder) = (*_BVLCResultCodeTaggedBuilder)(nil)

func (b *_BVLCResultCodeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BVLCResultCode) BVLCResultCodeTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BVLCResultCodeTaggedBuilder) WithHeader(header BACnetTagHeader) BVLCResultCodeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BVLCResultCodeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BVLCResultCodeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BVLCResultCodeTaggedBuilder) WithValue(value BVLCResultCode) BVLCResultCodeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BVLCResultCodeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BVLCResultCodeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BVLCResultCodeTaggedBuilder) WithArgTagClass(tagClass TagClass) BVLCResultCodeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BVLCResultCodeTaggedBuilder) Build() (BVLCResultCodeTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BVLCResultCodeTagged.deepCopy(), nil
}

func (b *_BVLCResultCodeTaggedBuilder) MustBuild() BVLCResultCodeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCResultCodeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBVLCResultCodeTaggedBuilder().(*_BVLCResultCodeTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBVLCResultCodeTaggedBuilder creates a BVLCResultCodeTaggedBuilder
func (b *_BVLCResultCodeTagged) CreateBVLCResultCodeTaggedBuilder() BVLCResultCodeTaggedBuilder {
	if b == nil {
		return NewBVLCResultCodeTaggedBuilder()
	}
	return &_BVLCResultCodeTaggedBuilder{_BVLCResultCodeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BVLCResultCodeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BVLCResultCodeTagged) GetValue() BVLCResultCode {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBVLCResultCodeTagged(structType any) BVLCResultCodeTagged {
	if casted, ok := structType.(BVLCResultCodeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BVLCResultCodeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BVLCResultCodeTagged) GetTypeName() string {
	return "BVLCResultCodeTagged"
}

func (m *_BVLCResultCodeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BVLCResultCodeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BVLCResultCodeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BVLCResultCodeTagged, error) {
	return BVLCResultCodeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BVLCResultCodeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BVLCResultCodeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BVLCResultCodeTagged, error) {
		return BVLCResultCodeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BVLCResultCodeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BVLCResultCodeTagged, error) {
	v, err := (&_BVLCResultCodeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BVLCResultCodeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bVLCResultCodeTagged BVLCResultCodeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BVLCResultCodeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BVLCResultCodeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BVLCResultCode](ctx, "value", readBuffer, EnsureType[BVLCResultCode](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BVLCResultCode_SUCCESSFUL_COMPLETION)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BVLCResultCodeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BVLCResultCodeTagged")
	}

	return m, nil
}

func (m *_BVLCResultCodeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BVLCResultCodeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BVLCResultCodeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BVLCResultCodeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BVLCResultCode](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BVLCResultCodeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BVLCResultCodeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BVLCResultCodeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BVLCResultCodeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BVLCResultCodeTagged) IsBVLCResultCodeTagged() {}

func (m *_BVLCResultCodeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BVLCResultCodeTagged) deepCopy() *_BVLCResultCodeTagged {
	if m == nil {
		return nil
	}
	_BVLCResultCodeTaggedCopy := &_BVLCResultCodeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BVLCResultCodeTaggedCopy
}

func (m *_BVLCResultCodeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
