/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BVLCResult is the corresponding interface of BVLCResult
type BVLCResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BVLC
	// GetCode returns Code (property field)
	GetCode() BVLCResultCode
	// IsBVLCResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLCResult()
	// CreateBuilder creates a BVLCResultBuilder
	CreateBVLCResultBuilder() BVLCResultBuilder
}

// _BVLCResult is the data-structure of this message
type _BVLCResult struct {
	BVLCContract
	Code BVLCResultCode
}

var _ BVLCResult = (*_BVLCResult)(nil)
var _ BVLCRequirements = (*_BVLCResult)(nil)

// NewBVLCResult factory function for _BVLCResult
func NewBVLCResult(code BVLCResultCode) *_BVLCResult {
	_result := &_BVLCResult{
		BVLCContract: NewBVLC(),
		Code:         code,
	}
	_result.BVLCContract.(*_BVLC)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BVLCResultBuilder is a builder for BVLCResult
type BVLCResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(code BVLCResultCode) BVLCResultBuilder
	// WithCode adds Code (property field)
	WithCode(BVLCResultCode) BVLCResultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BVLCBuilder
	// Build builds the BVLCResult or returns an error if something is wrong
	Build() (BVLCResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BVLCResult
}

// NewBVLCResultBuilder() creates a BVLCResultBuilder
func NewBVLCResultBuilder() BVLCResultBuilder {
	return &_BVLCResultBuilder{_BVLCResult: new(_BVLCResult)}
}

type _BVLCResultBuilder struct {
	*_BVLCResult

	parentBuilder *_BVLCBuilder

	err *utils.MultiError
}

var _ (BVLCResultBuilder) = (*_BVLCResultBuilder)(nil)

func (b *_BVLCResultBuilder) setParent(contract BVLCContract) {
	b.BVLCContract = contract
	contract.(*_BVLC)._SubType = b._BVLCResult
}

func (b *_BVLCResultBuilder) WithMandatoryFields(code BVLCResultCode) BVLCResultBuilder {
	return b.WithCode(code)
}

func (b *_BVLCResultBuilder) WithCode(code BVLCResultCode) BVLCResultBuilder {
	b.Code = code
	return b
}

func (b *_BVLCResultBuilder) Build() (BVLCResult, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BVLCResult.deepCopy(), nil
}

func (b *_BVLCResultBuilder) MustBuild() BVLCResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCResultBuilder) Done() BVLCBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBVLCBuilder().(*_BVLCBuilder)
	}
	return b.parentBuilder
}

func (b *_BVLCResultBuilder) buildForBVLC() (BVLC, error) {
	return b.Build()
}

func (b *_BVLCResultBuilder) DeepCopy() any {
	_copy := b.CreateBVLCResultBuilder().(*_BVLCResultBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBVLCResultBuilder creates a BVLCResultBuilder
func (b *_BVLCResult) CreateBVLCResultBuilder() BVLCResultBuilder {
	if b == nil {
		return NewBVLCResultBuilder()
	}
	return &_BVLCResultBuilder{_BVLCResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BVLCResult) GetBvlcFunction() uint8 {
	return 0x00
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BVLCResult) GetParent() BVLCContract {
	return m.BVLCContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BVLCResult) GetCode() BVLCResultCode {
	return m.Code
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBVLCResult(structType any) BVLCResult {
	if casted, ok := structType.(BVLCResult); ok {
		return casted
	}
	if casted, ok := structType.(*BVLCResult); ok {
		return *casted
	}
	return nil
}

func (m *_BVLCResult) GetTypeName() string {
	return "BVLCResult"
}

func (m *_BVLCResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BVLCContract.(*_BVLC).getLengthInBits(ctx))

	// Simple field (code)
	lengthInBits += 16

	return lengthInBits
}

func (m *_BVLCResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BVLCResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BVLC) (__bVLCResult BVLCResult, err error) {
	m.BVLCContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BVLCResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BVLCResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	code, err := ReadEnumField[BVLCResultCode](ctx, "code", "BVLCResultCode", ReadEnum(BVLCResultCodeByValue, ReadUnsignedShort(readBuffer, uint8(16))), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'code' field"))
	}
	m.Code = code

	if closeErr := readBuffer.CloseContext("BVLCResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BVLCResult")
	}

	return m, nil
}

func (m *_BVLCResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BVLCResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BVLCResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BVLCResult")
		}

		if err := WriteSimpleEnumField[BVLCResultCode](ctx, "code", "BVLCResultCode", m.GetCode(), WriteEnum[BVLCResultCode, uint16](BVLCResultCode.GetValue, BVLCResultCode.PLC4XEnumName, WriteUnsignedShort(writeBuffer, 16)), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'code' field")
		}

		if popErr := writeBuffer.PopContext("BVLCResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BVLCResult")
		}
		return nil
	}
	return m.BVLCContract.(*_BVLC).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BVLCResult) IsBVLCResult() {}

func (m *_BVLCResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BVLCResult) deepCopy() *_BVLCResult {
	if m == nil {
		return nil
	}
	_BVLCResultCopy := &_BVLCResult{
		m.BVLCContract.(*_BVLC).deepCopy(),
		m.Code,
	}
	_BVLCResultCopy.BVLCContract.(*_BVLC)._SubType = m
	return _BVLCResultCopy
}

func (m *_BVLCResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
