/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetWriteAccessSpecification is the corresponding interface of BACnetWriteAccessSpecification
type BACnetWriteAccessSpecification interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfPropertyWriteDefinition returns ListOfPropertyWriteDefinition (property field)
	GetListOfPropertyWriteDefinition() []BACnetPropertyWriteDefinition
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetWriteAccessSpecification is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetWriteAccessSpecification()
	// CreateBuilder creates a BACnetWriteAccessSpecificationBuilder
	CreateBACnetWriteAccessSpecificationBuilder() BACnetWriteAccessSpecificationBuilder
}

// _BACnetWriteAccessSpecification is the data-structure of this message
type _BACnetWriteAccessSpecification struct {
	ObjectIdentifier              BACnetContextTagObjectIdentifier
	OpeningTag                    BACnetOpeningTag
	ListOfPropertyWriteDefinition []BACnetPropertyWriteDefinition
	ClosingTag                    BACnetClosingTag
}

var _ BACnetWriteAccessSpecification = (*_BACnetWriteAccessSpecification)(nil)

// NewBACnetWriteAccessSpecification factory function for _BACnetWriteAccessSpecification
func NewBACnetWriteAccessSpecification(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyWriteDefinition []BACnetPropertyWriteDefinition, closingTag BACnetClosingTag) *_BACnetWriteAccessSpecification {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetWriteAccessSpecification must not be nil")
	}
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetWriteAccessSpecification must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetWriteAccessSpecification must not be nil")
	}
	return &_BACnetWriteAccessSpecification{ObjectIdentifier: objectIdentifier, OpeningTag: openingTag, ListOfPropertyWriteDefinition: listOfPropertyWriteDefinition, ClosingTag: closingTag}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetWriteAccessSpecificationBuilder is a builder for BACnetWriteAccessSpecification
type BACnetWriteAccessSpecificationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyWriteDefinition []BACnetPropertyWriteDefinition, closingTag BACnetClosingTag) BACnetWriteAccessSpecificationBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetWriteAccessSpecificationBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetWriteAccessSpecificationBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetWriteAccessSpecificationBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetWriteAccessSpecificationBuilder
	// WithListOfPropertyWriteDefinition adds ListOfPropertyWriteDefinition (property field)
	WithListOfPropertyWriteDefinition(...BACnetPropertyWriteDefinition) BACnetWriteAccessSpecificationBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetWriteAccessSpecificationBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetWriteAccessSpecificationBuilder
	// Build builds the BACnetWriteAccessSpecification or returns an error if something is wrong
	Build() (BACnetWriteAccessSpecification, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetWriteAccessSpecification
}

// NewBACnetWriteAccessSpecificationBuilder() creates a BACnetWriteAccessSpecificationBuilder
func NewBACnetWriteAccessSpecificationBuilder() BACnetWriteAccessSpecificationBuilder {
	return &_BACnetWriteAccessSpecificationBuilder{_BACnetWriteAccessSpecification: new(_BACnetWriteAccessSpecification)}
}

type _BACnetWriteAccessSpecificationBuilder struct {
	*_BACnetWriteAccessSpecification

	err *utils.MultiError
}

var _ (BACnetWriteAccessSpecificationBuilder) = (*_BACnetWriteAccessSpecificationBuilder)(nil)

func (b *_BACnetWriteAccessSpecificationBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyWriteDefinition []BACnetPropertyWriteDefinition, closingTag BACnetClosingTag) BACnetWriteAccessSpecificationBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithOpeningTag(openingTag).WithListOfPropertyWriteDefinition(listOfPropertyWriteDefinition...).WithClosingTag(closingTag)
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetWriteAccessSpecificationBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetWriteAccessSpecificationBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetWriteAccessSpecificationBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetWriteAccessSpecificationBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithListOfPropertyWriteDefinition(listOfPropertyWriteDefinition ...BACnetPropertyWriteDefinition) BACnetWriteAccessSpecificationBuilder {
	b.ListOfPropertyWriteDefinition = listOfPropertyWriteDefinition
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetWriteAccessSpecificationBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetWriteAccessSpecificationBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetWriteAccessSpecificationBuilder) Build() (BACnetWriteAccessSpecification, error) {
	if b.ObjectIdentifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetWriteAccessSpecification.deepCopy(), nil
}

func (b *_BACnetWriteAccessSpecificationBuilder) MustBuild() BACnetWriteAccessSpecification {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetWriteAccessSpecificationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetWriteAccessSpecificationBuilder().(*_BACnetWriteAccessSpecificationBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetWriteAccessSpecificationBuilder creates a BACnetWriteAccessSpecificationBuilder
func (b *_BACnetWriteAccessSpecification) CreateBACnetWriteAccessSpecificationBuilder() BACnetWriteAccessSpecificationBuilder {
	if b == nil {
		return NewBACnetWriteAccessSpecificationBuilder()
	}
	return &_BACnetWriteAccessSpecificationBuilder{_BACnetWriteAccessSpecification: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetWriteAccessSpecification) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetWriteAccessSpecification) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetWriteAccessSpecification) GetListOfPropertyWriteDefinition() []BACnetPropertyWriteDefinition {
	return m.ListOfPropertyWriteDefinition
}

func (m *_BACnetWriteAccessSpecification) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetWriteAccessSpecification(structType any) BACnetWriteAccessSpecification {
	if casted, ok := structType.(BACnetWriteAccessSpecification); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetWriteAccessSpecification); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetWriteAccessSpecification) GetTypeName() string {
	return "BACnetWriteAccessSpecification"
}

func (m *_BACnetWriteAccessSpecification) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfPropertyWriteDefinition) > 0 {
		for _, element := range m.ListOfPropertyWriteDefinition {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetWriteAccessSpecification) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetWriteAccessSpecificationParse(ctx context.Context, theBytes []byte) (BACnetWriteAccessSpecification, error) {
	return BACnetWriteAccessSpecificationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetWriteAccessSpecificationParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteAccessSpecification, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteAccessSpecification, error) {
		return BACnetWriteAccessSpecificationParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetWriteAccessSpecificationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteAccessSpecification, error) {
	v, err := (&_BACnetWriteAccessSpecification{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetWriteAccessSpecification) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetWriteAccessSpecification BACnetWriteAccessSpecification, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetWriteAccessSpecification"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetWriteAccessSpecification")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfPropertyWriteDefinition, err := ReadTerminatedArrayField[BACnetPropertyWriteDefinition](ctx, "listOfPropertyWriteDefinition", ReadComplex[BACnetPropertyWriteDefinition](BACnetPropertyWriteDefinitionParseWithBufferProducer((BACnetObjectType)(objectIdentifier.GetObjectType())), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, 1))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfPropertyWriteDefinition' field"))
	}
	m.ListOfPropertyWriteDefinition = listOfPropertyWriteDefinition

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetWriteAccessSpecification"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetWriteAccessSpecification")
	}

	return m, nil
}

func (m *_BACnetWriteAccessSpecification) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetWriteAccessSpecification) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetWriteAccessSpecification"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetWriteAccessSpecification")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfPropertyWriteDefinition", m.GetListOfPropertyWriteDefinition(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfPropertyWriteDefinition' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetWriteAccessSpecification"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetWriteAccessSpecification")
	}
	return nil
}

func (m *_BACnetWriteAccessSpecification) IsBACnetWriteAccessSpecification() {}

func (m *_BACnetWriteAccessSpecification) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetWriteAccessSpecification) deepCopy() *_BACnetWriteAccessSpecification {
	if m == nil {
		return nil
	}
	_BACnetWriteAccessSpecificationCopy := &_BACnetWriteAccessSpecification{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetPropertyWriteDefinition, BACnetPropertyWriteDefinition](m.ListOfPropertyWriteDefinition),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
	}
	return _BACnetWriteAccessSpecificationCopy
}

func (m *_BACnetWriteAccessSpecification) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
