/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetTimeStampTime is the corresponding interface of BACnetTimeStampTime
type BACnetTimeStampTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetTimeStamp
	// GetTimeValue returns TimeValue (property field)
	GetTimeValue() BACnetContextTagTime
	// IsBACnetTimeStampTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetTimeStampTime()
	// CreateBuilder creates a BACnetTimeStampTimeBuilder
	CreateBACnetTimeStampTimeBuilder() BACnetTimeStampTimeBuilder
}

// _BACnetTimeStampTime is the data-structure of this message
type _BACnetTimeStampTime struct {
	BACnetTimeStampContract
	TimeValue BACnetContextTagTime
}

var _ BACnetTimeStampTime = (*_BACnetTimeStampTime)(nil)
var _ BACnetTimeStampRequirements = (*_BACnetTimeStampTime)(nil)

// NewBACnetTimeStampTime factory function for _BACnetTimeStampTime
func NewBACnetTimeStampTime(peekedTagHeader BACnetTagHeader, timeValue BACnetContextTagTime) *_BACnetTimeStampTime {
	if timeValue == nil {
		panic("timeValue of type BACnetContextTagTime for BACnetTimeStampTime must not be nil")
	}
	_result := &_BACnetTimeStampTime{
		BACnetTimeStampContract: NewBACnetTimeStamp(peekedTagHeader),
		TimeValue:               timeValue,
	}
	_result.BACnetTimeStampContract.(*_BACnetTimeStamp)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetTimeStampTimeBuilder is a builder for BACnetTimeStampTime
type BACnetTimeStampTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timeValue BACnetContextTagTime) BACnetTimeStampTimeBuilder
	// WithTimeValue adds TimeValue (property field)
	WithTimeValue(BACnetContextTagTime) BACnetTimeStampTimeBuilder
	// WithTimeValueBuilder adds TimeValue (property field) which is build by the builder
	WithTimeValueBuilder(func(BACnetContextTagTimeBuilder) BACnetContextTagTimeBuilder) BACnetTimeStampTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetTimeStampBuilder
	// Build builds the BACnetTimeStampTime or returns an error if something is wrong
	Build() (BACnetTimeStampTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetTimeStampTime
}

// NewBACnetTimeStampTimeBuilder() creates a BACnetTimeStampTimeBuilder
func NewBACnetTimeStampTimeBuilder() BACnetTimeStampTimeBuilder {
	return &_BACnetTimeStampTimeBuilder{_BACnetTimeStampTime: new(_BACnetTimeStampTime)}
}

type _BACnetTimeStampTimeBuilder struct {
	*_BACnetTimeStampTime

	parentBuilder *_BACnetTimeStampBuilder

	err *utils.MultiError
}

var _ (BACnetTimeStampTimeBuilder) = (*_BACnetTimeStampTimeBuilder)(nil)

func (b *_BACnetTimeStampTimeBuilder) setParent(contract BACnetTimeStampContract) {
	b.BACnetTimeStampContract = contract
	contract.(*_BACnetTimeStamp)._SubType = b._BACnetTimeStampTime
}

func (b *_BACnetTimeStampTimeBuilder) WithMandatoryFields(timeValue BACnetContextTagTime) BACnetTimeStampTimeBuilder {
	return b.WithTimeValue(timeValue)
}

func (b *_BACnetTimeStampTimeBuilder) WithTimeValue(timeValue BACnetContextTagTime) BACnetTimeStampTimeBuilder {
	b.TimeValue = timeValue
	return b
}

func (b *_BACnetTimeStampTimeBuilder) WithTimeValueBuilder(builderSupplier func(BACnetContextTagTimeBuilder) BACnetContextTagTimeBuilder) BACnetTimeStampTimeBuilder {
	builder := builderSupplier(b.TimeValue.CreateBACnetContextTagTimeBuilder())
	var err error
	b.TimeValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetTimeStampTimeBuilder) Build() (BACnetTimeStampTime, error) {
	if b.TimeValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'timeValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetTimeStampTime.deepCopy(), nil
}

func (b *_BACnetTimeStampTimeBuilder) MustBuild() BACnetTimeStampTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetTimeStampTimeBuilder) Done() BACnetTimeStampBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetTimeStampBuilder().(*_BACnetTimeStampBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetTimeStampTimeBuilder) buildForBACnetTimeStamp() (BACnetTimeStamp, error) {
	return b.Build()
}

func (b *_BACnetTimeStampTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetTimeStampTimeBuilder().(*_BACnetTimeStampTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetTimeStampTimeBuilder creates a BACnetTimeStampTimeBuilder
func (b *_BACnetTimeStampTime) CreateBACnetTimeStampTimeBuilder() BACnetTimeStampTimeBuilder {
	if b == nil {
		return NewBACnetTimeStampTimeBuilder()
	}
	return &_BACnetTimeStampTimeBuilder{_BACnetTimeStampTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetTimeStampTime) GetParent() BACnetTimeStampContract {
	return m.BACnetTimeStampContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetTimeStampTime) GetTimeValue() BACnetContextTagTime {
	return m.TimeValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetTimeStampTime(structType any) BACnetTimeStampTime {
	if casted, ok := structType.(BACnetTimeStampTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetTimeStampTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetTimeStampTime) GetTypeName() string {
	return "BACnetTimeStampTime"
}

func (m *_BACnetTimeStampTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetTimeStampContract.(*_BACnetTimeStamp).getLengthInBits(ctx))

	// Simple field (timeValue)
	lengthInBits += m.TimeValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetTimeStampTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetTimeStampTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetTimeStamp) (__bACnetTimeStampTime BACnetTimeStampTime, err error) {
	m.BACnetTimeStampContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetTimeStampTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetTimeStampTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timeValue, err := ReadSimpleField[BACnetContextTagTime](ctx, "timeValue", ReadComplex[BACnetContextTagTime](BACnetContextTagParseWithBufferProducer[BACnetContextTagTime]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_TIME)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeValue' field"))
	}
	m.TimeValue = timeValue

	if closeErr := readBuffer.CloseContext("BACnetTimeStampTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetTimeStampTime")
	}

	return m, nil
}

func (m *_BACnetTimeStampTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetTimeStampTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetTimeStampTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetTimeStampTime")
		}

		if err := WriteSimpleField[BACnetContextTagTime](ctx, "timeValue", m.GetTimeValue(), WriteComplex[BACnetContextTagTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetTimeStampTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetTimeStampTime")
		}
		return nil
	}
	return m.BACnetTimeStampContract.(*_BACnetTimeStamp).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetTimeStampTime) IsBACnetTimeStampTime() {}

func (m *_BACnetTimeStampTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetTimeStampTime) deepCopy() *_BACnetTimeStampTime {
	if m == nil {
		return nil
	}
	_BACnetTimeStampTimeCopy := &_BACnetTimeStampTime{
		m.BACnetTimeStampContract.(*_BACnetTimeStamp).deepCopy(),
		utils.DeepCopy[BACnetContextTagTime](m.TimeValue),
	}
	_BACnetTimeStampTimeCopy.BACnetTimeStampContract.(*_BACnetTimeStamp)._SubType = m
	return _BACnetTimeStampTimeCopy
}

func (m *_BACnetTimeStampTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
