/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSpecialEventPeriod is the corresponding interface of BACnetSpecialEventPeriod
type BACnetSpecialEventPeriod interface {
	BACnetSpecialEventPeriodContract
	BACnetSpecialEventPeriodRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetSpecialEventPeriod is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSpecialEventPeriod()
	// CreateBuilder creates a BACnetSpecialEventPeriodBuilder
	CreateBACnetSpecialEventPeriodBuilder() BACnetSpecialEventPeriodBuilder
}

// BACnetSpecialEventPeriodContract provides a set of functions which can be overwritten by a sub struct
type BACnetSpecialEventPeriodContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetSpecialEventPeriod is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSpecialEventPeriod()
	// CreateBuilder creates a BACnetSpecialEventPeriodBuilder
	CreateBACnetSpecialEventPeriodBuilder() BACnetSpecialEventPeriodBuilder
}

// BACnetSpecialEventPeriodRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetSpecialEventPeriodRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetSpecialEventPeriod is the data-structure of this message
type _BACnetSpecialEventPeriod struct {
	_SubType interface {
		BACnetSpecialEventPeriodContract
		BACnetSpecialEventPeriodRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetSpecialEventPeriodContract = (*_BACnetSpecialEventPeriod)(nil)

// NewBACnetSpecialEventPeriod factory function for _BACnetSpecialEventPeriod
func NewBACnetSpecialEventPeriod(peekedTagHeader BACnetTagHeader) *_BACnetSpecialEventPeriod {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetSpecialEventPeriod must not be nil")
	}
	return &_BACnetSpecialEventPeriod{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSpecialEventPeriodBuilder is a builder for BACnetSpecialEventPeriod
type BACnetSpecialEventPeriodBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetSpecialEventPeriodBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetSpecialEventPeriodBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetSpecialEventPeriodBuilder
	// AsBACnetSpecialEventPeriodCalendarEntry converts this build to a subType of BACnetSpecialEventPeriod. It is always possible to return to current builder using Done()
	AsBACnetSpecialEventPeriodCalendarEntry() BACnetSpecialEventPeriodCalendarEntryBuilder
	// AsBACnetSpecialEventPeriodCalendarReference converts this build to a subType of BACnetSpecialEventPeriod. It is always possible to return to current builder using Done()
	AsBACnetSpecialEventPeriodCalendarReference() BACnetSpecialEventPeriodCalendarReferenceBuilder
	// Build builds the BACnetSpecialEventPeriod or returns an error if something is wrong
	PartialBuild() (BACnetSpecialEventPeriodContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetSpecialEventPeriodContract
	// Build builds the BACnetSpecialEventPeriod or returns an error if something is wrong
	Build() (BACnetSpecialEventPeriod, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSpecialEventPeriod
}

// NewBACnetSpecialEventPeriodBuilder() creates a BACnetSpecialEventPeriodBuilder
func NewBACnetSpecialEventPeriodBuilder() BACnetSpecialEventPeriodBuilder {
	return &_BACnetSpecialEventPeriodBuilder{_BACnetSpecialEventPeriod: new(_BACnetSpecialEventPeriod)}
}

type _BACnetSpecialEventPeriodChildBuilder interface {
	utils.Copyable
	setParent(BACnetSpecialEventPeriodContract)
	buildForBACnetSpecialEventPeriod() (BACnetSpecialEventPeriod, error)
}

type _BACnetSpecialEventPeriodBuilder struct {
	*_BACnetSpecialEventPeriod

	childBuilder _BACnetSpecialEventPeriodChildBuilder

	err *utils.MultiError
}

var _ (BACnetSpecialEventPeriodBuilder) = (*_BACnetSpecialEventPeriodBuilder)(nil)

func (b *_BACnetSpecialEventPeriodBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetSpecialEventPeriodBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetSpecialEventPeriodBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetSpecialEventPeriodBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetSpecialEventPeriodBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetSpecialEventPeriodBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventPeriodBuilder) PartialBuild() (BACnetSpecialEventPeriodContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetSpecialEventPeriod.deepCopy(), nil
}

func (b *_BACnetSpecialEventPeriodBuilder) PartialMustBuild() BACnetSpecialEventPeriodContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSpecialEventPeriodBuilder) AsBACnetSpecialEventPeriodCalendarEntry() BACnetSpecialEventPeriodCalendarEntryBuilder {
	if cb, ok := b.childBuilder.(BACnetSpecialEventPeriodCalendarEntryBuilder); ok {
		return cb
	}
	cb := NewBACnetSpecialEventPeriodCalendarEntryBuilder().(*_BACnetSpecialEventPeriodCalendarEntryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetSpecialEventPeriodBuilder) AsBACnetSpecialEventPeriodCalendarReference() BACnetSpecialEventPeriodCalendarReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetSpecialEventPeriodCalendarReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetSpecialEventPeriodCalendarReferenceBuilder().(*_BACnetSpecialEventPeriodCalendarReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetSpecialEventPeriodBuilder) Build() (BACnetSpecialEventPeriod, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetSpecialEventPeriod()
}

func (b *_BACnetSpecialEventPeriodBuilder) MustBuild() BACnetSpecialEventPeriod {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSpecialEventPeriodBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSpecialEventPeriodBuilder().(*_BACnetSpecialEventPeriodBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetSpecialEventPeriodChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetSpecialEventPeriodBuilder creates a BACnetSpecialEventPeriodBuilder
func (b *_BACnetSpecialEventPeriod) CreateBACnetSpecialEventPeriodBuilder() BACnetSpecialEventPeriodBuilder {
	if b == nil {
		return NewBACnetSpecialEventPeriodBuilder()
	}
	return &_BACnetSpecialEventPeriodBuilder{_BACnetSpecialEventPeriod: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSpecialEventPeriod) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetSpecialEventPeriod) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSpecialEventPeriod(structType any) BACnetSpecialEventPeriod {
	if casted, ok := structType.(BACnetSpecialEventPeriod); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSpecialEventPeriod); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSpecialEventPeriod) GetTypeName() string {
	return "BACnetSpecialEventPeriod"
}

func (m *_BACnetSpecialEventPeriod) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetSpecialEventPeriod) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetSpecialEventPeriod) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetSpecialEventPeriodParse[T BACnetSpecialEventPeriod](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetSpecialEventPeriodParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetSpecialEventPeriodParseWithBufferProducer[T BACnetSpecialEventPeriod]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetSpecialEventPeriodParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetSpecialEventPeriodParseWithBuffer[T BACnetSpecialEventPeriod](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetSpecialEventPeriod{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetSpecialEventPeriod) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetSpecialEventPeriod BACnetSpecialEventPeriod, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSpecialEventPeriod"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSpecialEventPeriod")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Validation
	if !(bool((peekedTagHeader.GetTagClass()) == (TagClass_CONTEXT_SPECIFIC_TAGS))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "Validation failed"})
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetSpecialEventPeriod
	switch {
	case peekedTagNumber == uint8(0): // BACnetSpecialEventPeriodCalendarEntry
		if _child, err = new(_BACnetSpecialEventPeriodCalendarEntry).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetSpecialEventPeriodCalendarEntry for type-switch of BACnetSpecialEventPeriod")
		}
	case peekedTagNumber == uint8(1): // BACnetSpecialEventPeriodCalendarReference
		if _child, err = new(_BACnetSpecialEventPeriodCalendarReference).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetSpecialEventPeriodCalendarReference for type-switch of BACnetSpecialEventPeriod")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetSpecialEventPeriod"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSpecialEventPeriod")
	}

	return _child, nil
}

func (pm *_BACnetSpecialEventPeriod) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetSpecialEventPeriod, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetSpecialEventPeriod"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetSpecialEventPeriod")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetSpecialEventPeriod"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetSpecialEventPeriod")
	}
	return nil
}

func (m *_BACnetSpecialEventPeriod) IsBACnetSpecialEventPeriod() {}

func (m *_BACnetSpecialEventPeriod) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSpecialEventPeriod) deepCopy() *_BACnetSpecialEventPeriod {
	if m == nil {
		return nil
	}
	_BACnetSpecialEventPeriodCopy := &_BACnetSpecialEventPeriod{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetSpecialEventPeriodCopy
}
