/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetScale is the corresponding interface of BACnetScale
type BACnetScale interface {
	BACnetScaleContract
	BACnetScaleRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetScale is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetScale()
	// CreateBuilder creates a BACnetScaleBuilder
	CreateBACnetScaleBuilder() BACnetScaleBuilder
}

// BACnetScaleContract provides a set of functions which can be overwritten by a sub struct
type BACnetScaleContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetScale is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetScale()
	// CreateBuilder creates a BACnetScaleBuilder
	CreateBACnetScaleBuilder() BACnetScaleBuilder
}

// BACnetScaleRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetScaleRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetScale is the data-structure of this message
type _BACnetScale struct {
	_SubType interface {
		BACnetScaleContract
		BACnetScaleRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetScaleContract = (*_BACnetScale)(nil)

// NewBACnetScale factory function for _BACnetScale
func NewBACnetScale(peekedTagHeader BACnetTagHeader) *_BACnetScale {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetScale must not be nil")
	}
	return &_BACnetScale{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetScaleBuilder is a builder for BACnetScale
type BACnetScaleBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetScaleBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetScaleBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetScaleBuilder
	// AsBACnetScaleFloatScale converts this build to a subType of BACnetScale. It is always possible to return to current builder using Done()
	AsBACnetScaleFloatScale() BACnetScaleFloatScaleBuilder
	// AsBACnetScaleIntegerScale converts this build to a subType of BACnetScale. It is always possible to return to current builder using Done()
	AsBACnetScaleIntegerScale() BACnetScaleIntegerScaleBuilder
	// Build builds the BACnetScale or returns an error if something is wrong
	PartialBuild() (BACnetScaleContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetScaleContract
	// Build builds the BACnetScale or returns an error if something is wrong
	Build() (BACnetScale, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetScale
}

// NewBACnetScaleBuilder() creates a BACnetScaleBuilder
func NewBACnetScaleBuilder() BACnetScaleBuilder {
	return &_BACnetScaleBuilder{_BACnetScale: new(_BACnetScale)}
}

type _BACnetScaleChildBuilder interface {
	utils.Copyable
	setParent(BACnetScaleContract)
	buildForBACnetScale() (BACnetScale, error)
}

type _BACnetScaleBuilder struct {
	*_BACnetScale

	childBuilder _BACnetScaleChildBuilder

	err *utils.MultiError
}

var _ (BACnetScaleBuilder) = (*_BACnetScaleBuilder)(nil)

func (b *_BACnetScaleBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetScaleBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetScaleBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetScaleBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetScaleBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetScaleBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetScaleBuilder) PartialBuild() (BACnetScaleContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetScale.deepCopy(), nil
}

func (b *_BACnetScaleBuilder) PartialMustBuild() BACnetScaleContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetScaleBuilder) AsBACnetScaleFloatScale() BACnetScaleFloatScaleBuilder {
	if cb, ok := b.childBuilder.(BACnetScaleFloatScaleBuilder); ok {
		return cb
	}
	cb := NewBACnetScaleFloatScaleBuilder().(*_BACnetScaleFloatScaleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetScaleBuilder) AsBACnetScaleIntegerScale() BACnetScaleIntegerScaleBuilder {
	if cb, ok := b.childBuilder.(BACnetScaleIntegerScaleBuilder); ok {
		return cb
	}
	cb := NewBACnetScaleIntegerScaleBuilder().(*_BACnetScaleIntegerScaleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetScaleBuilder) Build() (BACnetScale, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetScale()
}

func (b *_BACnetScaleBuilder) MustBuild() BACnetScale {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetScaleBuilder) DeepCopy() any {
	_copy := b.CreateBACnetScaleBuilder().(*_BACnetScaleBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetScaleChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetScaleBuilder creates a BACnetScaleBuilder
func (b *_BACnetScale) CreateBACnetScaleBuilder() BACnetScaleBuilder {
	if b == nil {
		return NewBACnetScaleBuilder()
	}
	return &_BACnetScaleBuilder{_BACnetScale: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetScale) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetScale) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetScale(structType any) BACnetScale {
	if casted, ok := structType.(BACnetScale); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetScale); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetScale) GetTypeName() string {
	return "BACnetScale"
}

func (m *_BACnetScale) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetScale) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetScale) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetScaleParse[T BACnetScale](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetScaleParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetScaleParseWithBufferProducer[T BACnetScale]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetScaleParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetScaleParseWithBuffer[T BACnetScale](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetScale{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetScale) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetScale BACnetScale, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetScale"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetScale")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetScale
	switch {
	case peekedTagNumber == uint8(0): // BACnetScaleFloatScale
		if _child, err = new(_BACnetScaleFloatScale).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetScaleFloatScale for type-switch of BACnetScale")
		}
	case peekedTagNumber == uint8(1): // BACnetScaleIntegerScale
		if _child, err = new(_BACnetScaleIntegerScale).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetScaleIntegerScale for type-switch of BACnetScale")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetScale"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetScale")
	}

	return _child, nil
}

func (pm *_BACnetScale) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetScale, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetScale"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetScale")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetScale"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetScale")
	}
	return nil
}

func (m *_BACnetScale) IsBACnetScale() {}

func (m *_BACnetScale) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetScale) deepCopy() *_BACnetScale {
	if m == nil {
		return nil
	}
	_BACnetScaleCopy := &_BACnetScale{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetScaleCopy
}
