/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetRecipientProcessEnclosed is the corresponding interface of BACnetRecipientProcessEnclosed
type BACnetRecipientProcessEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetRecipientProcess returns RecipientProcess (property field)
	GetRecipientProcess() BACnetRecipientProcess
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetRecipientProcessEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetRecipientProcessEnclosed()
	// CreateBuilder creates a BACnetRecipientProcessEnclosedBuilder
	CreateBACnetRecipientProcessEnclosedBuilder() BACnetRecipientProcessEnclosedBuilder
}

// _BACnetRecipientProcessEnclosed is the data-structure of this message
type _BACnetRecipientProcessEnclosed struct {
	OpeningTag       BACnetOpeningTag
	RecipientProcess BACnetRecipientProcess
	ClosingTag       BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetRecipientProcessEnclosed = (*_BACnetRecipientProcessEnclosed)(nil)

// NewBACnetRecipientProcessEnclosed factory function for _BACnetRecipientProcessEnclosed
func NewBACnetRecipientProcessEnclosed(openingTag BACnetOpeningTag, recipientProcess BACnetRecipientProcess, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetRecipientProcessEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetRecipientProcessEnclosed must not be nil")
	}
	if recipientProcess == nil {
		panic("recipientProcess of type BACnetRecipientProcess for BACnetRecipientProcessEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetRecipientProcessEnclosed must not be nil")
	}
	return &_BACnetRecipientProcessEnclosed{OpeningTag: openingTag, RecipientProcess: recipientProcess, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetRecipientProcessEnclosedBuilder is a builder for BACnetRecipientProcessEnclosed
type BACnetRecipientProcessEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, recipientProcess BACnetRecipientProcess, closingTag BACnetClosingTag) BACnetRecipientProcessEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetRecipientProcessEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetRecipientProcessEnclosedBuilder
	// WithRecipientProcess adds RecipientProcess (property field)
	WithRecipientProcess(BACnetRecipientProcess) BACnetRecipientProcessEnclosedBuilder
	// WithRecipientProcessBuilder adds RecipientProcess (property field) which is build by the builder
	WithRecipientProcessBuilder(func(BACnetRecipientProcessBuilder) BACnetRecipientProcessBuilder) BACnetRecipientProcessEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetRecipientProcessEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetRecipientProcessEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetRecipientProcessEnclosedBuilder
	// Build builds the BACnetRecipientProcessEnclosed or returns an error if something is wrong
	Build() (BACnetRecipientProcessEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetRecipientProcessEnclosed
}

// NewBACnetRecipientProcessEnclosedBuilder() creates a BACnetRecipientProcessEnclosedBuilder
func NewBACnetRecipientProcessEnclosedBuilder() BACnetRecipientProcessEnclosedBuilder {
	return &_BACnetRecipientProcessEnclosedBuilder{_BACnetRecipientProcessEnclosed: new(_BACnetRecipientProcessEnclosed)}
}

type _BACnetRecipientProcessEnclosedBuilder struct {
	*_BACnetRecipientProcessEnclosed

	err *utils.MultiError
}

var _ (BACnetRecipientProcessEnclosedBuilder) = (*_BACnetRecipientProcessEnclosedBuilder)(nil)

func (b *_BACnetRecipientProcessEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, recipientProcess BACnetRecipientProcess, closingTag BACnetClosingTag) BACnetRecipientProcessEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithRecipientProcess(recipientProcess).WithClosingTag(closingTag)
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetRecipientProcessEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetRecipientProcessEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithRecipientProcess(recipientProcess BACnetRecipientProcess) BACnetRecipientProcessEnclosedBuilder {
	b.RecipientProcess = recipientProcess
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithRecipientProcessBuilder(builderSupplier func(BACnetRecipientProcessBuilder) BACnetRecipientProcessBuilder) BACnetRecipientProcessEnclosedBuilder {
	builder := builderSupplier(b.RecipientProcess.CreateBACnetRecipientProcessBuilder())
	var err error
	b.RecipientProcess, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetRecipientProcessBuilder failed"))
	}
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetRecipientProcessEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetRecipientProcessEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetRecipientProcessEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetRecipientProcessEnclosedBuilder) Build() (BACnetRecipientProcessEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.RecipientProcess == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'recipientProcess' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetRecipientProcessEnclosed.deepCopy(), nil
}

func (b *_BACnetRecipientProcessEnclosedBuilder) MustBuild() BACnetRecipientProcessEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetRecipientProcessEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetRecipientProcessEnclosedBuilder().(*_BACnetRecipientProcessEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetRecipientProcessEnclosedBuilder creates a BACnetRecipientProcessEnclosedBuilder
func (b *_BACnetRecipientProcessEnclosed) CreateBACnetRecipientProcessEnclosedBuilder() BACnetRecipientProcessEnclosedBuilder {
	if b == nil {
		return NewBACnetRecipientProcessEnclosedBuilder()
	}
	return &_BACnetRecipientProcessEnclosedBuilder{_BACnetRecipientProcessEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetRecipientProcessEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetRecipientProcessEnclosed) GetRecipientProcess() BACnetRecipientProcess {
	return m.RecipientProcess
}

func (m *_BACnetRecipientProcessEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetRecipientProcessEnclosed(structType any) BACnetRecipientProcessEnclosed {
	if casted, ok := structType.(BACnetRecipientProcessEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetRecipientProcessEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetRecipientProcessEnclosed) GetTypeName() string {
	return "BACnetRecipientProcessEnclosed"
}

func (m *_BACnetRecipientProcessEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (recipientProcess)
	lengthInBits += m.RecipientProcess.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetRecipientProcessEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetRecipientProcessEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetRecipientProcessEnclosed, error) {
	return BACnetRecipientProcessEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetRecipientProcessEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetRecipientProcessEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetRecipientProcessEnclosed, error) {
		return BACnetRecipientProcessEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetRecipientProcessEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetRecipientProcessEnclosed, error) {
	v, err := (&_BACnetRecipientProcessEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetRecipientProcessEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetRecipientProcessEnclosed BACnetRecipientProcessEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetRecipientProcessEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetRecipientProcessEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	recipientProcess, err := ReadSimpleField[BACnetRecipientProcess](ctx, "recipientProcess", ReadComplex[BACnetRecipientProcess](BACnetRecipientProcessParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recipientProcess' field"))
	}
	m.RecipientProcess = recipientProcess

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetRecipientProcessEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetRecipientProcessEnclosed")
	}

	return m, nil
}

func (m *_BACnetRecipientProcessEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetRecipientProcessEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetRecipientProcessEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetRecipientProcessEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetRecipientProcess](ctx, "recipientProcess", m.GetRecipientProcess(), WriteComplex[BACnetRecipientProcess](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'recipientProcess' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetRecipientProcessEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetRecipientProcessEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetRecipientProcessEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetRecipientProcessEnclosed) IsBACnetRecipientProcessEnclosed() {}

func (m *_BACnetRecipientProcessEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetRecipientProcessEnclosed) deepCopy() *_BACnetRecipientProcessEnclosed {
	if m == nil {
		return nil
	}
	_BACnetRecipientProcessEnclosedCopy := &_BACnetRecipientProcessEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetRecipientProcess](m.RecipientProcess),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetRecipientProcessEnclosedCopy
}

func (m *_BACnetRecipientProcessEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
