/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesState is the corresponding interface of BACnetPropertyStatesState
type BACnetPropertyStatesState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetState returns State (property field)
	GetState() BACnetEventStateTagged
	// IsBACnetPropertyStatesState is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesState()
	// CreateBuilder creates a BACnetPropertyStatesStateBuilder
	CreateBACnetPropertyStatesStateBuilder() BACnetPropertyStatesStateBuilder
}

// _BACnetPropertyStatesState is the data-structure of this message
type _BACnetPropertyStatesState struct {
	BACnetPropertyStatesContract
	State BACnetEventStateTagged
}

var _ BACnetPropertyStatesState = (*_BACnetPropertyStatesState)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesState)(nil)

// NewBACnetPropertyStatesState factory function for _BACnetPropertyStatesState
func NewBACnetPropertyStatesState(peekedTagHeader BACnetTagHeader, state BACnetEventStateTagged) *_BACnetPropertyStatesState {
	if state == nil {
		panic("state of type BACnetEventStateTagged for BACnetPropertyStatesState must not be nil")
	}
	_result := &_BACnetPropertyStatesState{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		State:                        state,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesStateBuilder is a builder for BACnetPropertyStatesState
type BACnetPropertyStatesStateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(state BACnetEventStateTagged) BACnetPropertyStatesStateBuilder
	// WithState adds State (property field)
	WithState(BACnetEventStateTagged) BACnetPropertyStatesStateBuilder
	// WithStateBuilder adds State (property field) which is build by the builder
	WithStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetPropertyStatesStateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesState or returns an error if something is wrong
	Build() (BACnetPropertyStatesState, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesState
}

// NewBACnetPropertyStatesStateBuilder() creates a BACnetPropertyStatesStateBuilder
func NewBACnetPropertyStatesStateBuilder() BACnetPropertyStatesStateBuilder {
	return &_BACnetPropertyStatesStateBuilder{_BACnetPropertyStatesState: new(_BACnetPropertyStatesState)}
}

type _BACnetPropertyStatesStateBuilder struct {
	*_BACnetPropertyStatesState

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesStateBuilder) = (*_BACnetPropertyStatesStateBuilder)(nil)

func (b *_BACnetPropertyStatesStateBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesState
}

func (b *_BACnetPropertyStatesStateBuilder) WithMandatoryFields(state BACnetEventStateTagged) BACnetPropertyStatesStateBuilder {
	return b.WithState(state)
}

func (b *_BACnetPropertyStatesStateBuilder) WithState(state BACnetEventStateTagged) BACnetPropertyStatesStateBuilder {
	b.State = state
	return b
}

func (b *_BACnetPropertyStatesStateBuilder) WithStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetPropertyStatesStateBuilder {
	builder := builderSupplier(b.State.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.State, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesStateBuilder) Build() (BACnetPropertyStatesState, error) {
	if b.State == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'state' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesState.deepCopy(), nil
}

func (b *_BACnetPropertyStatesStateBuilder) MustBuild() BACnetPropertyStatesState {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesStateBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesStateBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesStateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesStateBuilder().(*_BACnetPropertyStatesStateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesStateBuilder creates a BACnetPropertyStatesStateBuilder
func (b *_BACnetPropertyStatesState) CreateBACnetPropertyStatesStateBuilder() BACnetPropertyStatesStateBuilder {
	if b == nil {
		return NewBACnetPropertyStatesStateBuilder()
	}
	return &_BACnetPropertyStatesStateBuilder{_BACnetPropertyStatesState: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesState) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesState) GetState() BACnetEventStateTagged {
	return m.State
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesState(structType any) BACnetPropertyStatesState {
	if casted, ok := structType.(BACnetPropertyStatesState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesState) GetTypeName() string {
	return "BACnetPropertyStatesState"
}

func (m *_BACnetPropertyStatesState) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (state)
	lengthInBits += m.State.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesState) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesState BACnetPropertyStatesState, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	state, err := ReadSimpleField[BACnetEventStateTagged](ctx, "state", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'state' field"))
	}
	m.State = state

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesState")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesState")
		}

		if err := WriteSimpleField[BACnetEventStateTagged](ctx, "state", m.GetState(), WriteComplex[BACnetEventStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'state' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesState")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesState) IsBACnetPropertyStatesState() {}

func (m *_BACnetPropertyStatesState) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesState) deepCopy() *_BACnetPropertyStatesState {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesStateCopy := &_BACnetPropertyStatesState{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetEventStateTagged](m.State),
	}
	_BACnetPropertyStatesStateCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesStateCopy
}

func (m *_BACnetPropertyStatesState) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
