/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesSilencedState is the corresponding interface of BACnetPropertyStatesSilencedState
type BACnetPropertyStatesSilencedState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetSilencedState returns SilencedState (property field)
	GetSilencedState() BACnetSilencedStateTagged
	// IsBACnetPropertyStatesSilencedState is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesSilencedState()
	// CreateBuilder creates a BACnetPropertyStatesSilencedStateBuilder
	CreateBACnetPropertyStatesSilencedStateBuilder() BACnetPropertyStatesSilencedStateBuilder
}

// _BACnetPropertyStatesSilencedState is the data-structure of this message
type _BACnetPropertyStatesSilencedState struct {
	BACnetPropertyStatesContract
	SilencedState BACnetSilencedStateTagged
}

var _ BACnetPropertyStatesSilencedState = (*_BACnetPropertyStatesSilencedState)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesSilencedState)(nil)

// NewBACnetPropertyStatesSilencedState factory function for _BACnetPropertyStatesSilencedState
func NewBACnetPropertyStatesSilencedState(peekedTagHeader BACnetTagHeader, silencedState BACnetSilencedStateTagged) *_BACnetPropertyStatesSilencedState {
	if silencedState == nil {
		panic("silencedState of type BACnetSilencedStateTagged for BACnetPropertyStatesSilencedState must not be nil")
	}
	_result := &_BACnetPropertyStatesSilencedState{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		SilencedState:                silencedState,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesSilencedStateBuilder is a builder for BACnetPropertyStatesSilencedState
type BACnetPropertyStatesSilencedStateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(silencedState BACnetSilencedStateTagged) BACnetPropertyStatesSilencedStateBuilder
	// WithSilencedState adds SilencedState (property field)
	WithSilencedState(BACnetSilencedStateTagged) BACnetPropertyStatesSilencedStateBuilder
	// WithSilencedStateBuilder adds SilencedState (property field) which is build by the builder
	WithSilencedStateBuilder(func(BACnetSilencedStateTaggedBuilder) BACnetSilencedStateTaggedBuilder) BACnetPropertyStatesSilencedStateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesSilencedState or returns an error if something is wrong
	Build() (BACnetPropertyStatesSilencedState, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesSilencedState
}

// NewBACnetPropertyStatesSilencedStateBuilder() creates a BACnetPropertyStatesSilencedStateBuilder
func NewBACnetPropertyStatesSilencedStateBuilder() BACnetPropertyStatesSilencedStateBuilder {
	return &_BACnetPropertyStatesSilencedStateBuilder{_BACnetPropertyStatesSilencedState: new(_BACnetPropertyStatesSilencedState)}
}

type _BACnetPropertyStatesSilencedStateBuilder struct {
	*_BACnetPropertyStatesSilencedState

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesSilencedStateBuilder) = (*_BACnetPropertyStatesSilencedStateBuilder)(nil)

func (b *_BACnetPropertyStatesSilencedStateBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesSilencedState
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) WithMandatoryFields(silencedState BACnetSilencedStateTagged) BACnetPropertyStatesSilencedStateBuilder {
	return b.WithSilencedState(silencedState)
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) WithSilencedState(silencedState BACnetSilencedStateTagged) BACnetPropertyStatesSilencedStateBuilder {
	b.SilencedState = silencedState
	return b
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) WithSilencedStateBuilder(builderSupplier func(BACnetSilencedStateTaggedBuilder) BACnetSilencedStateTaggedBuilder) BACnetPropertyStatesSilencedStateBuilder {
	builder := builderSupplier(b.SilencedState.CreateBACnetSilencedStateTaggedBuilder())
	var err error
	b.SilencedState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetSilencedStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) Build() (BACnetPropertyStatesSilencedState, error) {
	if b.SilencedState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'silencedState' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesSilencedState.deepCopy(), nil
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) MustBuild() BACnetPropertyStatesSilencedState {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesSilencedStateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesSilencedStateBuilder().(*_BACnetPropertyStatesSilencedStateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesSilencedStateBuilder creates a BACnetPropertyStatesSilencedStateBuilder
func (b *_BACnetPropertyStatesSilencedState) CreateBACnetPropertyStatesSilencedStateBuilder() BACnetPropertyStatesSilencedStateBuilder {
	if b == nil {
		return NewBACnetPropertyStatesSilencedStateBuilder()
	}
	return &_BACnetPropertyStatesSilencedStateBuilder{_BACnetPropertyStatesSilencedState: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesSilencedState) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesSilencedState) GetSilencedState() BACnetSilencedStateTagged {
	return m.SilencedState
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesSilencedState(structType any) BACnetPropertyStatesSilencedState {
	if casted, ok := structType.(BACnetPropertyStatesSilencedState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesSilencedState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesSilencedState) GetTypeName() string {
	return "BACnetPropertyStatesSilencedState"
}

func (m *_BACnetPropertyStatesSilencedState) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (silencedState)
	lengthInBits += m.SilencedState.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesSilencedState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesSilencedState) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesSilencedState BACnetPropertyStatesSilencedState, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesSilencedState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesSilencedState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	silencedState, err := ReadSimpleField[BACnetSilencedStateTagged](ctx, "silencedState", ReadComplex[BACnetSilencedStateTagged](BACnetSilencedStateTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'silencedState' field"))
	}
	m.SilencedState = silencedState

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesSilencedState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesSilencedState")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesSilencedState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesSilencedState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesSilencedState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesSilencedState")
		}

		if err := WriteSimpleField[BACnetSilencedStateTagged](ctx, "silencedState", m.GetSilencedState(), WriteComplex[BACnetSilencedStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'silencedState' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesSilencedState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesSilencedState")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesSilencedState) IsBACnetPropertyStatesSilencedState() {}

func (m *_BACnetPropertyStatesSilencedState) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesSilencedState) deepCopy() *_BACnetPropertyStatesSilencedState {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesSilencedStateCopy := &_BACnetPropertyStatesSilencedState{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetSilencedStateTagged](m.SilencedState),
	}
	_BACnetPropertyStatesSilencedStateCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesSilencedStateCopy
}

func (m *_BACnetPropertyStatesSilencedState) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
