/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesFileAccessMethod is the corresponding interface of BACnetPropertyStatesFileAccessMethod
type BACnetPropertyStatesFileAccessMethod interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetFileAccessMethod returns FileAccessMethod (property field)
	GetFileAccessMethod() BACnetFileAccessMethodTagged
	// IsBACnetPropertyStatesFileAccessMethod is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesFileAccessMethod()
	// CreateBuilder creates a BACnetPropertyStatesFileAccessMethodBuilder
	CreateBACnetPropertyStatesFileAccessMethodBuilder() BACnetPropertyStatesFileAccessMethodBuilder
}

// _BACnetPropertyStatesFileAccessMethod is the data-structure of this message
type _BACnetPropertyStatesFileAccessMethod struct {
	BACnetPropertyStatesContract
	FileAccessMethod BACnetFileAccessMethodTagged
}

var _ BACnetPropertyStatesFileAccessMethod = (*_BACnetPropertyStatesFileAccessMethod)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesFileAccessMethod)(nil)

// NewBACnetPropertyStatesFileAccessMethod factory function for _BACnetPropertyStatesFileAccessMethod
func NewBACnetPropertyStatesFileAccessMethod(peekedTagHeader BACnetTagHeader, fileAccessMethod BACnetFileAccessMethodTagged) *_BACnetPropertyStatesFileAccessMethod {
	if fileAccessMethod == nil {
		panic("fileAccessMethod of type BACnetFileAccessMethodTagged for BACnetPropertyStatesFileAccessMethod must not be nil")
	}
	_result := &_BACnetPropertyStatesFileAccessMethod{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		FileAccessMethod:             fileAccessMethod,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesFileAccessMethodBuilder is a builder for BACnetPropertyStatesFileAccessMethod
type BACnetPropertyStatesFileAccessMethodBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(fileAccessMethod BACnetFileAccessMethodTagged) BACnetPropertyStatesFileAccessMethodBuilder
	// WithFileAccessMethod adds FileAccessMethod (property field)
	WithFileAccessMethod(BACnetFileAccessMethodTagged) BACnetPropertyStatesFileAccessMethodBuilder
	// WithFileAccessMethodBuilder adds FileAccessMethod (property field) which is build by the builder
	WithFileAccessMethodBuilder(func(BACnetFileAccessMethodTaggedBuilder) BACnetFileAccessMethodTaggedBuilder) BACnetPropertyStatesFileAccessMethodBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesFileAccessMethod or returns an error if something is wrong
	Build() (BACnetPropertyStatesFileAccessMethod, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesFileAccessMethod
}

// NewBACnetPropertyStatesFileAccessMethodBuilder() creates a BACnetPropertyStatesFileAccessMethodBuilder
func NewBACnetPropertyStatesFileAccessMethodBuilder() BACnetPropertyStatesFileAccessMethodBuilder {
	return &_BACnetPropertyStatesFileAccessMethodBuilder{_BACnetPropertyStatesFileAccessMethod: new(_BACnetPropertyStatesFileAccessMethod)}
}

type _BACnetPropertyStatesFileAccessMethodBuilder struct {
	*_BACnetPropertyStatesFileAccessMethod

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesFileAccessMethodBuilder) = (*_BACnetPropertyStatesFileAccessMethodBuilder)(nil)

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesFileAccessMethod
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) WithMandatoryFields(fileAccessMethod BACnetFileAccessMethodTagged) BACnetPropertyStatesFileAccessMethodBuilder {
	return b.WithFileAccessMethod(fileAccessMethod)
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) WithFileAccessMethod(fileAccessMethod BACnetFileAccessMethodTagged) BACnetPropertyStatesFileAccessMethodBuilder {
	b.FileAccessMethod = fileAccessMethod
	return b
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) WithFileAccessMethodBuilder(builderSupplier func(BACnetFileAccessMethodTaggedBuilder) BACnetFileAccessMethodTaggedBuilder) BACnetPropertyStatesFileAccessMethodBuilder {
	builder := builderSupplier(b.FileAccessMethod.CreateBACnetFileAccessMethodTaggedBuilder())
	var err error
	b.FileAccessMethod, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetFileAccessMethodTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) Build() (BACnetPropertyStatesFileAccessMethod, error) {
	if b.FileAccessMethod == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'fileAccessMethod' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesFileAccessMethod.deepCopy(), nil
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) MustBuild() BACnetPropertyStatesFileAccessMethod {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesFileAccessMethodBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesFileAccessMethodBuilder().(*_BACnetPropertyStatesFileAccessMethodBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesFileAccessMethodBuilder creates a BACnetPropertyStatesFileAccessMethodBuilder
func (b *_BACnetPropertyStatesFileAccessMethod) CreateBACnetPropertyStatesFileAccessMethodBuilder() BACnetPropertyStatesFileAccessMethodBuilder {
	if b == nil {
		return NewBACnetPropertyStatesFileAccessMethodBuilder()
	}
	return &_BACnetPropertyStatesFileAccessMethodBuilder{_BACnetPropertyStatesFileAccessMethod: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesFileAccessMethod) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesFileAccessMethod) GetFileAccessMethod() BACnetFileAccessMethodTagged {
	return m.FileAccessMethod
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesFileAccessMethod(structType any) BACnetPropertyStatesFileAccessMethod {
	if casted, ok := structType.(BACnetPropertyStatesFileAccessMethod); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesFileAccessMethod); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesFileAccessMethod) GetTypeName() string {
	return "BACnetPropertyStatesFileAccessMethod"
}

func (m *_BACnetPropertyStatesFileAccessMethod) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (fileAccessMethod)
	lengthInBits += m.FileAccessMethod.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesFileAccessMethod) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesFileAccessMethod) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesFileAccessMethod BACnetPropertyStatesFileAccessMethod, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesFileAccessMethod"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesFileAccessMethod")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	fileAccessMethod, err := ReadSimpleField[BACnetFileAccessMethodTagged](ctx, "fileAccessMethod", ReadComplex[BACnetFileAccessMethodTagged](BACnetFileAccessMethodTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fileAccessMethod' field"))
	}
	m.FileAccessMethod = fileAccessMethod

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesFileAccessMethod"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesFileAccessMethod")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesFileAccessMethod) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesFileAccessMethod) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesFileAccessMethod"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesFileAccessMethod")
		}

		if err := WriteSimpleField[BACnetFileAccessMethodTagged](ctx, "fileAccessMethod", m.GetFileAccessMethod(), WriteComplex[BACnetFileAccessMethodTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'fileAccessMethod' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesFileAccessMethod"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesFileAccessMethod")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesFileAccessMethod) IsBACnetPropertyStatesFileAccessMethod() {}

func (m *_BACnetPropertyStatesFileAccessMethod) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesFileAccessMethod) deepCopy() *_BACnetPropertyStatesFileAccessMethod {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesFileAccessMethodCopy := &_BACnetPropertyStatesFileAccessMethod{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetFileAccessMethodTagged](m.FileAccessMethod),
	}
	_BACnetPropertyStatesFileAccessMethodCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesFileAccessMethodCopy
}

func (m *_BACnetPropertyStatesFileAccessMethod) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
