/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesEscalatorFault is the corresponding interface of BACnetPropertyStatesEscalatorFault
type BACnetPropertyStatesEscalatorFault interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetEscalatorFault returns EscalatorFault (property field)
	GetEscalatorFault() BACnetEscalatorFaultTagged
	// IsBACnetPropertyStatesEscalatorFault is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesEscalatorFault()
	// CreateBuilder creates a BACnetPropertyStatesEscalatorFaultBuilder
	CreateBACnetPropertyStatesEscalatorFaultBuilder() BACnetPropertyStatesEscalatorFaultBuilder
}

// _BACnetPropertyStatesEscalatorFault is the data-structure of this message
type _BACnetPropertyStatesEscalatorFault struct {
	BACnetPropertyStatesContract
	EscalatorFault BACnetEscalatorFaultTagged
}

var _ BACnetPropertyStatesEscalatorFault = (*_BACnetPropertyStatesEscalatorFault)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesEscalatorFault)(nil)

// NewBACnetPropertyStatesEscalatorFault factory function for _BACnetPropertyStatesEscalatorFault
func NewBACnetPropertyStatesEscalatorFault(peekedTagHeader BACnetTagHeader, escalatorFault BACnetEscalatorFaultTagged) *_BACnetPropertyStatesEscalatorFault {
	if escalatorFault == nil {
		panic("escalatorFault of type BACnetEscalatorFaultTagged for BACnetPropertyStatesEscalatorFault must not be nil")
	}
	_result := &_BACnetPropertyStatesEscalatorFault{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		EscalatorFault:               escalatorFault,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesEscalatorFaultBuilder is a builder for BACnetPropertyStatesEscalatorFault
type BACnetPropertyStatesEscalatorFaultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(escalatorFault BACnetEscalatorFaultTagged) BACnetPropertyStatesEscalatorFaultBuilder
	// WithEscalatorFault adds EscalatorFault (property field)
	WithEscalatorFault(BACnetEscalatorFaultTagged) BACnetPropertyStatesEscalatorFaultBuilder
	// WithEscalatorFaultBuilder adds EscalatorFault (property field) which is build by the builder
	WithEscalatorFaultBuilder(func(BACnetEscalatorFaultTaggedBuilder) BACnetEscalatorFaultTaggedBuilder) BACnetPropertyStatesEscalatorFaultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesEscalatorFault or returns an error if something is wrong
	Build() (BACnetPropertyStatesEscalatorFault, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesEscalatorFault
}

// NewBACnetPropertyStatesEscalatorFaultBuilder() creates a BACnetPropertyStatesEscalatorFaultBuilder
func NewBACnetPropertyStatesEscalatorFaultBuilder() BACnetPropertyStatesEscalatorFaultBuilder {
	return &_BACnetPropertyStatesEscalatorFaultBuilder{_BACnetPropertyStatesEscalatorFault: new(_BACnetPropertyStatesEscalatorFault)}
}

type _BACnetPropertyStatesEscalatorFaultBuilder struct {
	*_BACnetPropertyStatesEscalatorFault

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesEscalatorFaultBuilder) = (*_BACnetPropertyStatesEscalatorFaultBuilder)(nil)

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesEscalatorFault
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) WithMandatoryFields(escalatorFault BACnetEscalatorFaultTagged) BACnetPropertyStatesEscalatorFaultBuilder {
	return b.WithEscalatorFault(escalatorFault)
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) WithEscalatorFault(escalatorFault BACnetEscalatorFaultTagged) BACnetPropertyStatesEscalatorFaultBuilder {
	b.EscalatorFault = escalatorFault
	return b
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) WithEscalatorFaultBuilder(builderSupplier func(BACnetEscalatorFaultTaggedBuilder) BACnetEscalatorFaultTaggedBuilder) BACnetPropertyStatesEscalatorFaultBuilder {
	builder := builderSupplier(b.EscalatorFault.CreateBACnetEscalatorFaultTaggedBuilder())
	var err error
	b.EscalatorFault, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEscalatorFaultTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) Build() (BACnetPropertyStatesEscalatorFault, error) {
	if b.EscalatorFault == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'escalatorFault' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesEscalatorFault.deepCopy(), nil
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) MustBuild() BACnetPropertyStatesEscalatorFault {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesEscalatorFaultBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesEscalatorFaultBuilder().(*_BACnetPropertyStatesEscalatorFaultBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesEscalatorFaultBuilder creates a BACnetPropertyStatesEscalatorFaultBuilder
func (b *_BACnetPropertyStatesEscalatorFault) CreateBACnetPropertyStatesEscalatorFaultBuilder() BACnetPropertyStatesEscalatorFaultBuilder {
	if b == nil {
		return NewBACnetPropertyStatesEscalatorFaultBuilder()
	}
	return &_BACnetPropertyStatesEscalatorFaultBuilder{_BACnetPropertyStatesEscalatorFault: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesEscalatorFault) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesEscalatorFault) GetEscalatorFault() BACnetEscalatorFaultTagged {
	return m.EscalatorFault
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesEscalatorFault(structType any) BACnetPropertyStatesEscalatorFault {
	if casted, ok := structType.(BACnetPropertyStatesEscalatorFault); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesEscalatorFault); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesEscalatorFault) GetTypeName() string {
	return "BACnetPropertyStatesEscalatorFault"
}

func (m *_BACnetPropertyStatesEscalatorFault) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (escalatorFault)
	lengthInBits += m.EscalatorFault.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesEscalatorFault) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesEscalatorFault) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesEscalatorFault BACnetPropertyStatesEscalatorFault, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesEscalatorFault"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesEscalatorFault")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	escalatorFault, err := ReadSimpleField[BACnetEscalatorFaultTagged](ctx, "escalatorFault", ReadComplex[BACnetEscalatorFaultTagged](BACnetEscalatorFaultTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'escalatorFault' field"))
	}
	m.EscalatorFault = escalatorFault

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesEscalatorFault"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesEscalatorFault")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesEscalatorFault) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesEscalatorFault) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesEscalatorFault"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesEscalatorFault")
		}

		if err := WriteSimpleField[BACnetEscalatorFaultTagged](ctx, "escalatorFault", m.GetEscalatorFault(), WriteComplex[BACnetEscalatorFaultTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'escalatorFault' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesEscalatorFault"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesEscalatorFault")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesEscalatorFault) IsBACnetPropertyStatesEscalatorFault() {}

func (m *_BACnetPropertyStatesEscalatorFault) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesEscalatorFault) deepCopy() *_BACnetPropertyStatesEscalatorFault {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesEscalatorFaultCopy := &_BACnetPropertyStatesEscalatorFault{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetEscalatorFaultTagged](m.EscalatorFault),
	}
	_BACnetPropertyStatesEscalatorFaultCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesEscalatorFaultCopy
}

func (m *_BACnetPropertyStatesEscalatorFault) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
