/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesEnclosed is the corresponding interface of BACnetPropertyStatesEnclosed
type BACnetPropertyStatesEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPropertyState returns PropertyState (property field)
	GetPropertyState() BACnetPropertyStates
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetPropertyStatesEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesEnclosed()
	// CreateBuilder creates a BACnetPropertyStatesEnclosedBuilder
	CreateBACnetPropertyStatesEnclosedBuilder() BACnetPropertyStatesEnclosedBuilder
}

// _BACnetPropertyStatesEnclosed is the data-structure of this message
type _BACnetPropertyStatesEnclosed struct {
	OpeningTag    BACnetOpeningTag
	PropertyState BACnetPropertyStates
	ClosingTag    BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetPropertyStatesEnclosed = (*_BACnetPropertyStatesEnclosed)(nil)

// NewBACnetPropertyStatesEnclosed factory function for _BACnetPropertyStatesEnclosed
func NewBACnetPropertyStatesEnclosed(openingTag BACnetOpeningTag, propertyState BACnetPropertyStates, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetPropertyStatesEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetPropertyStatesEnclosed must not be nil")
	}
	if propertyState == nil {
		panic("propertyState of type BACnetPropertyStates for BACnetPropertyStatesEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetPropertyStatesEnclosed must not be nil")
	}
	return &_BACnetPropertyStatesEnclosed{OpeningTag: openingTag, PropertyState: propertyState, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesEnclosedBuilder is a builder for BACnetPropertyStatesEnclosed
type BACnetPropertyStatesEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, propertyState BACnetPropertyStates, closingTag BACnetClosingTag) BACnetPropertyStatesEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetPropertyStatesEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetPropertyStatesEnclosedBuilder
	// WithPropertyState adds PropertyState (property field)
	WithPropertyState(BACnetPropertyStates) BACnetPropertyStatesEnclosedBuilder
	// WithPropertyStateBuilder adds PropertyState (property field) which is build by the builder
	WithPropertyStateBuilder(func(BACnetPropertyStatesBuilder) BACnetPropertyStatesBuilder) BACnetPropertyStatesEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetPropertyStatesEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetPropertyStatesEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetPropertyStatesEnclosedBuilder
	// Build builds the BACnetPropertyStatesEnclosed or returns an error if something is wrong
	Build() (BACnetPropertyStatesEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesEnclosed
}

// NewBACnetPropertyStatesEnclosedBuilder() creates a BACnetPropertyStatesEnclosedBuilder
func NewBACnetPropertyStatesEnclosedBuilder() BACnetPropertyStatesEnclosedBuilder {
	return &_BACnetPropertyStatesEnclosedBuilder{_BACnetPropertyStatesEnclosed: new(_BACnetPropertyStatesEnclosed)}
}

type _BACnetPropertyStatesEnclosedBuilder struct {
	*_BACnetPropertyStatesEnclosed

	err *utils.MultiError
}

var _ (BACnetPropertyStatesEnclosedBuilder) = (*_BACnetPropertyStatesEnclosedBuilder)(nil)

func (b *_BACnetPropertyStatesEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, propertyState BACnetPropertyStates, closingTag BACnetClosingTag) BACnetPropertyStatesEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithPropertyState(propertyState).WithClosingTag(closingTag)
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetPropertyStatesEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetPropertyStatesEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithPropertyState(propertyState BACnetPropertyStates) BACnetPropertyStatesEnclosedBuilder {
	b.PropertyState = propertyState
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithPropertyStateBuilder(builderSupplier func(BACnetPropertyStatesBuilder) BACnetPropertyStatesBuilder) BACnetPropertyStatesEnclosedBuilder {
	builder := builderSupplier(b.PropertyState.CreateBACnetPropertyStatesBuilder())
	var err error
	b.PropertyState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetPropertyStatesBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetPropertyStatesEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetPropertyStatesEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetPropertyStatesEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetPropertyStatesEnclosedBuilder) Build() (BACnetPropertyStatesEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PropertyState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'propertyState' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesEnclosed.deepCopy(), nil
}

func (b *_BACnetPropertyStatesEnclosedBuilder) MustBuild() BACnetPropertyStatesEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesEnclosedBuilder().(*_BACnetPropertyStatesEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesEnclosedBuilder creates a BACnetPropertyStatesEnclosedBuilder
func (b *_BACnetPropertyStatesEnclosed) CreateBACnetPropertyStatesEnclosedBuilder() BACnetPropertyStatesEnclosedBuilder {
	if b == nil {
		return NewBACnetPropertyStatesEnclosedBuilder()
	}
	return &_BACnetPropertyStatesEnclosedBuilder{_BACnetPropertyStatesEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetPropertyStatesEnclosed) GetPropertyState() BACnetPropertyStates {
	return m.PropertyState
}

func (m *_BACnetPropertyStatesEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesEnclosed(structType any) BACnetPropertyStatesEnclosed {
	if casted, ok := structType.(BACnetPropertyStatesEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesEnclosed) GetTypeName() string {
	return "BACnetPropertyStatesEnclosed"
}

func (m *_BACnetPropertyStatesEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (propertyState)
	lengthInBits += m.PropertyState.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetPropertyStatesEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetPropertyStatesEnclosed, error) {
	return BACnetPropertyStatesEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetPropertyStatesEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPropertyStatesEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPropertyStatesEnclosed, error) {
		return BACnetPropertyStatesEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetPropertyStatesEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetPropertyStatesEnclosed, error) {
	v, err := (&_BACnetPropertyStatesEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetPropertyStatesEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetPropertyStatesEnclosed BACnetPropertyStatesEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	propertyState, err := ReadSimpleField[BACnetPropertyStates](ctx, "propertyState", ReadComplex[BACnetPropertyStates](BACnetPropertyStatesParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyState' field"))
	}
	m.PropertyState = propertyState

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesEnclosed")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetPropertyStatesEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetPropertyStates](ctx, "propertyState", m.GetPropertyState(), WriteComplex[BACnetPropertyStates](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'propertyState' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetPropertyStatesEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetPropertyStatesEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetPropertyStatesEnclosed) IsBACnetPropertyStatesEnclosed() {}

func (m *_BACnetPropertyStatesEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesEnclosed) deepCopy() *_BACnetPropertyStatesEnclosed {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesEnclosedCopy := &_BACnetPropertyStatesEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetPropertyStates](m.PropertyState),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetPropertyStatesEnclosedCopy
}

func (m *_BACnetPropertyStatesEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
