/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesAuthenticationStatus is the corresponding interface of BACnetPropertyStatesAuthenticationStatus
type BACnetPropertyStatesAuthenticationStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetAuthenticationStatus returns AuthenticationStatus (property field)
	GetAuthenticationStatus() BACnetAuthenticationStatusTagged
	// IsBACnetPropertyStatesAuthenticationStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesAuthenticationStatus()
	// CreateBuilder creates a BACnetPropertyStatesAuthenticationStatusBuilder
	CreateBACnetPropertyStatesAuthenticationStatusBuilder() BACnetPropertyStatesAuthenticationStatusBuilder
}

// _BACnetPropertyStatesAuthenticationStatus is the data-structure of this message
type _BACnetPropertyStatesAuthenticationStatus struct {
	BACnetPropertyStatesContract
	AuthenticationStatus BACnetAuthenticationStatusTagged
}

var _ BACnetPropertyStatesAuthenticationStatus = (*_BACnetPropertyStatesAuthenticationStatus)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesAuthenticationStatus)(nil)

// NewBACnetPropertyStatesAuthenticationStatus factory function for _BACnetPropertyStatesAuthenticationStatus
func NewBACnetPropertyStatesAuthenticationStatus(peekedTagHeader BACnetTagHeader, authenticationStatus BACnetAuthenticationStatusTagged) *_BACnetPropertyStatesAuthenticationStatus {
	if authenticationStatus == nil {
		panic("authenticationStatus of type BACnetAuthenticationStatusTagged for BACnetPropertyStatesAuthenticationStatus must not be nil")
	}
	_result := &_BACnetPropertyStatesAuthenticationStatus{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		AuthenticationStatus:         authenticationStatus,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesAuthenticationStatusBuilder is a builder for BACnetPropertyStatesAuthenticationStatus
type BACnetPropertyStatesAuthenticationStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(authenticationStatus BACnetAuthenticationStatusTagged) BACnetPropertyStatesAuthenticationStatusBuilder
	// WithAuthenticationStatus adds AuthenticationStatus (property field)
	WithAuthenticationStatus(BACnetAuthenticationStatusTagged) BACnetPropertyStatesAuthenticationStatusBuilder
	// WithAuthenticationStatusBuilder adds AuthenticationStatus (property field) which is build by the builder
	WithAuthenticationStatusBuilder(func(BACnetAuthenticationStatusTaggedBuilder) BACnetAuthenticationStatusTaggedBuilder) BACnetPropertyStatesAuthenticationStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesAuthenticationStatus or returns an error if something is wrong
	Build() (BACnetPropertyStatesAuthenticationStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesAuthenticationStatus
}

// NewBACnetPropertyStatesAuthenticationStatusBuilder() creates a BACnetPropertyStatesAuthenticationStatusBuilder
func NewBACnetPropertyStatesAuthenticationStatusBuilder() BACnetPropertyStatesAuthenticationStatusBuilder {
	return &_BACnetPropertyStatesAuthenticationStatusBuilder{_BACnetPropertyStatesAuthenticationStatus: new(_BACnetPropertyStatesAuthenticationStatus)}
}

type _BACnetPropertyStatesAuthenticationStatusBuilder struct {
	*_BACnetPropertyStatesAuthenticationStatus

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesAuthenticationStatusBuilder) = (*_BACnetPropertyStatesAuthenticationStatusBuilder)(nil)

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesAuthenticationStatus
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) WithMandatoryFields(authenticationStatus BACnetAuthenticationStatusTagged) BACnetPropertyStatesAuthenticationStatusBuilder {
	return b.WithAuthenticationStatus(authenticationStatus)
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) WithAuthenticationStatus(authenticationStatus BACnetAuthenticationStatusTagged) BACnetPropertyStatesAuthenticationStatusBuilder {
	b.AuthenticationStatus = authenticationStatus
	return b
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) WithAuthenticationStatusBuilder(builderSupplier func(BACnetAuthenticationStatusTaggedBuilder) BACnetAuthenticationStatusTaggedBuilder) BACnetPropertyStatesAuthenticationStatusBuilder {
	builder := builderSupplier(b.AuthenticationStatus.CreateBACnetAuthenticationStatusTaggedBuilder())
	var err error
	b.AuthenticationStatus, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAuthenticationStatusTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) Build() (BACnetPropertyStatesAuthenticationStatus, error) {
	if b.AuthenticationStatus == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'authenticationStatus' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesAuthenticationStatus.deepCopy(), nil
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) MustBuild() BACnetPropertyStatesAuthenticationStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesAuthenticationStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesAuthenticationStatusBuilder().(*_BACnetPropertyStatesAuthenticationStatusBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesAuthenticationStatusBuilder creates a BACnetPropertyStatesAuthenticationStatusBuilder
func (b *_BACnetPropertyStatesAuthenticationStatus) CreateBACnetPropertyStatesAuthenticationStatusBuilder() BACnetPropertyStatesAuthenticationStatusBuilder {
	if b == nil {
		return NewBACnetPropertyStatesAuthenticationStatusBuilder()
	}
	return &_BACnetPropertyStatesAuthenticationStatusBuilder{_BACnetPropertyStatesAuthenticationStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesAuthenticationStatus) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesAuthenticationStatus) GetAuthenticationStatus() BACnetAuthenticationStatusTagged {
	return m.AuthenticationStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesAuthenticationStatus(structType any) BACnetPropertyStatesAuthenticationStatus {
	if casted, ok := structType.(BACnetPropertyStatesAuthenticationStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesAuthenticationStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesAuthenticationStatus) GetTypeName() string {
	return "BACnetPropertyStatesAuthenticationStatus"
}

func (m *_BACnetPropertyStatesAuthenticationStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (authenticationStatus)
	lengthInBits += m.AuthenticationStatus.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesAuthenticationStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesAuthenticationStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesAuthenticationStatus BACnetPropertyStatesAuthenticationStatus, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesAuthenticationStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesAuthenticationStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	authenticationStatus, err := ReadSimpleField[BACnetAuthenticationStatusTagged](ctx, "authenticationStatus", ReadComplex[BACnetAuthenticationStatusTagged](BACnetAuthenticationStatusTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authenticationStatus' field"))
	}
	m.AuthenticationStatus = authenticationStatus

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesAuthenticationStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesAuthenticationStatus")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesAuthenticationStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesAuthenticationStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesAuthenticationStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesAuthenticationStatus")
		}

		if err := WriteSimpleField[BACnetAuthenticationStatusTagged](ctx, "authenticationStatus", m.GetAuthenticationStatus(), WriteComplex[BACnetAuthenticationStatusTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'authenticationStatus' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesAuthenticationStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesAuthenticationStatus")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesAuthenticationStatus) IsBACnetPropertyStatesAuthenticationStatus() {}

func (m *_BACnetPropertyStatesAuthenticationStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesAuthenticationStatus) deepCopy() *_BACnetPropertyStatesAuthenticationStatus {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesAuthenticationStatusCopy := &_BACnetPropertyStatesAuthenticationStatus{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetAuthenticationStatusTagged](m.AuthenticationStatus),
	}
	_BACnetPropertyStatesAuthenticationStatusCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesAuthenticationStatusCopy
}

func (m *_BACnetPropertyStatesAuthenticationStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
