/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStates is the corresponding interface of BACnetPropertyStates
type BACnetPropertyStates interface {
	BACnetPropertyStatesContract
	BACnetPropertyStatesRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetPropertyStates is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStates()
	// CreateBuilder creates a BACnetPropertyStatesBuilder
	CreateBACnetPropertyStatesBuilder() BACnetPropertyStatesBuilder
}

// BACnetPropertyStatesContract provides a set of functions which can be overwritten by a sub struct
type BACnetPropertyStatesContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetPropertyStates is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStates()
	// CreateBuilder creates a BACnetPropertyStatesBuilder
	CreateBACnetPropertyStatesBuilder() BACnetPropertyStatesBuilder
}

// BACnetPropertyStatesRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetPropertyStatesRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetPropertyStates is the data-structure of this message
type _BACnetPropertyStates struct {
	_SubType interface {
		BACnetPropertyStatesContract
		BACnetPropertyStatesRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetPropertyStatesContract = (*_BACnetPropertyStates)(nil)

// NewBACnetPropertyStates factory function for _BACnetPropertyStates
func NewBACnetPropertyStates(peekedTagHeader BACnetTagHeader) *_BACnetPropertyStates {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetPropertyStates must not be nil")
	}
	return &_BACnetPropertyStates{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesBuilder is a builder for BACnetPropertyStates
type BACnetPropertyStatesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetPropertyStatesBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetPropertyStatesBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetPropertyStatesBuilder
	// AsBACnetPropertyStatesBoolean converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesBoolean() BACnetPropertyStatesBooleanBuilder
	// AsBACnetPropertyStatesBinaryValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesBinaryValue() BACnetPropertyStatesBinaryValueBuilder
	// AsBACnetPropertyStatesEventType converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesEventType() BACnetPropertyStatesEventTypeBuilder
	// AsBACnetPropertyStatesPolarity converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesPolarity() BACnetPropertyStatesPolarityBuilder
	// AsBACnetPropertyStatesProgramChange converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesProgramChange() BACnetPropertyStatesProgramChangeBuilder
	// AsBACnetPropertyStatesProgramState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesProgramState() BACnetPropertyStatesProgramStateBuilder
	// AsBACnetPropertyStatesReasonForHalt converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesReasonForHalt() BACnetPropertyStatesReasonForHaltBuilder
	// AsBACnetPropertyStatesReliability converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesReliability() BACnetPropertyStatesReliabilityBuilder
	// AsBACnetPropertyStatesState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesState() BACnetPropertyStatesStateBuilder
	// AsBACnetPropertyStatesSystemStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesSystemStatus() BACnetPropertyStatesSystemStatusBuilder
	// AsBACnetPropertyStatesUnits converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesUnits() BACnetPropertyStatesUnitsBuilder
	// AsBACnetPropertyStatesUnsignedValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesUnsignedValue() BACnetPropertyStatesUnsignedValueBuilder
	// AsBACnetPropertyStatesLifeSafetyMode converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLifeSafetyMode() BACnetPropertyStatesLifeSafetyModeBuilder
	// AsBACnetPropertyStatesLifeSafetyState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLifeSafetyState() BACnetPropertyStatesLifeSafetyStateBuilder
	// AsBACnetPropertyStatesRestartReason converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesRestartReason() BACnetPropertyStatesRestartReasonBuilder
	// AsBACnetPropertyStatesDoorAlarmState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesDoorAlarmState() BACnetPropertyStatesDoorAlarmStateBuilder
	// AsBACnetPropertyStatesAction converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesAction() BACnetPropertyStatesActionBuilder
	// AsBACnetPropertyStatesDoorSecuredStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesDoorSecuredStatus() BACnetPropertyStatesDoorSecuredStatusBuilder
	// AsBACnetPropertyStatesDoorStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesDoorStatus() BACnetPropertyStatesDoorStatusBuilder
	// AsBACnetPropertyStatesDoorValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesDoorValue() BACnetPropertyStatesDoorValueBuilder
	// AsBACnetPropertyStatesFileAccessMethod converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesFileAccessMethod() BACnetPropertyStatesFileAccessMethodBuilder
	// AsBACnetPropertyStatesLockStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLockStatus() BACnetPropertyStatesLockStatusBuilder
	// AsBACnetPropertyStatesLifeSafetyOperations converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLifeSafetyOperations() BACnetPropertyStatesLifeSafetyOperationsBuilder
	// AsBACnetPropertyStatesMaintenance converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesMaintenance() BACnetPropertyStatesMaintenanceBuilder
	// AsBACnetPropertyStatesNodeType converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesNodeType() BACnetPropertyStatesNodeTypeBuilder
	// AsBACnetPropertyStatesNotifyType converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesNotifyType() BACnetPropertyStatesNotifyTypeBuilder
	// AsBACnetPropertyStatesSecurityLevel converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesSecurityLevel() BACnetPropertyStatesSecurityLevelBuilder
	// AsBACnetPropertyStatesShedState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesShedState() BACnetPropertyStatesShedStateBuilder
	// AsBACnetPropertyStatesSilencedState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesSilencedState() BACnetPropertyStatesSilencedStateBuilder
	// AsBACnetPropertyStatesAccessEvent converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesAccessEvent() BACnetPropertyStatesAccessEventBuilder
	// AsBACnetPropertyStatesZoneOccupanyState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesZoneOccupanyState() BACnetPropertyStatesZoneOccupanyStateBuilder
	// AsBACnetPropertyStatesAccessCredentialDisableReason converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesAccessCredentialDisableReason() BACnetPropertyStatesAccessCredentialDisableReasonBuilder
	// AsBACnetPropertyStatesAccessCredentialDisable converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesAccessCredentialDisable() BACnetPropertyStatesAccessCredentialDisableBuilder
	// AsBACnetPropertyStatesAuthenticationStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesAuthenticationStatus() BACnetPropertyStatesAuthenticationStatusBuilder
	// AsBACnetPropertyStatesBackupState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesBackupState() BACnetPropertyStatesBackupStateBuilder
	// AsBACnetPropertyStatesWriteStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesWriteStatus() BACnetPropertyStatesWriteStatusBuilder
	// AsBACnetPropertyStatesLightningInProgress converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLightningInProgress() BACnetPropertyStatesLightningInProgressBuilder
	// AsBACnetPropertyStatesLightningOperation converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLightningOperation() BACnetPropertyStatesLightningOperationBuilder
	// AsBACnetPropertyStatesLightningTransition converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLightningTransition() BACnetPropertyStatesLightningTransitionBuilder
	// AsBACnetPropertyStatesIntegerValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesIntegerValue() BACnetPropertyStatesIntegerValueBuilder
	// AsBACnetPropertyStatesBinaryLightningValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesBinaryLightningValue() BACnetPropertyStatesBinaryLightningValueBuilder
	// AsBACnetPropertyStatesTimerState converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesTimerState() BACnetPropertyStatesTimerStateBuilder
	// AsBACnetPropertyStatesTimerTransition converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesTimerTransition() BACnetPropertyStatesTimerTransitionBuilder
	// AsBACnetPropertyStatesBacnetIpMode converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesBacnetIpMode() BACnetPropertyStatesBacnetIpModeBuilder
	// AsBACnetPropertyStatesNetworkPortCommand converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesNetworkPortCommand() BACnetPropertyStatesNetworkPortCommandBuilder
	// AsBACnetPropertyStatesNetworkType converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesNetworkType() BACnetPropertyStatesNetworkTypeBuilder
	// AsBACnetPropertyStatesNetworkNumberQuality converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesNetworkNumberQuality() BACnetPropertyStatesNetworkNumberQualityBuilder
	// AsBACnetPropertyStatesEscalatorOperationDirection converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesEscalatorOperationDirection() BACnetPropertyStatesEscalatorOperationDirectionBuilder
	// AsBACnetPropertyStatesEscalatorFault converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesEscalatorFault() BACnetPropertyStatesEscalatorFaultBuilder
	// AsBACnetPropertyStatesEscalatorMode converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesEscalatorMode() BACnetPropertyStatesEscalatorModeBuilder
	// AsBACnetPropertyStatesLiftCarDirection converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftCarDirection() BACnetPropertyStatesLiftCarDirectionBuilder
	// AsBACnetPropertyStatesLiftCarDoorCommand converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftCarDoorCommand() BACnetPropertyStatesLiftCarDoorCommandBuilder
	// AsBACnetPropertyStatesLiftCarDriveStatus converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftCarDriveStatus() BACnetPropertyStatesLiftCarDriveStatusBuilder
	// AsBACnetPropertyStatesLiftCarMode converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftCarMode() BACnetPropertyStatesLiftCarModeBuilder
	// AsBACnetPropertyStatesLiftGroupMode converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftGroupMode() BACnetPropertyStatesLiftGroupModeBuilder
	// AsBACnetPropertyStatesLiftFault converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesLiftFault() BACnetPropertyStatesLiftFaultBuilder
	// AsBACnetPropertyStatesProtocolLevel converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesProtocolLevel() BACnetPropertyStatesProtocolLevelBuilder
	// AsBACnetPropertyStatesExtendedValue converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStatesExtendedValue() BACnetPropertyStatesExtendedValueBuilder
	// AsBACnetPropertyStateActionUnknown converts this build to a subType of BACnetPropertyStates. It is always possible to return to current builder using Done()
	AsBACnetPropertyStateActionUnknown() BACnetPropertyStateActionUnknownBuilder
	// Build builds the BACnetPropertyStates or returns an error if something is wrong
	PartialBuild() (BACnetPropertyStatesContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetPropertyStatesContract
	// Build builds the BACnetPropertyStates or returns an error if something is wrong
	Build() (BACnetPropertyStates, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStates
}

// NewBACnetPropertyStatesBuilder() creates a BACnetPropertyStatesBuilder
func NewBACnetPropertyStatesBuilder() BACnetPropertyStatesBuilder {
	return &_BACnetPropertyStatesBuilder{_BACnetPropertyStates: new(_BACnetPropertyStates)}
}

type _BACnetPropertyStatesChildBuilder interface {
	utils.Copyable
	setParent(BACnetPropertyStatesContract)
	buildForBACnetPropertyStates() (BACnetPropertyStates, error)
}

type _BACnetPropertyStatesBuilder struct {
	*_BACnetPropertyStates

	childBuilder _BACnetPropertyStatesChildBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesBuilder) = (*_BACnetPropertyStatesBuilder)(nil)

func (b *_BACnetPropertyStatesBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetPropertyStatesBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetPropertyStatesBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetPropertyStatesBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetPropertyStatesBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetPropertyStatesBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesBuilder) PartialBuild() (BACnetPropertyStatesContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStates.deepCopy(), nil
}

func (b *_BACnetPropertyStatesBuilder) PartialMustBuild() BACnetPropertyStatesContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesBoolean() BACnetPropertyStatesBooleanBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesBooleanBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesBooleanBuilder().(*_BACnetPropertyStatesBooleanBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesBinaryValue() BACnetPropertyStatesBinaryValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesBinaryValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesBinaryValueBuilder().(*_BACnetPropertyStatesBinaryValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesEventType() BACnetPropertyStatesEventTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesEventTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesEventTypeBuilder().(*_BACnetPropertyStatesEventTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesPolarity() BACnetPropertyStatesPolarityBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesPolarityBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesPolarityBuilder().(*_BACnetPropertyStatesPolarityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesProgramChange() BACnetPropertyStatesProgramChangeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesProgramChangeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesProgramChangeBuilder().(*_BACnetPropertyStatesProgramChangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesProgramState() BACnetPropertyStatesProgramStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesProgramStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesProgramStateBuilder().(*_BACnetPropertyStatesProgramStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesReasonForHalt() BACnetPropertyStatesReasonForHaltBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesReasonForHaltBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesReasonForHaltBuilder().(*_BACnetPropertyStatesReasonForHaltBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesReliability() BACnetPropertyStatesReliabilityBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesReliabilityBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesReliabilityBuilder().(*_BACnetPropertyStatesReliabilityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesState() BACnetPropertyStatesStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesStateBuilder().(*_BACnetPropertyStatesStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesSystemStatus() BACnetPropertyStatesSystemStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesSystemStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesSystemStatusBuilder().(*_BACnetPropertyStatesSystemStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesUnits() BACnetPropertyStatesUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesUnitsBuilder().(*_BACnetPropertyStatesUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesUnsignedValue() BACnetPropertyStatesUnsignedValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesUnsignedValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesUnsignedValueBuilder().(*_BACnetPropertyStatesUnsignedValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLifeSafetyMode() BACnetPropertyStatesLifeSafetyModeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLifeSafetyModeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLifeSafetyModeBuilder().(*_BACnetPropertyStatesLifeSafetyModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLifeSafetyState() BACnetPropertyStatesLifeSafetyStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLifeSafetyStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLifeSafetyStateBuilder().(*_BACnetPropertyStatesLifeSafetyStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesRestartReason() BACnetPropertyStatesRestartReasonBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesRestartReasonBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesRestartReasonBuilder().(*_BACnetPropertyStatesRestartReasonBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesDoorAlarmState() BACnetPropertyStatesDoorAlarmStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesDoorAlarmStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesDoorAlarmStateBuilder().(*_BACnetPropertyStatesDoorAlarmStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesAction() BACnetPropertyStatesActionBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesActionBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesActionBuilder().(*_BACnetPropertyStatesActionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesDoorSecuredStatus() BACnetPropertyStatesDoorSecuredStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesDoorSecuredStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesDoorSecuredStatusBuilder().(*_BACnetPropertyStatesDoorSecuredStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesDoorStatus() BACnetPropertyStatesDoorStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesDoorStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesDoorStatusBuilder().(*_BACnetPropertyStatesDoorStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesDoorValue() BACnetPropertyStatesDoorValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesDoorValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesDoorValueBuilder().(*_BACnetPropertyStatesDoorValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesFileAccessMethod() BACnetPropertyStatesFileAccessMethodBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesFileAccessMethodBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesFileAccessMethodBuilder().(*_BACnetPropertyStatesFileAccessMethodBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLockStatus() BACnetPropertyStatesLockStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLockStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLockStatusBuilder().(*_BACnetPropertyStatesLockStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLifeSafetyOperations() BACnetPropertyStatesLifeSafetyOperationsBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLifeSafetyOperationsBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLifeSafetyOperationsBuilder().(*_BACnetPropertyStatesLifeSafetyOperationsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesMaintenance() BACnetPropertyStatesMaintenanceBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesMaintenanceBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesMaintenanceBuilder().(*_BACnetPropertyStatesMaintenanceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesNodeType() BACnetPropertyStatesNodeTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesNodeTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesNodeTypeBuilder().(*_BACnetPropertyStatesNodeTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesNotifyType() BACnetPropertyStatesNotifyTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesNotifyTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesNotifyTypeBuilder().(*_BACnetPropertyStatesNotifyTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesSecurityLevel() BACnetPropertyStatesSecurityLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesSecurityLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesSecurityLevelBuilder().(*_BACnetPropertyStatesSecurityLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesShedState() BACnetPropertyStatesShedStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesShedStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesShedStateBuilder().(*_BACnetPropertyStatesShedStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesSilencedState() BACnetPropertyStatesSilencedStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesSilencedStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesSilencedStateBuilder().(*_BACnetPropertyStatesSilencedStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesAccessEvent() BACnetPropertyStatesAccessEventBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesAccessEventBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesAccessEventBuilder().(*_BACnetPropertyStatesAccessEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesZoneOccupanyState() BACnetPropertyStatesZoneOccupanyStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesZoneOccupanyStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesZoneOccupanyStateBuilder().(*_BACnetPropertyStatesZoneOccupanyStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesAccessCredentialDisableReason() BACnetPropertyStatesAccessCredentialDisableReasonBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesAccessCredentialDisableReasonBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesAccessCredentialDisableReasonBuilder().(*_BACnetPropertyStatesAccessCredentialDisableReasonBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesAccessCredentialDisable() BACnetPropertyStatesAccessCredentialDisableBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesAccessCredentialDisableBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesAccessCredentialDisableBuilder().(*_BACnetPropertyStatesAccessCredentialDisableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesAuthenticationStatus() BACnetPropertyStatesAuthenticationStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesAuthenticationStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesAuthenticationStatusBuilder().(*_BACnetPropertyStatesAuthenticationStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesBackupState() BACnetPropertyStatesBackupStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesBackupStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesBackupStateBuilder().(*_BACnetPropertyStatesBackupStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesWriteStatus() BACnetPropertyStatesWriteStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesWriteStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesWriteStatusBuilder().(*_BACnetPropertyStatesWriteStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLightningInProgress() BACnetPropertyStatesLightningInProgressBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLightningInProgressBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLightningInProgressBuilder().(*_BACnetPropertyStatesLightningInProgressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLightningOperation() BACnetPropertyStatesLightningOperationBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLightningOperationBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLightningOperationBuilder().(*_BACnetPropertyStatesLightningOperationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLightningTransition() BACnetPropertyStatesLightningTransitionBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLightningTransitionBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLightningTransitionBuilder().(*_BACnetPropertyStatesLightningTransitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesIntegerValue() BACnetPropertyStatesIntegerValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesIntegerValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesIntegerValueBuilder().(*_BACnetPropertyStatesIntegerValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesBinaryLightningValue() BACnetPropertyStatesBinaryLightningValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesBinaryLightningValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesBinaryLightningValueBuilder().(*_BACnetPropertyStatesBinaryLightningValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesTimerState() BACnetPropertyStatesTimerStateBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesTimerStateBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesTimerStateBuilder().(*_BACnetPropertyStatesTimerStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesTimerTransition() BACnetPropertyStatesTimerTransitionBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesTimerTransitionBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesTimerTransitionBuilder().(*_BACnetPropertyStatesTimerTransitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesBacnetIpMode() BACnetPropertyStatesBacnetIpModeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesBacnetIpModeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesBacnetIpModeBuilder().(*_BACnetPropertyStatesBacnetIpModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesNetworkPortCommand() BACnetPropertyStatesNetworkPortCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesNetworkPortCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesNetworkPortCommandBuilder().(*_BACnetPropertyStatesNetworkPortCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesNetworkType() BACnetPropertyStatesNetworkTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesNetworkTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesNetworkTypeBuilder().(*_BACnetPropertyStatesNetworkTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesNetworkNumberQuality() BACnetPropertyStatesNetworkNumberQualityBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesNetworkNumberQualityBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesNetworkNumberQualityBuilder().(*_BACnetPropertyStatesNetworkNumberQualityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesEscalatorOperationDirection() BACnetPropertyStatesEscalatorOperationDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesEscalatorOperationDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesEscalatorOperationDirectionBuilder().(*_BACnetPropertyStatesEscalatorOperationDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesEscalatorFault() BACnetPropertyStatesEscalatorFaultBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesEscalatorFaultBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesEscalatorFaultBuilder().(*_BACnetPropertyStatesEscalatorFaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesEscalatorMode() BACnetPropertyStatesEscalatorModeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesEscalatorModeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesEscalatorModeBuilder().(*_BACnetPropertyStatesEscalatorModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftCarDirection() BACnetPropertyStatesLiftCarDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftCarDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftCarDirectionBuilder().(*_BACnetPropertyStatesLiftCarDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftCarDoorCommand() BACnetPropertyStatesLiftCarDoorCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftCarDoorCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftCarDoorCommandBuilder().(*_BACnetPropertyStatesLiftCarDoorCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftCarDriveStatus() BACnetPropertyStatesLiftCarDriveStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftCarDriveStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftCarDriveStatusBuilder().(*_BACnetPropertyStatesLiftCarDriveStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftCarMode() BACnetPropertyStatesLiftCarModeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftCarModeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftCarModeBuilder().(*_BACnetPropertyStatesLiftCarModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftGroupMode() BACnetPropertyStatesLiftGroupModeBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftGroupModeBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftGroupModeBuilder().(*_BACnetPropertyStatesLiftGroupModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesLiftFault() BACnetPropertyStatesLiftFaultBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesLiftFaultBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesLiftFaultBuilder().(*_BACnetPropertyStatesLiftFaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesProtocolLevel() BACnetPropertyStatesProtocolLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesProtocolLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesProtocolLevelBuilder().(*_BACnetPropertyStatesProtocolLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStatesExtendedValue() BACnetPropertyStatesExtendedValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStatesExtendedValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStatesExtendedValueBuilder().(*_BACnetPropertyStatesExtendedValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) AsBACnetPropertyStateActionUnknown() BACnetPropertyStateActionUnknownBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyStateActionUnknownBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyStateActionUnknownBuilder().(*_BACnetPropertyStateActionUnknownBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyStatesBuilder) Build() (BACnetPropertyStates, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetPropertyStates()
}

func (b *_BACnetPropertyStatesBuilder) MustBuild() BACnetPropertyStates {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetPropertyStatesChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesBuilder creates a BACnetPropertyStatesBuilder
func (b *_BACnetPropertyStates) CreateBACnetPropertyStatesBuilder() BACnetPropertyStatesBuilder {
	if b == nil {
		return NewBACnetPropertyStatesBuilder()
	}
	return &_BACnetPropertyStatesBuilder{_BACnetPropertyStates: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStates) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetPropertyStates) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStates(structType any) BACnetPropertyStates {
	if casted, ok := structType.(BACnetPropertyStates); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStates); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStates) GetTypeName() string {
	return "BACnetPropertyStates"
}

func (m *_BACnetPropertyStates) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetPropertyStates) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetPropertyStates) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetPropertyStatesParse[T BACnetPropertyStates](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetPropertyStatesParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetPropertyStatesParseWithBufferProducer[T BACnetPropertyStates]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetPropertyStatesParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetPropertyStatesParseWithBuffer[T BACnetPropertyStates](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetPropertyStates{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetPropertyStates) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetPropertyStates BACnetPropertyStates, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStates"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStates")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetPropertyStates
	switch {
	case peekedTagNumber == uint8(0): // BACnetPropertyStatesBoolean
		if _child, err = new(_BACnetPropertyStatesBoolean).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesBoolean for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(1): // BACnetPropertyStatesBinaryValue
		if _child, err = new(_BACnetPropertyStatesBinaryValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesBinaryValue for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(2): // BACnetPropertyStatesEventType
		if _child, err = new(_BACnetPropertyStatesEventType).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesEventType for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(3): // BACnetPropertyStatesPolarity
		if _child, err = new(_BACnetPropertyStatesPolarity).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesPolarity for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(4): // BACnetPropertyStatesProgramChange
		if _child, err = new(_BACnetPropertyStatesProgramChange).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesProgramChange for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(5): // BACnetPropertyStatesProgramState
		if _child, err = new(_BACnetPropertyStatesProgramState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesProgramState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(6): // BACnetPropertyStatesReasonForHalt
		if _child, err = new(_BACnetPropertyStatesReasonForHalt).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesReasonForHalt for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(7): // BACnetPropertyStatesReliability
		if _child, err = new(_BACnetPropertyStatesReliability).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesReliability for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(8): // BACnetPropertyStatesState
		if _child, err = new(_BACnetPropertyStatesState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(9): // BACnetPropertyStatesSystemStatus
		if _child, err = new(_BACnetPropertyStatesSystemStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesSystemStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(10): // BACnetPropertyStatesUnits
		if _child, err = new(_BACnetPropertyStatesUnits).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesUnits for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(11): // BACnetPropertyStatesUnsignedValue
		if _child, err = new(_BACnetPropertyStatesUnsignedValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesUnsignedValue for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(12): // BACnetPropertyStatesLifeSafetyMode
		if _child, err = new(_BACnetPropertyStatesLifeSafetyMode).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLifeSafetyMode for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(13): // BACnetPropertyStatesLifeSafetyState
		if _child, err = new(_BACnetPropertyStatesLifeSafetyState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLifeSafetyState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(14): // BACnetPropertyStatesRestartReason
		if _child, err = new(_BACnetPropertyStatesRestartReason).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesRestartReason for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(15): // BACnetPropertyStatesDoorAlarmState
		if _child, err = new(_BACnetPropertyStatesDoorAlarmState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesDoorAlarmState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(16): // BACnetPropertyStatesAction
		if _child, err = new(_BACnetPropertyStatesAction).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesAction for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(17): // BACnetPropertyStatesDoorSecuredStatus
		if _child, err = new(_BACnetPropertyStatesDoorSecuredStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesDoorSecuredStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(18): // BACnetPropertyStatesDoorStatus
		if _child, err = new(_BACnetPropertyStatesDoorStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesDoorStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(19): // BACnetPropertyStatesDoorValue
		if _child, err = new(_BACnetPropertyStatesDoorValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesDoorValue for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(20): // BACnetPropertyStatesFileAccessMethod
		if _child, err = new(_BACnetPropertyStatesFileAccessMethod).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesFileAccessMethod for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(21): // BACnetPropertyStatesLockStatus
		if _child, err = new(_BACnetPropertyStatesLockStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLockStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(22): // BACnetPropertyStatesLifeSafetyOperations
		if _child, err = new(_BACnetPropertyStatesLifeSafetyOperations).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLifeSafetyOperations for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(23): // BACnetPropertyStatesMaintenance
		if _child, err = new(_BACnetPropertyStatesMaintenance).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesMaintenance for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(24): // BACnetPropertyStatesNodeType
		if _child, err = new(_BACnetPropertyStatesNodeType).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesNodeType for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(25): // BACnetPropertyStatesNotifyType
		if _child, err = new(_BACnetPropertyStatesNotifyType).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesNotifyType for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(26): // BACnetPropertyStatesSecurityLevel
		if _child, err = new(_BACnetPropertyStatesSecurityLevel).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesSecurityLevel for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(27): // BACnetPropertyStatesShedState
		if _child, err = new(_BACnetPropertyStatesShedState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesShedState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(28): // BACnetPropertyStatesSilencedState
		if _child, err = new(_BACnetPropertyStatesSilencedState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesSilencedState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(30): // BACnetPropertyStatesAccessEvent
		if _child, err = new(_BACnetPropertyStatesAccessEvent).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesAccessEvent for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(31): // BACnetPropertyStatesZoneOccupanyState
		if _child, err = new(_BACnetPropertyStatesZoneOccupanyState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesZoneOccupanyState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(32): // BACnetPropertyStatesAccessCredentialDisableReason
		if _child, err = new(_BACnetPropertyStatesAccessCredentialDisableReason).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesAccessCredentialDisableReason for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(33): // BACnetPropertyStatesAccessCredentialDisable
		if _child, err = new(_BACnetPropertyStatesAccessCredentialDisable).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesAccessCredentialDisable for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(34): // BACnetPropertyStatesAuthenticationStatus
		if _child, err = new(_BACnetPropertyStatesAuthenticationStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesAuthenticationStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(36): // BACnetPropertyStatesBackupState
		if _child, err = new(_BACnetPropertyStatesBackupState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesBackupState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(37): // BACnetPropertyStatesWriteStatus
		if _child, err = new(_BACnetPropertyStatesWriteStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesWriteStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(38): // BACnetPropertyStatesLightningInProgress
		if _child, err = new(_BACnetPropertyStatesLightningInProgress).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLightningInProgress for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(39): // BACnetPropertyStatesLightningOperation
		if _child, err = new(_BACnetPropertyStatesLightningOperation).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLightningOperation for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(40): // BACnetPropertyStatesLightningTransition
		if _child, err = new(_BACnetPropertyStatesLightningTransition).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLightningTransition for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(41): // BACnetPropertyStatesIntegerValue
		if _child, err = new(_BACnetPropertyStatesIntegerValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesIntegerValue for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(42): // BACnetPropertyStatesBinaryLightningValue
		if _child, err = new(_BACnetPropertyStatesBinaryLightningValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesBinaryLightningValue for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(43): // BACnetPropertyStatesTimerState
		if _child, err = new(_BACnetPropertyStatesTimerState).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesTimerState for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(44): // BACnetPropertyStatesTimerTransition
		if _child, err = new(_BACnetPropertyStatesTimerTransition).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesTimerTransition for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(45): // BACnetPropertyStatesBacnetIpMode
		if _child, err = new(_BACnetPropertyStatesBacnetIpMode).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesBacnetIpMode for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(46): // BACnetPropertyStatesNetworkPortCommand
		if _child, err = new(_BACnetPropertyStatesNetworkPortCommand).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesNetworkPortCommand for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(47): // BACnetPropertyStatesNetworkType
		if _child, err = new(_BACnetPropertyStatesNetworkType).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesNetworkType for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(48): // BACnetPropertyStatesNetworkNumberQuality
		if _child, err = new(_BACnetPropertyStatesNetworkNumberQuality).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesNetworkNumberQuality for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(49): // BACnetPropertyStatesEscalatorOperationDirection
		if _child, err = new(_BACnetPropertyStatesEscalatorOperationDirection).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesEscalatorOperationDirection for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(50): // BACnetPropertyStatesEscalatorFault
		if _child, err = new(_BACnetPropertyStatesEscalatorFault).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesEscalatorFault for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(51): // BACnetPropertyStatesEscalatorMode
		if _child, err = new(_BACnetPropertyStatesEscalatorMode).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesEscalatorMode for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(52): // BACnetPropertyStatesLiftCarDirection
		if _child, err = new(_BACnetPropertyStatesLiftCarDirection).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftCarDirection for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(53): // BACnetPropertyStatesLiftCarDoorCommand
		if _child, err = new(_BACnetPropertyStatesLiftCarDoorCommand).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftCarDoorCommand for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(54): // BACnetPropertyStatesLiftCarDriveStatus
		if _child, err = new(_BACnetPropertyStatesLiftCarDriveStatus).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftCarDriveStatus for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(55): // BACnetPropertyStatesLiftCarMode
		if _child, err = new(_BACnetPropertyStatesLiftCarMode).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftCarMode for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(56): // BACnetPropertyStatesLiftGroupMode
		if _child, err = new(_BACnetPropertyStatesLiftGroupMode).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftGroupMode for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(57): // BACnetPropertyStatesLiftFault
		if _child, err = new(_BACnetPropertyStatesLiftFault).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesLiftFault for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(58): // BACnetPropertyStatesProtocolLevel
		if _child, err = new(_BACnetPropertyStatesProtocolLevel).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesProtocolLevel for type-switch of BACnetPropertyStates")
		}
	case peekedTagNumber == uint8(63): // BACnetPropertyStatesExtendedValue
		if _child, err = new(_BACnetPropertyStatesExtendedValue).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStatesExtendedValue for type-switch of BACnetPropertyStates")
		}
	case true: // BACnetPropertyStateActionUnknown
		if _child, err = new(_BACnetPropertyStateActionUnknown).parse(ctx, readBuffer, m, peekedTagNumber); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyStateActionUnknown for type-switch of BACnetPropertyStates")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetPropertyStates"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStates")
	}

	return _child, nil
}

func (pm *_BACnetPropertyStates) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetPropertyStates, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetPropertyStates"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStates")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetPropertyStates"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetPropertyStates")
	}
	return nil
}

func (m *_BACnetPropertyStates) IsBACnetPropertyStates() {}

func (m *_BACnetPropertyStates) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStates) deepCopy() *_BACnetPropertyStates {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesCopy := &_BACnetPropertyStates{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetPropertyStatesCopy
}
