/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPriorityValueObjectidentifier is the corresponding interface of BACnetPriorityValueObjectidentifier
type BACnetPriorityValueObjectidentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPriorityValue
	// GetObjectidentifierValue returns ObjectidentifierValue (property field)
	GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier
	// IsBACnetPriorityValueObjectidentifier is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPriorityValueObjectidentifier()
	// CreateBuilder creates a BACnetPriorityValueObjectidentifierBuilder
	CreateBACnetPriorityValueObjectidentifierBuilder() BACnetPriorityValueObjectidentifierBuilder
}

// _BACnetPriorityValueObjectidentifier is the data-structure of this message
type _BACnetPriorityValueObjectidentifier struct {
	BACnetPriorityValueContract
	ObjectidentifierValue BACnetApplicationTagObjectIdentifier
}

var _ BACnetPriorityValueObjectidentifier = (*_BACnetPriorityValueObjectidentifier)(nil)
var _ BACnetPriorityValueRequirements = (*_BACnetPriorityValueObjectidentifier)(nil)

// NewBACnetPriorityValueObjectidentifier factory function for _BACnetPriorityValueObjectidentifier
func NewBACnetPriorityValueObjectidentifier(peekedTagHeader BACnetTagHeader, objectidentifierValue BACnetApplicationTagObjectIdentifier, objectTypeArgument BACnetObjectType) *_BACnetPriorityValueObjectidentifier {
	if objectidentifierValue == nil {
		panic("objectidentifierValue of type BACnetApplicationTagObjectIdentifier for BACnetPriorityValueObjectidentifier must not be nil")
	}
	_result := &_BACnetPriorityValueObjectidentifier{
		BACnetPriorityValueContract: NewBACnetPriorityValue(peekedTagHeader, objectTypeArgument),
		ObjectidentifierValue:       objectidentifierValue,
	}
	_result.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPriorityValueObjectidentifierBuilder is a builder for BACnetPriorityValueObjectidentifier
type BACnetPriorityValueObjectidentifierBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetPriorityValueObjectidentifierBuilder
	// WithObjectidentifierValue adds ObjectidentifierValue (property field)
	WithObjectidentifierValue(BACnetApplicationTagObjectIdentifier) BACnetPriorityValueObjectidentifierBuilder
	// WithObjectidentifierValueBuilder adds ObjectidentifierValue (property field) which is build by the builder
	WithObjectidentifierValueBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetPriorityValueObjectidentifierBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPriorityValueBuilder
	// Build builds the BACnetPriorityValueObjectidentifier or returns an error if something is wrong
	Build() (BACnetPriorityValueObjectidentifier, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPriorityValueObjectidentifier
}

// NewBACnetPriorityValueObjectidentifierBuilder() creates a BACnetPriorityValueObjectidentifierBuilder
func NewBACnetPriorityValueObjectidentifierBuilder() BACnetPriorityValueObjectidentifierBuilder {
	return &_BACnetPriorityValueObjectidentifierBuilder{_BACnetPriorityValueObjectidentifier: new(_BACnetPriorityValueObjectidentifier)}
}

type _BACnetPriorityValueObjectidentifierBuilder struct {
	*_BACnetPriorityValueObjectidentifier

	parentBuilder *_BACnetPriorityValueBuilder

	err *utils.MultiError
}

var _ (BACnetPriorityValueObjectidentifierBuilder) = (*_BACnetPriorityValueObjectidentifierBuilder)(nil)

func (b *_BACnetPriorityValueObjectidentifierBuilder) setParent(contract BACnetPriorityValueContract) {
	b.BACnetPriorityValueContract = contract
	contract.(*_BACnetPriorityValue)._SubType = b._BACnetPriorityValueObjectidentifier
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetPriorityValueObjectidentifierBuilder {
	return b.WithObjectidentifierValue(objectidentifierValue)
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) WithObjectidentifierValue(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetPriorityValueObjectidentifierBuilder {
	b.ObjectidentifierValue = objectidentifierValue
	return b
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) WithObjectidentifierValueBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetPriorityValueObjectidentifierBuilder {
	builder := builderSupplier(b.ObjectidentifierValue.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectidentifierValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) Build() (BACnetPriorityValueObjectidentifier, error) {
	if b.ObjectidentifierValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'objectidentifierValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPriorityValueObjectidentifier.deepCopy(), nil
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) MustBuild() BACnetPriorityValueObjectidentifier {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) Done() BACnetPriorityValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPriorityValueBuilder().(*_BACnetPriorityValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) buildForBACnetPriorityValue() (BACnetPriorityValue, error) {
	return b.Build()
}

func (b *_BACnetPriorityValueObjectidentifierBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPriorityValueObjectidentifierBuilder().(*_BACnetPriorityValueObjectidentifierBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPriorityValueObjectidentifierBuilder creates a BACnetPriorityValueObjectidentifierBuilder
func (b *_BACnetPriorityValueObjectidentifier) CreateBACnetPriorityValueObjectidentifierBuilder() BACnetPriorityValueObjectidentifierBuilder {
	if b == nil {
		return NewBACnetPriorityValueObjectidentifierBuilder()
	}
	return &_BACnetPriorityValueObjectidentifierBuilder{_BACnetPriorityValueObjectidentifier: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPriorityValueObjectidentifier) GetParent() BACnetPriorityValueContract {
	return m.BACnetPriorityValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPriorityValueObjectidentifier) GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier {
	return m.ObjectidentifierValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPriorityValueObjectidentifier(structType any) BACnetPriorityValueObjectidentifier {
	if casted, ok := structType.(BACnetPriorityValueObjectidentifier); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPriorityValueObjectidentifier); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPriorityValueObjectidentifier) GetTypeName() string {
	return "BACnetPriorityValueObjectidentifier"
}

func (m *_BACnetPriorityValueObjectidentifier) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPriorityValueContract.(*_BACnetPriorityValue).getLengthInBits(ctx))

	// Simple field (objectidentifierValue)
	lengthInBits += m.ObjectidentifierValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPriorityValueObjectidentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPriorityValueObjectidentifier) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPriorityValue, objectTypeArgument BACnetObjectType) (__bACnetPriorityValueObjectidentifier BACnetPriorityValueObjectidentifier, err error) {
	m.BACnetPriorityValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPriorityValueObjectidentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPriorityValueObjectidentifier")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectidentifierValue, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectidentifierValue' field"))
	}
	m.ObjectidentifierValue = objectidentifierValue

	if closeErr := readBuffer.CloseContext("BACnetPriorityValueObjectidentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPriorityValueObjectidentifier")
	}

	return m, nil
}

func (m *_BACnetPriorityValueObjectidentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPriorityValueObjectidentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPriorityValueObjectidentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPriorityValueObjectidentifier")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", m.GetObjectidentifierValue(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectidentifierValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPriorityValueObjectidentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPriorityValueObjectidentifier")
		}
		return nil
	}
	return m.BACnetPriorityValueContract.(*_BACnetPriorityValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPriorityValueObjectidentifier) IsBACnetPriorityValueObjectidentifier() {}

func (m *_BACnetPriorityValueObjectidentifier) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPriorityValueObjectidentifier) deepCopy() *_BACnetPriorityValueObjectidentifier {
	if m == nil {
		return nil
	}
	_BACnetPriorityValueObjectidentifierCopy := &_BACnetPriorityValueObjectidentifier{
		m.BACnetPriorityValueContract.(*_BACnetPriorityValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectidentifierValue),
	}
	_BACnetPriorityValueObjectidentifierCopy.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = m
	return _BACnetPriorityValueObjectidentifierCopy
}

func (m *_BACnetPriorityValueObjectidentifier) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
