/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParametersChangeOfValueNewValueChangedBits is the corresponding interface of BACnetNotificationParametersChangeOfValueNewValueChangedBits
type BACnetNotificationParametersChangeOfValueNewValueChangedBits interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetNotificationParametersChangeOfValueNewValue
	// GetChangedBits returns ChangedBits (property field)
	GetChangedBits() BACnetContextTagBitString
	// IsBACnetNotificationParametersChangeOfValueNewValueChangedBits is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParametersChangeOfValueNewValueChangedBits()
	// CreateBuilder creates a BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
	CreateBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder() BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
}

// _BACnetNotificationParametersChangeOfValueNewValueChangedBits is the data-structure of this message
type _BACnetNotificationParametersChangeOfValueNewValueChangedBits struct {
	BACnetNotificationParametersChangeOfValueNewValueContract
	ChangedBits BACnetContextTagBitString
}

var _ BACnetNotificationParametersChangeOfValueNewValueChangedBits = (*_BACnetNotificationParametersChangeOfValueNewValueChangedBits)(nil)
var _ BACnetNotificationParametersChangeOfValueNewValueRequirements = (*_BACnetNotificationParametersChangeOfValueNewValueChangedBits)(nil)

// NewBACnetNotificationParametersChangeOfValueNewValueChangedBits factory function for _BACnetNotificationParametersChangeOfValueNewValueChangedBits
func NewBACnetNotificationParametersChangeOfValueNewValueChangedBits(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, changedBits BACnetContextTagBitString, tagNumber uint8) *_BACnetNotificationParametersChangeOfValueNewValueChangedBits {
	if changedBits == nil {
		panic("changedBits of type BACnetContextTagBitString for BACnetNotificationParametersChangeOfValueNewValueChangedBits must not be nil")
	}
	_result := &_BACnetNotificationParametersChangeOfValueNewValueChangedBits{
		BACnetNotificationParametersChangeOfValueNewValueContract: NewBACnetNotificationParametersChangeOfValueNewValue(openingTag, peekedTagHeader, closingTag, tagNumber),
		ChangedBits: changedBits,
	}
	_result.BACnetNotificationParametersChangeOfValueNewValueContract.(*_BACnetNotificationParametersChangeOfValueNewValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder is a builder for BACnetNotificationParametersChangeOfValueNewValueChangedBits
type BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(changedBits BACnetContextTagBitString) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
	// WithChangedBits adds ChangedBits (property field)
	WithChangedBits(BACnetContextTagBitString) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
	// WithChangedBitsBuilder adds ChangedBits (property field) which is build by the builder
	WithChangedBitsBuilder(func(BACnetContextTagBitStringBuilder) BACnetContextTagBitStringBuilder) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetNotificationParametersChangeOfValueNewValueBuilder
	// Build builds the BACnetNotificationParametersChangeOfValueNewValueChangedBits or returns an error if something is wrong
	Build() (BACnetNotificationParametersChangeOfValueNewValueChangedBits, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetNotificationParametersChangeOfValueNewValueChangedBits
}

// NewBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder() creates a BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
func NewBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder() BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder {
	return &_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder{_BACnetNotificationParametersChangeOfValueNewValueChangedBits: new(_BACnetNotificationParametersChangeOfValueNewValueChangedBits)}
}

type _BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder struct {
	*_BACnetNotificationParametersChangeOfValueNewValueChangedBits

	parentBuilder *_BACnetNotificationParametersChangeOfValueNewValueBuilder

	err *utils.MultiError
}

var _ (BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) = (*_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder)(nil)

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) setParent(contract BACnetNotificationParametersChangeOfValueNewValueContract) {
	b.BACnetNotificationParametersChangeOfValueNewValueContract = contract
	contract.(*_BACnetNotificationParametersChangeOfValueNewValue)._SubType = b._BACnetNotificationParametersChangeOfValueNewValueChangedBits
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) WithMandatoryFields(changedBits BACnetContextTagBitString) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder {
	return b.WithChangedBits(changedBits)
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) WithChangedBits(changedBits BACnetContextTagBitString) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder {
	b.ChangedBits = changedBits
	return b
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) WithChangedBitsBuilder(builderSupplier func(BACnetContextTagBitStringBuilder) BACnetContextTagBitStringBuilder) BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder {
	builder := builderSupplier(b.ChangedBits.CreateBACnetContextTagBitStringBuilder())
	var err error
	b.ChangedBits, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) Build() (BACnetNotificationParametersChangeOfValueNewValueChangedBits, error) {
	if b.ChangedBits == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'changedBits' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetNotificationParametersChangeOfValueNewValueChangedBits.deepCopy(), nil
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) MustBuild() BACnetNotificationParametersChangeOfValueNewValueChangedBits {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) Done() BACnetNotificationParametersChangeOfValueNewValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetNotificationParametersChangeOfValueNewValueBuilder().(*_BACnetNotificationParametersChangeOfValueNewValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) buildForBACnetNotificationParametersChangeOfValueNewValue() (BACnetNotificationParametersChangeOfValueNewValue, error) {
	return b.Build()
}

func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder().(*_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder creates a BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder
func (b *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) CreateBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder() BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder {
	if b == nil {
		return NewBACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder()
	}
	return &_BACnetNotificationParametersChangeOfValueNewValueChangedBitsBuilder{_BACnetNotificationParametersChangeOfValueNewValueChangedBits: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) GetParent() BACnetNotificationParametersChangeOfValueNewValueContract {
	return m.BACnetNotificationParametersChangeOfValueNewValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) GetChangedBits() BACnetContextTagBitString {
	return m.ChangedBits
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParametersChangeOfValueNewValueChangedBits(structType any) BACnetNotificationParametersChangeOfValueNewValueChangedBits {
	if casted, ok := structType.(BACnetNotificationParametersChangeOfValueNewValueChangedBits); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParametersChangeOfValueNewValueChangedBits); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) GetTypeName() string {
	return "BACnetNotificationParametersChangeOfValueNewValueChangedBits"
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetNotificationParametersChangeOfValueNewValueContract.(*_BACnetNotificationParametersChangeOfValueNewValue).getLengthInBits(ctx))

	// Simple field (changedBits)
	lengthInBits += m.ChangedBits.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetNotificationParametersChangeOfValueNewValue, peekedTagNumber uint8, tagNumber uint8) (__bACnetNotificationParametersChangeOfValueNewValueChangedBits BACnetNotificationParametersChangeOfValueNewValueChangedBits, err error) {
	m.BACnetNotificationParametersChangeOfValueNewValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParametersChangeOfValueNewValueChangedBits"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParametersChangeOfValueNewValueChangedBits")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	changedBits, err := ReadSimpleField[BACnetContextTagBitString](ctx, "changedBits", ReadComplex[BACnetContextTagBitString](BACnetContextTagParseWithBufferProducer[BACnetContextTagBitString]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BIT_STRING)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'changedBits' field"))
	}
	m.ChangedBits = changedBits

	if closeErr := readBuffer.CloseContext("BACnetNotificationParametersChangeOfValueNewValueChangedBits"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParametersChangeOfValueNewValueChangedBits")
	}

	return m, nil
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetNotificationParametersChangeOfValueNewValueChangedBits"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParametersChangeOfValueNewValueChangedBits")
		}

		if err := WriteSimpleField[BACnetContextTagBitString](ctx, "changedBits", m.GetChangedBits(), WriteComplex[BACnetContextTagBitString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'changedBits' field")
		}

		if popErr := writeBuffer.PopContext("BACnetNotificationParametersChangeOfValueNewValueChangedBits"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetNotificationParametersChangeOfValueNewValueChangedBits")
		}
		return nil
	}
	return m.BACnetNotificationParametersChangeOfValueNewValueContract.(*_BACnetNotificationParametersChangeOfValueNewValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) IsBACnetNotificationParametersChangeOfValueNewValueChangedBits() {
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) deepCopy() *_BACnetNotificationParametersChangeOfValueNewValueChangedBits {
	if m == nil {
		return nil
	}
	_BACnetNotificationParametersChangeOfValueNewValueChangedBitsCopy := &_BACnetNotificationParametersChangeOfValueNewValueChangedBits{
		m.BACnetNotificationParametersChangeOfValueNewValueContract.(*_BACnetNotificationParametersChangeOfValueNewValue).deepCopy(),
		utils.DeepCopy[BACnetContextTagBitString](m.ChangedBits),
	}
	_BACnetNotificationParametersChangeOfValueNewValueChangedBitsCopy.BACnetNotificationParametersChangeOfValueNewValueContract.(*_BACnetNotificationParametersChangeOfValueNewValue)._SubType = m
	return _BACnetNotificationParametersChangeOfValueNewValueChangedBitsCopy
}

func (m *_BACnetNotificationParametersChangeOfValueNewValueChangedBits) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
