/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLogStatusTagged is the corresponding interface of BACnetLogStatusTagged
type BACnetLogStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadBitString
	// GetLogDisabled returns LogDisabled (virtual field)
	GetLogDisabled() bool
	// GetBufferPurged returns BufferPurged (virtual field)
	GetBufferPurged() bool
	// GetLogInterrupted returns LogInterrupted (virtual field)
	GetLogInterrupted() bool
	// IsBACnetLogStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLogStatusTagged()
	// CreateBuilder creates a BACnetLogStatusTaggedBuilder
	CreateBACnetLogStatusTaggedBuilder() BACnetLogStatusTaggedBuilder
}

// _BACnetLogStatusTagged is the data-structure of this message
type _BACnetLogStatusTagged struct {
	Header  BACnetTagHeader
	Payload BACnetTagPayloadBitString

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLogStatusTagged = (*_BACnetLogStatusTagged)(nil)

// NewBACnetLogStatusTagged factory function for _BACnetLogStatusTagged
func NewBACnetLogStatusTagged(header BACnetTagHeader, payload BACnetTagPayloadBitString, tagNumber uint8, tagClass TagClass) *_BACnetLogStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLogStatusTagged must not be nil")
	}
	if payload == nil {
		panic("payload of type BACnetTagPayloadBitString for BACnetLogStatusTagged must not be nil")
	}
	return &_BACnetLogStatusTagged{Header: header, Payload: payload, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLogStatusTaggedBuilder is a builder for BACnetLogStatusTagged
type BACnetLogStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, payload BACnetTagPayloadBitString) BACnetLogStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLogStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLogStatusTaggedBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadBitString) BACnetLogStatusTaggedBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadBitStringBuilder) BACnetTagPayloadBitStringBuilder) BACnetLogStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLogStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLogStatusTaggedBuilder
	// Build builds the BACnetLogStatusTagged or returns an error if something is wrong
	Build() (BACnetLogStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLogStatusTagged
}

// NewBACnetLogStatusTaggedBuilder() creates a BACnetLogStatusTaggedBuilder
func NewBACnetLogStatusTaggedBuilder() BACnetLogStatusTaggedBuilder {
	return &_BACnetLogStatusTaggedBuilder{_BACnetLogStatusTagged: new(_BACnetLogStatusTagged)}
}

type _BACnetLogStatusTaggedBuilder struct {
	*_BACnetLogStatusTagged

	err *utils.MultiError
}

var _ (BACnetLogStatusTaggedBuilder) = (*_BACnetLogStatusTaggedBuilder)(nil)

func (b *_BACnetLogStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, payload BACnetTagPayloadBitString) BACnetLogStatusTaggedBuilder {
	return b.WithHeader(header).WithPayload(payload)
}

func (b *_BACnetLogStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLogStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLogStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLogStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLogStatusTaggedBuilder) WithPayload(payload BACnetTagPayloadBitString) BACnetLogStatusTaggedBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetLogStatusTaggedBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadBitStringBuilder) BACnetTagPayloadBitStringBuilder) BACnetLogStatusTaggedBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadBitStringBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagPayloadBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetLogStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLogStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLogStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLogStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLogStatusTaggedBuilder) Build() (BACnetLogStatusTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.Payload == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'payload' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLogStatusTagged.deepCopy(), nil
}

func (b *_BACnetLogStatusTaggedBuilder) MustBuild() BACnetLogStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLogStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLogStatusTaggedBuilder().(*_BACnetLogStatusTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLogStatusTaggedBuilder creates a BACnetLogStatusTaggedBuilder
func (b *_BACnetLogStatusTagged) CreateBACnetLogStatusTaggedBuilder() BACnetLogStatusTaggedBuilder {
	if b == nil {
		return NewBACnetLogStatusTaggedBuilder()
	}
	return &_BACnetLogStatusTaggedBuilder{_BACnetLogStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLogStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLogStatusTagged) GetPayload() BACnetTagPayloadBitString {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetLogStatusTagged) GetLogDisabled() bool {
	ctx := context.Background()
	_ = ctx
	return bool(utils.InlineIf((bool((len(m.GetPayload().GetData())) > (0))), func() any { return bool(m.GetPayload().GetData()[0]) }, func() any { return bool(bool(false)) }).(bool))
}

func (m *_BACnetLogStatusTagged) GetBufferPurged() bool {
	ctx := context.Background()
	_ = ctx
	return bool(utils.InlineIf((bool((len(m.GetPayload().GetData())) > (1))), func() any { return bool(m.GetPayload().GetData()[1]) }, func() any { return bool(bool(false)) }).(bool))
}

func (m *_BACnetLogStatusTagged) GetLogInterrupted() bool {
	ctx := context.Background()
	_ = ctx
	return bool(utils.InlineIf((bool((len(m.GetPayload().GetData())) > (2))), func() any { return bool(m.GetPayload().GetData()[2]) }, func() any { return bool(bool(false)) }).(bool))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLogStatusTagged(structType any) BACnetLogStatusTagged {
	if casted, ok := structType.(BACnetLogStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLogStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLogStatusTagged) GetTypeName() string {
	return "BACnetLogStatusTagged"
}

func (m *_BACnetLogStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetLogStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLogStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLogStatusTagged, error) {
	return BACnetLogStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLogStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLogStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLogStatusTagged, error) {
		return BACnetLogStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLogStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLogStatusTagged, error) {
	v, err := (&_BACnetLogStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLogStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLogStatusTagged BACnetLogStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLogStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLogStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	payload, err := ReadSimpleField[BACnetTagPayloadBitString](ctx, "payload", ReadComplex[BACnetTagPayloadBitString](BACnetTagPayloadBitStringParseWithBufferProducer((uint32)(header.GetActualLength())), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	logDisabled, err := ReadVirtualField[bool](ctx, "logDisabled", (*bool)(nil), utils.InlineIf((bool((len(payload.GetData())) > (0))), func() any { return bool(payload.GetData()[0]) }, func() any { return bool(bool(false)) }).(bool))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'logDisabled' field"))
	}
	_ = logDisabled

	bufferPurged, err := ReadVirtualField[bool](ctx, "bufferPurged", (*bool)(nil), utils.InlineIf((bool((len(payload.GetData())) > (1))), func() any { return bool(payload.GetData()[1]) }, func() any { return bool(bool(false)) }).(bool))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bufferPurged' field"))
	}
	_ = bufferPurged

	logInterrupted, err := ReadVirtualField[bool](ctx, "logInterrupted", (*bool)(nil), utils.InlineIf((bool((len(payload.GetData())) > (2))), func() any { return bool(payload.GetData()[2]) }, func() any { return bool(bool(false)) }).(bool))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'logInterrupted' field"))
	}
	_ = logInterrupted

	if closeErr := readBuffer.CloseContext("BACnetLogStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLogStatusTagged")
	}

	return m, nil
}

func (m *_BACnetLogStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLogStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLogStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLogStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteSimpleField[BACnetTagPayloadBitString](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadBitString](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'payload' field")
	}
	// Virtual field
	logDisabled := m.GetLogDisabled()
	_ = logDisabled
	if _logDisabledErr := writeBuffer.WriteVirtual(ctx, "logDisabled", m.GetLogDisabled()); _logDisabledErr != nil {
		return errors.Wrap(_logDisabledErr, "Error serializing 'logDisabled' field")
	}
	// Virtual field
	bufferPurged := m.GetBufferPurged()
	_ = bufferPurged
	if _bufferPurgedErr := writeBuffer.WriteVirtual(ctx, "bufferPurged", m.GetBufferPurged()); _bufferPurgedErr != nil {
		return errors.Wrap(_bufferPurgedErr, "Error serializing 'bufferPurged' field")
	}
	// Virtual field
	logInterrupted := m.GetLogInterrupted()
	_ = logInterrupted
	if _logInterruptedErr := writeBuffer.WriteVirtual(ctx, "logInterrupted", m.GetLogInterrupted()); _logInterruptedErr != nil {
		return errors.Wrap(_logInterruptedErr, "Error serializing 'logInterrupted' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLogStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLogStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLogStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLogStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLogStatusTagged) IsBACnetLogStatusTagged() {}

func (m *_BACnetLogStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLogStatusTagged) deepCopy() *_BACnetLogStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetLogStatusTaggedCopy := &_BACnetLogStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		utils.DeepCopy[BACnetTagPayloadBitString](m.Payload),
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLogStatusTaggedCopy
}

func (m *_BACnetLogStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
