/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLogDataLogDataEntry is the corresponding interface of BACnetLogDataLogDataEntry
type BACnetLogDataLogDataEntry interface {
	BACnetLogDataLogDataEntryContract
	BACnetLogDataLogDataEntryRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetLogDataLogDataEntry is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLogDataLogDataEntry()
	// CreateBuilder creates a BACnetLogDataLogDataEntryBuilder
	CreateBACnetLogDataLogDataEntryBuilder() BACnetLogDataLogDataEntryBuilder
}

// BACnetLogDataLogDataEntryContract provides a set of functions which can be overwritten by a sub struct
type BACnetLogDataLogDataEntryContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetLogDataLogDataEntry is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLogDataLogDataEntry()
	// CreateBuilder creates a BACnetLogDataLogDataEntryBuilder
	CreateBACnetLogDataLogDataEntryBuilder() BACnetLogDataLogDataEntryBuilder
}

// BACnetLogDataLogDataEntryRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetLogDataLogDataEntryRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetLogDataLogDataEntry is the data-structure of this message
type _BACnetLogDataLogDataEntry struct {
	_SubType interface {
		BACnetLogDataLogDataEntryContract
		BACnetLogDataLogDataEntryRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetLogDataLogDataEntryContract = (*_BACnetLogDataLogDataEntry)(nil)

// NewBACnetLogDataLogDataEntry factory function for _BACnetLogDataLogDataEntry
func NewBACnetLogDataLogDataEntry(peekedTagHeader BACnetTagHeader) *_BACnetLogDataLogDataEntry {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetLogDataLogDataEntry must not be nil")
	}
	return &_BACnetLogDataLogDataEntry{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLogDataLogDataEntryBuilder is a builder for BACnetLogDataLogDataEntry
type BACnetLogDataLogDataEntryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetLogDataLogDataEntryBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetLogDataLogDataEntryBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLogDataLogDataEntryBuilder
	// AsBACnetLogDataLogDataEntryBooleanValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryBooleanValue() BACnetLogDataLogDataEntryBooleanValueBuilder
	// AsBACnetLogDataLogDataEntryRealValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryRealValue() BACnetLogDataLogDataEntryRealValueBuilder
	// AsBACnetLogDataLogDataEntryEnumeratedValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryEnumeratedValue() BACnetLogDataLogDataEntryEnumeratedValueBuilder
	// AsBACnetLogDataLogDataEntryUnsignedValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryUnsignedValue() BACnetLogDataLogDataEntryUnsignedValueBuilder
	// AsBACnetLogDataLogDataEntryIntegerValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryIntegerValue() BACnetLogDataLogDataEntryIntegerValueBuilder
	// AsBACnetLogDataLogDataEntryBitStringValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryBitStringValue() BACnetLogDataLogDataEntryBitStringValueBuilder
	// AsBACnetLogDataLogDataEntryNullValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryNullValue() BACnetLogDataLogDataEntryNullValueBuilder
	// AsBACnetLogDataLogDataEntryFailure converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryFailure() BACnetLogDataLogDataEntryFailureBuilder
	// AsBACnetLogDataLogDataEntryAnyValue converts this build to a subType of BACnetLogDataLogDataEntry. It is always possible to return to current builder using Done()
	AsBACnetLogDataLogDataEntryAnyValue() BACnetLogDataLogDataEntryAnyValueBuilder
	// Build builds the BACnetLogDataLogDataEntry or returns an error if something is wrong
	PartialBuild() (BACnetLogDataLogDataEntryContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetLogDataLogDataEntryContract
	// Build builds the BACnetLogDataLogDataEntry or returns an error if something is wrong
	Build() (BACnetLogDataLogDataEntry, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLogDataLogDataEntry
}

// NewBACnetLogDataLogDataEntryBuilder() creates a BACnetLogDataLogDataEntryBuilder
func NewBACnetLogDataLogDataEntryBuilder() BACnetLogDataLogDataEntryBuilder {
	return &_BACnetLogDataLogDataEntryBuilder{_BACnetLogDataLogDataEntry: new(_BACnetLogDataLogDataEntry)}
}

type _BACnetLogDataLogDataEntryChildBuilder interface {
	utils.Copyable
	setParent(BACnetLogDataLogDataEntryContract)
	buildForBACnetLogDataLogDataEntry() (BACnetLogDataLogDataEntry, error)
}

type _BACnetLogDataLogDataEntryBuilder struct {
	*_BACnetLogDataLogDataEntry

	childBuilder _BACnetLogDataLogDataEntryChildBuilder

	err *utils.MultiError
}

var _ (BACnetLogDataLogDataEntryBuilder) = (*_BACnetLogDataLogDataEntryBuilder)(nil)

func (b *_BACnetLogDataLogDataEntryBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetLogDataLogDataEntryBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetLogDataLogDataEntryBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetLogDataLogDataEntryBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetLogDataLogDataEntryBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLogDataLogDataEntryBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLogDataLogDataEntryBuilder) PartialBuild() (BACnetLogDataLogDataEntryContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLogDataLogDataEntry.deepCopy(), nil
}

func (b *_BACnetLogDataLogDataEntryBuilder) PartialMustBuild() BACnetLogDataLogDataEntryContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryBooleanValue() BACnetLogDataLogDataEntryBooleanValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryBooleanValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryBooleanValueBuilder().(*_BACnetLogDataLogDataEntryBooleanValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryRealValue() BACnetLogDataLogDataEntryRealValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryRealValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryRealValueBuilder().(*_BACnetLogDataLogDataEntryRealValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryEnumeratedValue() BACnetLogDataLogDataEntryEnumeratedValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryEnumeratedValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryEnumeratedValueBuilder().(*_BACnetLogDataLogDataEntryEnumeratedValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryUnsignedValue() BACnetLogDataLogDataEntryUnsignedValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryUnsignedValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryUnsignedValueBuilder().(*_BACnetLogDataLogDataEntryUnsignedValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryIntegerValue() BACnetLogDataLogDataEntryIntegerValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryIntegerValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryIntegerValueBuilder().(*_BACnetLogDataLogDataEntryIntegerValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryBitStringValue() BACnetLogDataLogDataEntryBitStringValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryBitStringValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryBitStringValueBuilder().(*_BACnetLogDataLogDataEntryBitStringValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryNullValue() BACnetLogDataLogDataEntryNullValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryNullValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryNullValueBuilder().(*_BACnetLogDataLogDataEntryNullValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryFailure() BACnetLogDataLogDataEntryFailureBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryFailureBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryFailureBuilder().(*_BACnetLogDataLogDataEntryFailureBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) AsBACnetLogDataLogDataEntryAnyValue() BACnetLogDataLogDataEntryAnyValueBuilder {
	if cb, ok := b.childBuilder.(BACnetLogDataLogDataEntryAnyValueBuilder); ok {
		return cb
	}
	cb := NewBACnetLogDataLogDataEntryAnyValueBuilder().(*_BACnetLogDataLogDataEntryAnyValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLogDataLogDataEntryBuilder) Build() (BACnetLogDataLogDataEntry, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetLogDataLogDataEntry()
}

func (b *_BACnetLogDataLogDataEntryBuilder) MustBuild() BACnetLogDataLogDataEntry {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLogDataLogDataEntryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLogDataLogDataEntryBuilder().(*_BACnetLogDataLogDataEntryBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetLogDataLogDataEntryChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLogDataLogDataEntryBuilder creates a BACnetLogDataLogDataEntryBuilder
func (b *_BACnetLogDataLogDataEntry) CreateBACnetLogDataLogDataEntryBuilder() BACnetLogDataLogDataEntryBuilder {
	if b == nil {
		return NewBACnetLogDataLogDataEntryBuilder()
	}
	return &_BACnetLogDataLogDataEntryBuilder{_BACnetLogDataLogDataEntry: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLogDataLogDataEntry) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetLogDataLogDataEntry) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLogDataLogDataEntry(structType any) BACnetLogDataLogDataEntry {
	if casted, ok := structType.(BACnetLogDataLogDataEntry); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLogDataLogDataEntry); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLogDataLogDataEntry) GetTypeName() string {
	return "BACnetLogDataLogDataEntry"
}

func (m *_BACnetLogDataLogDataEntry) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetLogDataLogDataEntry) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetLogDataLogDataEntry) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetLogDataLogDataEntryParse[T BACnetLogDataLogDataEntry](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetLogDataLogDataEntryParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetLogDataLogDataEntryParseWithBufferProducer[T BACnetLogDataLogDataEntry]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetLogDataLogDataEntryParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetLogDataLogDataEntryParseWithBuffer[T BACnetLogDataLogDataEntry](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetLogDataLogDataEntry{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetLogDataLogDataEntry) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetLogDataLogDataEntry BACnetLogDataLogDataEntry, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLogDataLogDataEntry"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLogDataLogDataEntry")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetLogDataLogDataEntry
	switch {
	case peekedTagNumber == uint8(0): // BACnetLogDataLogDataEntryBooleanValue
		if _child, err = new(_BACnetLogDataLogDataEntryBooleanValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryBooleanValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(1): // BACnetLogDataLogDataEntryRealValue
		if _child, err = new(_BACnetLogDataLogDataEntryRealValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryRealValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(2): // BACnetLogDataLogDataEntryEnumeratedValue
		if _child, err = new(_BACnetLogDataLogDataEntryEnumeratedValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryEnumeratedValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(3): // BACnetLogDataLogDataEntryUnsignedValue
		if _child, err = new(_BACnetLogDataLogDataEntryUnsignedValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryUnsignedValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(4): // BACnetLogDataLogDataEntryIntegerValue
		if _child, err = new(_BACnetLogDataLogDataEntryIntegerValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryIntegerValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(5): // BACnetLogDataLogDataEntryBitStringValue
		if _child, err = new(_BACnetLogDataLogDataEntryBitStringValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryBitStringValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(6): // BACnetLogDataLogDataEntryNullValue
		if _child, err = new(_BACnetLogDataLogDataEntryNullValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryNullValue for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(7): // BACnetLogDataLogDataEntryFailure
		if _child, err = new(_BACnetLogDataLogDataEntryFailure).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryFailure for type-switch of BACnetLogDataLogDataEntry")
		}
	case peekedTagNumber == uint8(8): // BACnetLogDataLogDataEntryAnyValue
		if _child, err = new(_BACnetLogDataLogDataEntryAnyValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLogDataLogDataEntryAnyValue for type-switch of BACnetLogDataLogDataEntry")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetLogDataLogDataEntry"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLogDataLogDataEntry")
	}

	return _child, nil
}

func (pm *_BACnetLogDataLogDataEntry) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetLogDataLogDataEntry, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLogDataLogDataEntry"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLogDataLogDataEntry")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetLogDataLogDataEntry"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLogDataLogDataEntry")
	}
	return nil
}

func (m *_BACnetLogDataLogDataEntry) IsBACnetLogDataLogDataEntry() {}

func (m *_BACnetLogDataLogDataEntry) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLogDataLogDataEntry) deepCopy() *_BACnetLogDataLogDataEntry {
	if m == nil {
		return nil
	}
	_BACnetLogDataLogDataEntryCopy := &_BACnetLogDataLogDataEntry{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetLogDataLogDataEntryCopy
}
