/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLiftCarDriveStatusTagged is the corresponding interface of BACnetLiftCarDriveStatusTagged
type BACnetLiftCarDriveStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLiftCarDriveStatus
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetLiftCarDriveStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLiftCarDriveStatusTagged()
	// CreateBuilder creates a BACnetLiftCarDriveStatusTaggedBuilder
	CreateBACnetLiftCarDriveStatusTaggedBuilder() BACnetLiftCarDriveStatusTaggedBuilder
}

// _BACnetLiftCarDriveStatusTagged is the data-structure of this message
type _BACnetLiftCarDriveStatusTagged struct {
	Header           BACnetTagHeader
	Value            BACnetLiftCarDriveStatus
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLiftCarDriveStatusTagged = (*_BACnetLiftCarDriveStatusTagged)(nil)

// NewBACnetLiftCarDriveStatusTagged factory function for _BACnetLiftCarDriveStatusTagged
func NewBACnetLiftCarDriveStatusTagged(header BACnetTagHeader, value BACnetLiftCarDriveStatus, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetLiftCarDriveStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLiftCarDriveStatusTagged must not be nil")
	}
	return &_BACnetLiftCarDriveStatusTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLiftCarDriveStatusTaggedBuilder is a builder for BACnetLiftCarDriveStatusTagged
type BACnetLiftCarDriveStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLiftCarDriveStatus, proprietaryValue uint32) BACnetLiftCarDriveStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLiftCarDriveStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftCarDriveStatusTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLiftCarDriveStatus) BACnetLiftCarDriveStatusTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetLiftCarDriveStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLiftCarDriveStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLiftCarDriveStatusTaggedBuilder
	// Build builds the BACnetLiftCarDriveStatusTagged or returns an error if something is wrong
	Build() (BACnetLiftCarDriveStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLiftCarDriveStatusTagged
}

// NewBACnetLiftCarDriveStatusTaggedBuilder() creates a BACnetLiftCarDriveStatusTaggedBuilder
func NewBACnetLiftCarDriveStatusTaggedBuilder() BACnetLiftCarDriveStatusTaggedBuilder {
	return &_BACnetLiftCarDriveStatusTaggedBuilder{_BACnetLiftCarDriveStatusTagged: new(_BACnetLiftCarDriveStatusTagged)}
}

type _BACnetLiftCarDriveStatusTaggedBuilder struct {
	*_BACnetLiftCarDriveStatusTagged

	err *utils.MultiError
}

var _ (BACnetLiftCarDriveStatusTaggedBuilder) = (*_BACnetLiftCarDriveStatusTaggedBuilder)(nil)

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLiftCarDriveStatus, proprietaryValue uint32) BACnetLiftCarDriveStatusTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLiftCarDriveStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftCarDriveStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithValue(value BACnetLiftCarDriveStatus) BACnetLiftCarDriveStatusTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetLiftCarDriveStatusTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLiftCarDriveStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLiftCarDriveStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLiftCarDriveStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) Build() (BACnetLiftCarDriveStatusTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLiftCarDriveStatusTagged.deepCopy(), nil
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) MustBuild() BACnetLiftCarDriveStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLiftCarDriveStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLiftCarDriveStatusTaggedBuilder().(*_BACnetLiftCarDriveStatusTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLiftCarDriveStatusTaggedBuilder creates a BACnetLiftCarDriveStatusTaggedBuilder
func (b *_BACnetLiftCarDriveStatusTagged) CreateBACnetLiftCarDriveStatusTaggedBuilder() BACnetLiftCarDriveStatusTaggedBuilder {
	if b == nil {
		return NewBACnetLiftCarDriveStatusTaggedBuilder()
	}
	return &_BACnetLiftCarDriveStatusTaggedBuilder{_BACnetLiftCarDriveStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLiftCarDriveStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLiftCarDriveStatusTagged) GetValue() BACnetLiftCarDriveStatus {
	return m.Value
}

func (m *_BACnetLiftCarDriveStatusTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetLiftCarDriveStatusTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetLiftCarDriveStatus_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLiftCarDriveStatusTagged(structType any) BACnetLiftCarDriveStatusTagged {
	if casted, ok := structType.(BACnetLiftCarDriveStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLiftCarDriveStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLiftCarDriveStatusTagged) GetTypeName() string {
	return "BACnetLiftCarDriveStatusTagged"
}

func (m *_BACnetLiftCarDriveStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetLiftCarDriveStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLiftCarDriveStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLiftCarDriveStatusTagged, error) {
	return BACnetLiftCarDriveStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLiftCarDriveStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarDriveStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarDriveStatusTagged, error) {
		return BACnetLiftCarDriveStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLiftCarDriveStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLiftCarDriveStatusTagged, error) {
	v, err := (&_BACnetLiftCarDriveStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLiftCarDriveStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLiftCarDriveStatusTagged BACnetLiftCarDriveStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLiftCarDriveStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLiftCarDriveStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLiftCarDriveStatus](ctx, "value", readBuffer, EnsureType[BACnetLiftCarDriveStatus](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetLiftCarDriveStatus_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetLiftCarDriveStatus_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetLiftCarDriveStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLiftCarDriveStatusTagged")
	}

	return m, nil
}

func (m *_BACnetLiftCarDriveStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLiftCarDriveStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLiftCarDriveStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLiftCarDriveStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLiftCarDriveStatus](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLiftCarDriveStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLiftCarDriveStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLiftCarDriveStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLiftCarDriveStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLiftCarDriveStatusTagged) IsBACnetLiftCarDriveStatusTagged() {}

func (m *_BACnetLiftCarDriveStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLiftCarDriveStatusTagged) deepCopy() *_BACnetLiftCarDriveStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetLiftCarDriveStatusTaggedCopy := &_BACnetLiftCarDriveStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLiftCarDriveStatusTaggedCopy
}

func (m *_BACnetLiftCarDriveStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
