/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLandingDoorStatusLandingDoorsList is the corresponding interface of BACnetLandingDoorStatusLandingDoorsList
type BACnetLandingDoorStatusLandingDoorsList interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetLandingDoors returns LandingDoors (property field)
	GetLandingDoors() []BACnetLandingDoorStatusLandingDoorsListEntry
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetLandingDoorStatusLandingDoorsList is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingDoorStatusLandingDoorsList()
	// CreateBuilder creates a BACnetLandingDoorStatusLandingDoorsListBuilder
	CreateBACnetLandingDoorStatusLandingDoorsListBuilder() BACnetLandingDoorStatusLandingDoorsListBuilder
}

// _BACnetLandingDoorStatusLandingDoorsList is the data-structure of this message
type _BACnetLandingDoorStatusLandingDoorsList struct {
	OpeningTag   BACnetOpeningTag
	LandingDoors []BACnetLandingDoorStatusLandingDoorsListEntry
	ClosingTag   BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetLandingDoorStatusLandingDoorsList = (*_BACnetLandingDoorStatusLandingDoorsList)(nil)

// NewBACnetLandingDoorStatusLandingDoorsList factory function for _BACnetLandingDoorStatusLandingDoorsList
func NewBACnetLandingDoorStatusLandingDoorsList(openingTag BACnetOpeningTag, landingDoors []BACnetLandingDoorStatusLandingDoorsListEntry, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetLandingDoorStatusLandingDoorsList {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetLandingDoorStatusLandingDoorsList must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetLandingDoorStatusLandingDoorsList must not be nil")
	}
	return &_BACnetLandingDoorStatusLandingDoorsList{OpeningTag: openingTag, LandingDoors: landingDoors, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLandingDoorStatusLandingDoorsListBuilder is a builder for BACnetLandingDoorStatusLandingDoorsList
type BACnetLandingDoorStatusLandingDoorsListBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, landingDoors []BACnetLandingDoorStatusLandingDoorsListEntry, closingTag BACnetClosingTag) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithLandingDoors adds LandingDoors (property field)
	WithLandingDoors(...BACnetLandingDoorStatusLandingDoorsListEntry) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetLandingDoorStatusLandingDoorsListBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLandingDoorStatusLandingDoorsListBuilder
	// Build builds the BACnetLandingDoorStatusLandingDoorsList or returns an error if something is wrong
	Build() (BACnetLandingDoorStatusLandingDoorsList, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLandingDoorStatusLandingDoorsList
}

// NewBACnetLandingDoorStatusLandingDoorsListBuilder() creates a BACnetLandingDoorStatusLandingDoorsListBuilder
func NewBACnetLandingDoorStatusLandingDoorsListBuilder() BACnetLandingDoorStatusLandingDoorsListBuilder {
	return &_BACnetLandingDoorStatusLandingDoorsListBuilder{_BACnetLandingDoorStatusLandingDoorsList: new(_BACnetLandingDoorStatusLandingDoorsList)}
}

type _BACnetLandingDoorStatusLandingDoorsListBuilder struct {
	*_BACnetLandingDoorStatusLandingDoorsList

	err *utils.MultiError
}

var _ (BACnetLandingDoorStatusLandingDoorsListBuilder) = (*_BACnetLandingDoorStatusLandingDoorsListBuilder)(nil)

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, landingDoors []BACnetLandingDoorStatusLandingDoorsListEntry, closingTag BACnetClosingTag) BACnetLandingDoorStatusLandingDoorsListBuilder {
	return b.WithOpeningTag(openingTag).WithLandingDoors(landingDoors...).WithClosingTag(closingTag)
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetLandingDoorStatusLandingDoorsListBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetLandingDoorStatusLandingDoorsListBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithLandingDoors(landingDoors ...BACnetLandingDoorStatusLandingDoorsListEntry) BACnetLandingDoorStatusLandingDoorsListBuilder {
	b.LandingDoors = landingDoors
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetLandingDoorStatusLandingDoorsListBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetLandingDoorStatusLandingDoorsListBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) WithArgTagNumber(tagNumber uint8) BACnetLandingDoorStatusLandingDoorsListBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) Build() (BACnetLandingDoorStatusLandingDoorsList, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLandingDoorStatusLandingDoorsList.deepCopy(), nil
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) MustBuild() BACnetLandingDoorStatusLandingDoorsList {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingDoorStatusLandingDoorsListBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLandingDoorStatusLandingDoorsListBuilder().(*_BACnetLandingDoorStatusLandingDoorsListBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLandingDoorStatusLandingDoorsListBuilder creates a BACnetLandingDoorStatusLandingDoorsListBuilder
func (b *_BACnetLandingDoorStatusLandingDoorsList) CreateBACnetLandingDoorStatusLandingDoorsListBuilder() BACnetLandingDoorStatusLandingDoorsListBuilder {
	if b == nil {
		return NewBACnetLandingDoorStatusLandingDoorsListBuilder()
	}
	return &_BACnetLandingDoorStatusLandingDoorsListBuilder{_BACnetLandingDoorStatusLandingDoorsList: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetLandingDoors() []BACnetLandingDoorStatusLandingDoorsListEntry {
	return m.LandingDoors
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLandingDoorStatusLandingDoorsList(structType any) BACnetLandingDoorStatusLandingDoorsList {
	if casted, ok := structType.(BACnetLandingDoorStatusLandingDoorsList); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLandingDoorStatusLandingDoorsList); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetTypeName() string {
	return "BACnetLandingDoorStatusLandingDoorsList"
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.LandingDoors) > 0 {
		for _, element := range m.LandingDoors {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLandingDoorStatusLandingDoorsListParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetLandingDoorStatusLandingDoorsList, error) {
	return BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetLandingDoorStatusLandingDoorsListParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingDoorStatusLandingDoorsList, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingDoorStatusLandingDoorsList, error) {
		return BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetLandingDoorStatusLandingDoorsList, error) {
	v, err := (&_BACnetLandingDoorStatusLandingDoorsList{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetLandingDoorStatusLandingDoorsList BACnetLandingDoorStatusLandingDoorsList, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLandingDoorStatusLandingDoorsList"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLandingDoorStatusLandingDoorsList")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	landingDoors, err := ReadTerminatedArrayField[BACnetLandingDoorStatusLandingDoorsListEntry](ctx, "landingDoors", ReadComplex[BACnetLandingDoorStatusLandingDoorsListEntry](BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'landingDoors' field"))
	}
	m.LandingDoors = landingDoors

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetLandingDoorStatusLandingDoorsList"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLandingDoorStatusLandingDoorsList")
	}

	return m, nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLandingDoorStatusLandingDoorsList"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLandingDoorStatusLandingDoorsList")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "landingDoors", m.GetLandingDoors(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'landingDoors' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLandingDoorStatusLandingDoorsList"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLandingDoorStatusLandingDoorsList")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLandingDoorStatusLandingDoorsList) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetLandingDoorStatusLandingDoorsList) IsBACnetLandingDoorStatusLandingDoorsList() {}

func (m *_BACnetLandingDoorStatusLandingDoorsList) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) deepCopy() *_BACnetLandingDoorStatusLandingDoorsList {
	if m == nil {
		return nil
	}
	_BACnetLandingDoorStatusLandingDoorsListCopy := &_BACnetLandingDoorStatusLandingDoorsList{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetLandingDoorStatusLandingDoorsListEntry, BACnetLandingDoorStatusLandingDoorsListEntry](m.LandingDoors),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetLandingDoorStatusLandingDoorsListCopy
}

func (m *_BACnetLandingDoorStatusLandingDoorsList) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
