/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLandingCallStatusCommand is the corresponding interface of BACnetLandingCallStatusCommand
type BACnetLandingCallStatusCommand interface {
	BACnetLandingCallStatusCommandContract
	BACnetLandingCallStatusCommandRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetLandingCallStatusCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingCallStatusCommand()
	// CreateBuilder creates a BACnetLandingCallStatusCommandBuilder
	CreateBACnetLandingCallStatusCommandBuilder() BACnetLandingCallStatusCommandBuilder
}

// BACnetLandingCallStatusCommandContract provides a set of functions which can be overwritten by a sub struct
type BACnetLandingCallStatusCommandContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetLandingCallStatusCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingCallStatusCommand()
	// CreateBuilder creates a BACnetLandingCallStatusCommandBuilder
	CreateBACnetLandingCallStatusCommandBuilder() BACnetLandingCallStatusCommandBuilder
}

// BACnetLandingCallStatusCommandRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetLandingCallStatusCommandRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetLandingCallStatusCommand is the data-structure of this message
type _BACnetLandingCallStatusCommand struct {
	_SubType interface {
		BACnetLandingCallStatusCommandContract
		BACnetLandingCallStatusCommandRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetLandingCallStatusCommandContract = (*_BACnetLandingCallStatusCommand)(nil)

// NewBACnetLandingCallStatusCommand factory function for _BACnetLandingCallStatusCommand
func NewBACnetLandingCallStatusCommand(peekedTagHeader BACnetTagHeader) *_BACnetLandingCallStatusCommand {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetLandingCallStatusCommand must not be nil")
	}
	return &_BACnetLandingCallStatusCommand{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLandingCallStatusCommandBuilder is a builder for BACnetLandingCallStatusCommand
type BACnetLandingCallStatusCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetLandingCallStatusCommandBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetLandingCallStatusCommandBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLandingCallStatusCommandBuilder
	// AsBACnetLandingCallStatusCommandDirection converts this build to a subType of BACnetLandingCallStatusCommand. It is always possible to return to current builder using Done()
	AsBACnetLandingCallStatusCommandDirection() BACnetLandingCallStatusCommandDirectionBuilder
	// AsBACnetLandingCallStatusCommandDestination converts this build to a subType of BACnetLandingCallStatusCommand. It is always possible to return to current builder using Done()
	AsBACnetLandingCallStatusCommandDestination() BACnetLandingCallStatusCommandDestinationBuilder
	// Build builds the BACnetLandingCallStatusCommand or returns an error if something is wrong
	PartialBuild() (BACnetLandingCallStatusCommandContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetLandingCallStatusCommandContract
	// Build builds the BACnetLandingCallStatusCommand or returns an error if something is wrong
	Build() (BACnetLandingCallStatusCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLandingCallStatusCommand
}

// NewBACnetLandingCallStatusCommandBuilder() creates a BACnetLandingCallStatusCommandBuilder
func NewBACnetLandingCallStatusCommandBuilder() BACnetLandingCallStatusCommandBuilder {
	return &_BACnetLandingCallStatusCommandBuilder{_BACnetLandingCallStatusCommand: new(_BACnetLandingCallStatusCommand)}
}

type _BACnetLandingCallStatusCommandChildBuilder interface {
	utils.Copyable
	setParent(BACnetLandingCallStatusCommandContract)
	buildForBACnetLandingCallStatusCommand() (BACnetLandingCallStatusCommand, error)
}

type _BACnetLandingCallStatusCommandBuilder struct {
	*_BACnetLandingCallStatusCommand

	childBuilder _BACnetLandingCallStatusCommandChildBuilder

	err *utils.MultiError
}

var _ (BACnetLandingCallStatusCommandBuilder) = (*_BACnetLandingCallStatusCommandBuilder)(nil)

func (b *_BACnetLandingCallStatusCommandBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetLandingCallStatusCommandBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetLandingCallStatusCommandBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetLandingCallStatusCommandBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetLandingCallStatusCommandBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLandingCallStatusCommandBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingCallStatusCommandBuilder) PartialBuild() (BACnetLandingCallStatusCommandContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLandingCallStatusCommand.deepCopy(), nil
}

func (b *_BACnetLandingCallStatusCommandBuilder) PartialMustBuild() BACnetLandingCallStatusCommandContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingCallStatusCommandBuilder) AsBACnetLandingCallStatusCommandDirection() BACnetLandingCallStatusCommandDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetLandingCallStatusCommandDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetLandingCallStatusCommandDirectionBuilder().(*_BACnetLandingCallStatusCommandDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLandingCallStatusCommandBuilder) AsBACnetLandingCallStatusCommandDestination() BACnetLandingCallStatusCommandDestinationBuilder {
	if cb, ok := b.childBuilder.(BACnetLandingCallStatusCommandDestinationBuilder); ok {
		return cb
	}
	cb := NewBACnetLandingCallStatusCommandDestinationBuilder().(*_BACnetLandingCallStatusCommandDestinationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetLandingCallStatusCommandBuilder) Build() (BACnetLandingCallStatusCommand, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetLandingCallStatusCommand()
}

func (b *_BACnetLandingCallStatusCommandBuilder) MustBuild() BACnetLandingCallStatusCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingCallStatusCommandBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLandingCallStatusCommandBuilder().(*_BACnetLandingCallStatusCommandBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetLandingCallStatusCommandChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLandingCallStatusCommandBuilder creates a BACnetLandingCallStatusCommandBuilder
func (b *_BACnetLandingCallStatusCommand) CreateBACnetLandingCallStatusCommandBuilder() BACnetLandingCallStatusCommandBuilder {
	if b == nil {
		return NewBACnetLandingCallStatusCommandBuilder()
	}
	return &_BACnetLandingCallStatusCommandBuilder{_BACnetLandingCallStatusCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLandingCallStatusCommand) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetLandingCallStatusCommand) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLandingCallStatusCommand(structType any) BACnetLandingCallStatusCommand {
	if casted, ok := structType.(BACnetLandingCallStatusCommand); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLandingCallStatusCommand); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLandingCallStatusCommand) GetTypeName() string {
	return "BACnetLandingCallStatusCommand"
}

func (m *_BACnetLandingCallStatusCommand) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetLandingCallStatusCommand) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetLandingCallStatusCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetLandingCallStatusCommandParse[T BACnetLandingCallStatusCommand](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetLandingCallStatusCommandParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetLandingCallStatusCommandParseWithBufferProducer[T BACnetLandingCallStatusCommand]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetLandingCallStatusCommandParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetLandingCallStatusCommandParseWithBuffer[T BACnetLandingCallStatusCommand](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetLandingCallStatusCommand{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetLandingCallStatusCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetLandingCallStatusCommand BACnetLandingCallStatusCommand, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLandingCallStatusCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLandingCallStatusCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetLandingCallStatusCommand
	switch {
	case peekedTagNumber == uint8(1): // BACnetLandingCallStatusCommandDirection
		if _child, err = new(_BACnetLandingCallStatusCommandDirection).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLandingCallStatusCommandDirection for type-switch of BACnetLandingCallStatusCommand")
		}
	case peekedTagNumber == uint8(2): // BACnetLandingCallStatusCommandDestination
		if _child, err = new(_BACnetLandingCallStatusCommandDestination).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetLandingCallStatusCommandDestination for type-switch of BACnetLandingCallStatusCommand")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetLandingCallStatusCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLandingCallStatusCommand")
	}

	return _child, nil
}

func (pm *_BACnetLandingCallStatusCommand) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetLandingCallStatusCommand, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLandingCallStatusCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLandingCallStatusCommand")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetLandingCallStatusCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLandingCallStatusCommand")
	}
	return nil
}

func (m *_BACnetLandingCallStatusCommand) IsBACnetLandingCallStatusCommand() {}

func (m *_BACnetLandingCallStatusCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLandingCallStatusCommand) deepCopy() *_BACnetLandingCallStatusCommand {
	if m == nil {
		return nil
	}
	_BACnetLandingCallStatusCommandCopy := &_BACnetLandingCallStatusCommand{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetLandingCallStatusCommandCopy
}
